/************************************************************************
 * FILE:        dabdrv_advisory.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_advisory
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"
#include "dabdrv_mecaIf.h"
#include "dabdrv_chnInfo.hpp"
#include "dabdrv_compInfo.hpp"
#include "dabdrv_advisory.hpp"
#include "dabdrv_rdm.hpp"
#include "dabdrv_presets.hpp"
#include "dabdrv_chnList.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_SRV
#include "trcGenProj/Header/dabdrv_advisory.cpp.trc.h"
#endif

// todo: remove

/* provides information about the currently selected channel.
   - PSID
   - Label
   - Song/Artist (Radio-Text)
   - FrozenListId
*/

/*
  todo: add timer-handling also to comp-info
*/
using namespace DAB;

namespace DAB {
    struct dabdrv_msgAdvisoryTimer:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL


        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  dabdrv_msgAdvisoryTimer"));
        };

    };

}


dabdrv_advisory::dabdrv_advisory(tVoid) {
    _enChnState=enChnState_Invalid;
    _enLastSentChnState=enChnState_Invalid;
    _bChnSelectActive=FALSE;
    _bCompSelectActive=FALSE;
    _enSourceState = DAB_enSourceState_FG;
    _bSrvFollow = FALSE;
}

dabdrv_advisory::~dabdrv_advisory(tVoid) {

}    
tVoid dabdrv_advisory::vInit(tVoid) {

    _oAdvisoryTimer.vInit(instance(),dabdrv_msgAdvisoryTimer());

    // subsribe
    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();
    vSubscribe<trMsgDrvCmdSourceState>();
    vSubscribe<trMeca_RRdmGetRdmInfo>();
    vSubscribe<trMsgDrvCmdChnSelectState>();
    vSubscribe<trMsgDrvIndPreChnSelect>();
    vSubscribe<trMsgDrvFmServiceFollow>();
    vSubscribe<trMeca_RRdmAudioPlayAsid>();
	vSubscribe<trMeca_RRdmAudioComponentPlay>();
    vTraceState();
}
    
tVoid dabdrv_advisory::vDeInit() {
    _oAdvisoryTimer.vDeInit();

}


tVoid dabdrv_advisory::vTraceState() const {

    ETG_TRACE_USR1(("  dabdrv_advisory STATE: _enChnState=%d TmrRunning=%d  " 
                    "_bChnSelectActive=%d _bCompSelectActive=%d" ,
                    ETG_CENUM(tenChnState, _enChnState),
                    _oAdvisoryTimer.bIsRunning(),
                    _bChnSelectActive,
                    _bCompSelectActive));

}

tVoid dabdrv_advisory::vProcess(trMsgDrvStartComponent* poStart) {
    (tVoid)poStart;   
}

tVoid dabdrv_advisory::vProcess(trMsgDrvStopComponent* poStop) {
    (tVoid)poStop;  
    _oAdvisoryTimer.vStop();
    _enChnState = enChnState_Unavail;
    _bChnSelectActive=FALSE;
    _bCompSelectActive=FALSE;
    vUpdate();
}


tVoid dabdrv_advisory::vUpdate() const {

    tenChnState enChnState= _enChnState;
    tBool bMuted=TRUE;

    if ((_bSrvFollow)&&(enChnState!=enChnState_Stable)) {
        enChnState=enChnState_Stable;
        bMuted=FALSE;
    } else if (enChnState==enChnState_Stable) {
        bMuted= dabdrv_rdm::instance()->rGetLastRdmInfo().rRdmStatus.bIsMuted();
    }

    DAB_trChnStateProperty rProperty=dabdrv_properties::instance()->oChnStateProperty.oGet();
    ETG_TRACE_USR4(("dabdrv_advisory::vUpdate: enChnState=%d bMuted=%d _bSrvFollow=%d",
                    ETG_CENUM(tenChnState, enChnState),
                    bMuted,
                    _bSrvFollow));

    rProperty.enChnState=enChnState;
    rProperty.bMuted=bMuted;
    dabdrv_properties::instance()->oChnStateProperty.vSet(rProperty);

        //clear the radiotext
}

tVoid dabdrv_advisory::vProcess(trMeca_RRdmGetRdmInfo const *poRdmInfo) {
    (tVoid)poRdmInfo;

	DAB_trChnInfoProperty rChnInfoProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
	tU32 tU32srvID = rChnInfoProperty.rMecaId._u32Id;
	tU8 u8ECC =(tU8) (tU32srvID >>16);
	u8ECC &= 0xFF;	
	tU32 u32rdmSid = poRdmInfo->rProgrammeService._u32Id;
	tU8 u8rdmECC = (tU8)(u32rdmSid >>16);
	u8rdmECC &= 0xFF;

	tBool bStateUpadte = (u8ECC && u8rdmECC);


    if (dabdrv_main::instance()->bActivityChangedChannel() 
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
			||!poRdmInfo->rProgrammeService.bIsValid()|| poRdmInfo->rProgrammeService._u32Id != tU32srvID
		#endif
			) 

	{
        ETG_TRACE_USR4(("dabdrv_advisory::trMeca_RRdmGetRdmInfo Ignore (bActivityChangedChannel) tU32srvID=%d",tU32srvID));
        return;
    }


    if((bIsRdmOk()) && ((bStateUpadte) ? (poRdmInfo->rProgrammeService._u32Id == rChnInfoProperty.rMecaId._u32Id) : (poRdmInfo->rProgrammeService.u16GetSID() == rChnInfoProperty.rMecaId.u16GetSID()))){
        _enChnState=enChnState_Stable;
        _oAdvisoryTimer.vStop();
    }
//NCG3D-57390 - Sending Selecting and Selecting Wait state for IVI and sending immediate Unavailable state for PSA.
	else if (
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		((_enChnState==enChnState_Unavail) || (_enChnState==enChnState_Stable))
#else
		(_enChnState==enChnState_Stable)
#endif
		&& !_oAdvisoryTimer.bIsRunning()) {
        if((_enSourceState == DAB_enSourceState_FG) && ((bStateUpadte) ? (poRdmInfo->rProgrammeService._u32Id == rChnInfoProperty.rMecaId._u32Id) : (poRdmInfo->rProgrammeService.u16GetSID() == rChnInfoProperty.rMecaId.u16GetSID()))){

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
			/*Unavail status sent immediately*/
			_enChnState= enChnState_Unavail;
#else
			ETG_TRACE_USR4(("dabdrv_advisory::_oAdvisoryTimer.vStart(LOADING)"));
			_oAdvisoryTimer.vStart(DAB_CHN_INFO_LOADING_TIMER_MS);
			_enChnState= enChnState_Selecting;
#endif
        } else {

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
			/*Unavail status sent immediately*/
			_enChnState= enChnState_Unavail;
#else
			ETG_TRACE_USR4(("dabdrv_advisory::_oAdvisoryTimer.vStart(UNAVAIL)"));        
			_oAdvisoryTimer.vStart(DAB_CHN_INFO_UNAVAIL_TIMER_MS);
			_enChnState= enChnState_SelectingWait;
#endif
        }
    }
    vUpdate();

}


tVoid dabdrv_advisory::vProcess(trMsgDrvCmdSourceState *poSourceState) {
    if (_enSourceState == DAB_enSourceState_FG_TA) {
        return;
    }
    _enSourceState = poSourceState->enSourceState;
    vClearAdvisory();
    vUpdate();
}

tVoid dabdrv_advisory::vProcess(dabdrv_msgAdvisoryTimer *poTimeOutMsg) {
    (tVoid)poTimeOutMsg;
    tBool bDoUpdate=FALSE;
    switch (_enChnState) {
        case enChnState_Selecting:
            ETG_TRACE_USR4(("dabdrv_advisory::dabdrv_msgAdvisoryTimer enChnState_Selecting --> enChnState_SelectingWait"));
            _oAdvisoryTimer.vStart(DAB_CHN_INFO_UNAVAIL_TIMER_MS);
            _enChnState= enChnState_SelectingWait;
            bDoUpdate=TRUE;
            break;
        case enChnState_SelectingWait:
            ETG_TRACE_USR4(("dabdrv_advisory::dabdrv_msgAdvisoryTimer enChnState_SelectingWait --> enChnState_Unavail"));
            _enChnState=enChnState_Unavail;
            bDoUpdate=TRUE;
            break;
        case enChnState_Stable:
            ETG_TRACE_USR4(("dabdrv_advisory::dabdrv_msgAdvisoryTimer enChnState_Stable --> enChnState_Unavail"));
            
            break;
        case enChnState_SelectingSearch:
        case enChnState_Unavail:
        case enChnState_Invalid:
        default:
            break;
    }
    if (bDoUpdate) {
        vUpdate();
    }
            

}

tBool dabdrv_advisory::bIsRdmOk() const {
	
    //return TRUE;   //Workaround by Surekha for making dab service available always
    tBool bCompMode=dabdrv_main::instance()->bIsCompMode();
    trMeca_RRdmGetRdmInfo rRdmInfo=dabdrv_rdm::instance()->rGetLastRdmInfo();
    ETG_TRACE_USR4(("dabdrv_advisory::bIsRdmOk: bIsSelectActive=%d bIsMuted=%d bIsSync=%d bCompMode=%d "
                    "curSid=0x%08x rdmSid=0x%08x  curScidi=0x%04x rdmScidi=0x%04x RDM-INFO follows",
                    bIsSelectActive(), 
                    rRdmInfo.rRdmStatus.bIsMuted(), 
                    rRdmInfo.rRdmStatus.bIsSync(), 
                    bCompMode, 
                    rGetCurrentPsid().u32GetSID(), 
                    rRdmInfo.rProgrammeService.u32GetSID(),
                    rGetCurrentScidi().u32GetSID(),
                    rRdmInfo.u16SCIDI));
    dabdrv_rdm::instance()->rGetLastRdmInfo().vTrace();
    ETG_TRACE_USR4(("dabdrv_advisory::bIsRdmOk: RDM-INFO END"));
    

    if (rRdmInfo.rRdmStatus.bIsSync()) {
        //545319:  sync status will be send as true only when the selected service exists in current available ensemble.
        bool bIsSrvExists = dabdrv_chnList::instance()->bIsEnsembleContainsService(rRdmInfo.rEnsemble,rRdmInfo.rProgrammeService);
        if (bIsSrvExists)
        {
            ETG_TRACE_USR4(("dabdrv_advisory::bIsRdmOk: return TRUE"));
            ETG_TRACE_USR4(("dabdrv_advisory::service:0x%08x exists in current ensemble:0x%08x",rRdmInfo.rProgrammeService._u32Id,rRdmInfo.rEnsemble.u32GetID()));
            return TRUE;
        }
        else
        {
            ETG_TRACE_USR4(("dabdrv_advisory::service:0x%08x does not exists in current ensemble:0x%08x",rRdmInfo.rProgrammeService._u32Id,rRdmInfo.rEnsemble.u32GetID()));
        }
    }
    ETG_TRACE_USR4(("dabdrv_advisory::bIsRdmOk: return FALSE"));
    return FALSE;

}



tVoid dabdrv_advisory::vProcess(trMsgDrvIndPreChnSelect *poChnSelectIndPre) {
    (tVoid)poChnSelectIndPre;
	ETG_TRACE_USR1(("  dabdrv_advisory:vProcess(trMsgDrvIndPreChnSelect)"));
    _bChnSelectActive=FALSE;
    _bCompSelectActive=FALSE;
}


tVoid dabdrv_advisory::vProcess(trMsgDrvCmdChnSelectState *poCmdChnSelectState) {
    tBool bOldChnSelectActive=_bChnSelectActive;
    tBool bOldCompSelectActive=_bCompSelectActive;
    tBool bOldSelecting=(bOldChnSelectActive || bOldCompSelectActive);
    tBool bNewSelecting=bIsChnStateSelecting(poCmdChnSelectState->enChnState);



    if (poCmdChnSelectState->bCompMode) {
        _bCompSelectActive=bNewSelecting;
    } else if (!dabdrv_main::instance()->bIsCompMode()) {
            _bChnSelectActive=bNewSelecting;
    } else if (bNewSelecting) {
        // we are in comp-mode but have to select the primary service first.
        // but we won't delete the selecting-flag
            _bChnSelectActive=bNewSelecting;        
    }

    if (_bCompSelectActive) {
        _bChnSelectActive=FALSE;
    }
    bNewSelecting=_bCompSelectActive || _bChnSelectActive;

    ETG_TRACE_USR4(("dabdrv_advisory::trMsgDrvCmdChnSelectState: bOldChnSelectActive=%d bOldCompSelectActive=%d bNewSelecting=%d bOldSelecting=%d",
                    bOldChnSelectActive,
                    bOldCompSelectActive,
                    bNewSelecting,
                    bOldSelecting));
    if (bNewSelecting==bOldSelecting) {
        return;
    }
    if (bNewSelecting) {
        _bSrvFollow = FALSE;
        _enChnState=enChnState_Selecting;
        ETG_TRACE_USR4(("dabdrv_advisory::trMsgDrvCmdChnSelectState: newSelecting _oAdvisoryTimer.vStart(LOADING)"));        
        _oAdvisoryTimer.vStart(DAB_CHN_INFO_LOADING_TIMER_MS);
        vUpdate();
    } else {
        // selection done, switch to rdm-info
        ETG_TRACE_USR4(("dabdrv_advisory::trMsgDrvCmdChnSelectState: switch to rdm-info"));        
        DAB_vCallMsg(this, dabdrv_rdm::instance()->rGetLastRdmInfo());        
    }
}


tVoid dabdrv_advisory::vProcess(trMsgDrvFmServiceFollow* poFmServiceFollow) {

    _bSrvFollow=poFmServiceFollow->bFmSrvFollowActive;

    ETG_TRACE_USR4(("  dabdrv_advisory::vProcess(trMsgDrvFmServiceFollow) _bSrvFollow=%d",
                            _bSrvFollow));

    if(_bSrvFollow) {
        vClearAdvisory();
        vUpdate();
    }
}


trMecaId dabdrv_advisory::rGetCurrentPsid() const {
    return dabdrv_chnInfo::instance()->rGetCurrentSid();
}

trMecaId dabdrv_advisory::rGetCurrentScidi() const {
    return dabdrv_compInfo::instance()->rGetCompInfo().rMecaId;
}

trMecaId dabdrv_advisory::rGetCurrentMecaId() const {
    trMecaId rMecaId;
    if (dabdrv_main::instance()->bIsCompMode()) {
        return rGetCurrentScidi();
    } else {
        return rGetCurrentPsid();
    }
}

tVoid dabdrv_advisory::vProcess(trMeca_RRdmAudioPlayAsid* poMecaRRdmPlayPsid) {
    ETG_TRACE_USR1(("  dabdrv_advisory:vProcess(trMeca_RRdmAudioPlayAsid) enServiceState=%d",
                        ETG_CENUM(tenMeca_RdmServiceState,poMecaRRdmPlayPsid->enServiceState)));
    switch (poMecaRRdmPlayPsid->enServiceState) {
        case enMeca_RdmServiceState_SERVICE_SELECTION_DONE:
        {
			DAB_trChnInfoProperty rChnInfoProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
			tU32 u32srvID = rChnInfoProperty.rMecaId._u32Id;
			tU8 u8ECC = (tU8)(u32srvID >>16);
			u8ECC &= 0xFF;
			tU32 u32rdmSid = poMecaRRdmPlayPsid->rMecaProgrammeService._u32Id;
			tU8 u8rdmECC = (tU8)(u32rdmSid >>16);
			u8rdmECC &= 0xFF;
			tBool bStateUpadte = (u8ECC && u8rdmECC);
			//for NCG3D-124735
			if ((bStateUpadte) ? (poMecaRRdmPlayPsid->rMecaProgrammeService._u32Id == rChnInfoProperty.rMecaId._u32Id) : (poMecaRRdmPlayPsid->rMecaProgrammeService.u16GetSID() == rChnInfoProperty.rMecaId.u16GetSID()))
			{
				if  (bIsRdmOk())
					_enChnState = enChnState_Stable;
				else
					_enChnState = enChnState_Unavail;

				_oAdvisoryTimer.vStop();
				vUpdate();
			}
			break;
			
        }
        case enMeca_RdmServiceState_SERVICE_INVALID:
        case enMeca_RdmServiceState_PSID_NOT_AVAILABLE:
		{
        	_enChnState=enChnState_Unavail;
        	vUpdate();
        	break;
        }
		case enMeca_RdmServiceState_WAITING_FOR_SERVICE:
        default:
        {;}
    }
}
tVoid dabdrv_advisory::vProcess(trMeca_RRdmAudioComponentPlay* poMecaRRdmPlayScidi) {
ETG_TRACE_USR1(("  dabdrv_advisory:vProcess(trMeca_RRdmAudioComponentPlay) poMecaRRdmPlayScidi->bComponentOk = %d",
                        poMecaRRdmPlayScidi->bComponentOk));
	if (poMecaRRdmPlayScidi->bComponentOk) 
		{
			_enChnState=enChnState_Stable;
            _oAdvisoryTimer.vStop();
            vUpdate();
		}
}
