/************************************************************************
 * FILE:        dabdrv_adrIf.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_adrIf
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_ADRIF_HPP
#define DABDRV_ADRIF_HPP

#include "fc_dabtuner_config.h"
#include "dabdrv_meca.h"

#define DABDRV_IPN_SEM_NAME "DABDRV_IPN_SEM"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_ADRIF 
#include "trcGenProj/Header/dabdrv_adrIf.hpp.trc.h"
#endif

#define DAB_ADR_DEFAULT_ANSWER_WAIT_MS (1000 * DAB_TIME_FACTOR)

#define DAB_DRVADRIF_CONF_ADR_CONTROL_DRIVER_NAME             "/dev/adr3ctrl"
#define DAB_DRVADRIF_CONF_ADR3_MAXRESET_COUNTER                1

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
#include "AarsDBusProxy/AarsDBusProxyInterface.h"
using namespace tuner::AarsDBusProxy;
#endif

#include "DatagramSocketCallbackIf.h"
#include "DatagramSocket.h"
namespace DAB {



    typedef enum {
        en_MecaSendMode_Normal,
        en_MecaSendMode_WaitAnswer,
        en_MecaSendMode_Block,
        en_MecaSendMode_NoDmb
    }ten_MecaSendMode;

        struct trMecaSendSvInfo {
            ten_MecaSendMode enSendMode;
            tU32 u32TimeOutMs;
            DAB_Message *poMsg;
            DAB_MsgCallerBase *poMsgCaller;
            DAB_tenMsgPrio enMecaSendPrio;
            trMecaSendSvInfo():
                enSendMode(en_MecaSendMode_Normal),
                u32TimeOutMs(0),
                poMsg(OSAL_NULL),
                poMsgCaller(OSAL_NULL),
                enMecaSendPrio(DAB_eMsgPrioNormal)
            {}
            template<class MH, class M>
                trMecaSendSvInfo(ten_MecaSendMode enSendMode_, tU32 u32TimeOutMs_, MH const *pMh, M *poMsg_):
                    enSendMode(enSendMode_),
                    u32TimeOutMs(u32TimeOutMs_),
                    poMsgCaller(DAB_poGetMsgCaller<MH,M>()),
                    enMecaSendPrio(DAB_eMsgPrioNormal)
            {
                (tVoid)pMh;
                if (OSAL_NULL !=poMsg_) {
                    poMsg=new M(*poMsg_);
                } else {
                    poMsg=new M;
                }

            }
            trMecaSendSvInfo(ten_MecaSendMode enSendMode_, tU32 u32TimeOutMs_=DAB_ADR_DEFAULT_ANSWER_WAIT_MS):
                    enSendMode(enSendMode_),
                    u32TimeOutMs(u32TimeOutMs_),
                    poMsg(OSAL_NULL),
                    poMsgCaller(OSAL_NULL),
                    enMecaSendPrio(DAB_eMsgPrioNormal)
            {}

            ~trMecaSendSvInfo() {
                poMsg=OSAL_NULL;
                poMsgCaller=OSAL_NULL;
            }
            tVoid vClear() {
                if (OSAL_NULL != poMsg) {
                    OSAL_DELETE poMsg;
                }
                poMsg=OSAL_NULL;
                poMsgCaller=OSAL_NULL;
                u32TimeOutMs=0;
                enSendMode=en_MecaSendMode_Normal;
            }
            tVoid vSetPrio(DAB_tenMsgPrio enMecaSendPrio_) {
                enMecaSendPrio=enMecaSendPrio_;
            }
        };


    struct trMsgAdrOutput:
        public DAB_Message 
    {
        DAB_DISPATCH_IMPL
        trMsgAdrOutput() {
			for(tU16 u16Index=0;u16Index<DABDRV_IPN_HDR_LEN;u16Index++){
				au8Spare[u16Index]=0;
			}
			for(tU16 u16Index=0;u16Index<DABDRV_MAX_ADR_OUT_LEN;u16Index++){
				au8AdrMsg[u16Index]=0;
			}
            u32Len=0;
            u16FBlockId=DAB_FBLOCK_ID;
            u16WaitAnswer=0;
            u32MecaRefId=0;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  dabdrv_trMsgAdrOutput: u16WaitAnswer=0x%04x u32MecaRefId=%d",
                                u16WaitAnswer, u32MecaRefId));
        };
        tU8 au8Spare[DABDRV_IPN_HDR_LEN];
        tU8 au8AdrMsg[(tU16)DABDRV_MAX_ADR_OUT_LEN];
        tU32 u32Len;
        tU16 u16FBlockId;
        tU16 u16WaitAnswer;
        tU32 u32MecaRefId;
        trMecaSendSvInfo oSendInfo;
    };


    struct trMsgResetAdr:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL


        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgResetAdr"));
        };
    };

    struct trMsgDeblockAdrIf:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL


        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgDeblockAdrIf"));
        };
    };


    struct trMsgIpnEvent:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgIpnEvent"));
        };
    };

    typedef enum {
        enIpnError_AdrLost,
        enIpnError_TxError,
        enIpnError_RxError
    } tenIpnError;

    // a timer-event
    struct trMsgIpnError:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        trMsgIpnError(tenIpnError enIpnError_) {
            enIpnError = enIpnError_;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgIpnError: error=%x",
                                ETG_CENUM(tenIpnError, enIpnError)));
        };
        tenIpnError enIpnError;
    };

    struct trMeca_RConSetWatchDog:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            (tVoid)pu8Data;
            if (rMostHdr._u16MecaLen != 1) {
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            bEnable = pu8Data[0] ? TRUE : FALSE;
            return TRUE;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR4(("  trMeca_RConSetWatchDog:bEnable=%d",
                            bEnable));
        };
        tBool bEnable;
    };

    struct trMsgAdrMsgReceived:
        public DAB_Message {
        DAB_DISPATCH_IMPL
        trMsgAdrMsgReceived()
        {};
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgAdrMsgReceived"));
        };
        };
        struct trMsgRestartSBRProcess:
            public DAB_Message {
            DAB_DISPATCH_IMPL
			trMsgRestartSBRProcess(tBool bEnable_)
            {
            	bEnable = bEnable_;
            };
            virtual tVoid vTrace() const {
                ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG,
                                    "  trMsgRestartSBRProcess"));
            };
            tBool bEnable;
    };

    /*============================================================================
    * ADR state
    *--------------------------------------------------------------------------*/
    typedef enum
    {
        enADRState_INIT             = 0x00,
        enADRState_DEAD             = 0x01,
        enADRState_ALIVE            = 0x02,
        enADRState_DNL              = 0x03,
        enADRState_Unknown          = 0xFF
    } dab_tenADRState;
    /*==========================================================================*/

    typedef enum {
        enAdrStatus_Init            = enADRState_INIT,
        enAdrStatus_Dead            = enADRState_DEAD,
        enAdrStatus_Alive           = enADRState_ALIVE,
        enAdrStatus_Dnl             = enADRState_DNL,
        enAdrStatus_Unknown         = enADRState_Unknown
    } tenAdrStatus;
 


    // a timer-event
    struct trMsgAdrStatus:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        trMsgAdrStatus(tenAdrStatus enAdrStatus_) {
            enAdrStatus = enAdrStatus_;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgAdrStatus: enAdrStatus=%x",
                                	enAdrStatus));
        };
        tenAdrStatus enAdrStatus;
    };

    struct trMsgAdrSupervisionTimeOut;
    struct trMsgAdrMsgReceived;
    struct trMsgAdrIfBlockSvTimeOut;
    struct trMsgIpnCon;
	struct trMsgSocketExpiryTimer;

	
	
    class dabdrv_adrIf:
        public DAB_Singleton <dabdrv_adrIf>,
        public DAB_MessageHandlerCommon<dabdrv_adrIf>,
		public DatagramSocketCallbackIf
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
        ,public AarsDBusProxyInterface
#endif
    {
        friend class DAB_Singleton<dabdrv_adrIf>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_ADRIF);
        virtual ~dabdrv_adrIf(tVoid);  
        virtual tVoid vInit(tVoid);
        virtual tVoid vDeInit(tVoid);
        virtual tVoid vStartAdrCommunication(tVoid);
        virtual tVoid vStopAdrCommunication(tVoid);
  
        tVoid vClose();

        virtual char const *pcGetName() const {return "dabdrv_adrIf";};
        virtual tVoid vTraceState() const;

        virtual tVoid vProcess(trMsgAdrOutput* poMsgAdrOutput);
        virtual tVoid vProcess(trMsgResetAdr* poMsgResetAdr);
        virtual tVoid vProcess(trMsgDeblockAdrIf* poMsgDeblockAdrIf);

        virtual tVoid vProcess(trMsgIpnCon *prIpnCon);

        virtual tVoid vProcess(trMeca_RConSetWatchDog *poSetWatchDog);
        virtual tVoid vProcess(trMsgAdrSupervisionTimeOut* poAdrSupervsionTimeOut);
        virtual tVoid vProcess(trMsgAdrMsgReceived* poAdrMsgReceived);
        virtual tVoid vProcess(trMsgAdrIfBlockSvTimeOut *poBlockSvTimer);
		virtual tVoid vProcess(trMsgSocketExpiryTimer *poSocketExpiryTimer);

        tVoid vSetAdrSupervisionTimerVal(tU32 u32Ms) {
            _u32AdrSupervisionTmrValMs = u32Ms;
        };
		
		tVoid vCreateSocket();
		tVoid vDestroySocket();
        tVoid vSetAdrResetHandling(tBool bIsAdrResetActive) {
            _bIsAdrResetActive = bIsAdrResetActive;
        };
			#ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
        tVoid vSetClearSystemFailureErrorLog(tBool bClearSystemFailureErrorLog) {
        	_bClearSystemFailureErrorLog = bClearSystemFailureErrorLog;
        };
        tBool blGetClearSystemFailureErrorLog(){
        	return _bClearSystemFailureErrorLog;
        };
		#endif
        tU16 u16GetWaitAnswer() const {
            return _oCurrentAdrOutput.u16WaitAnswer;
        }

        //lint -esym(1763, DAB::dabdrv_adrIf::poGetDispatcher) "Member function 'DAB::dabdrv_adrIf::poGetDispatcher(void) const' marked as const indirectly modifies class"
        virtual DAB_tclDispatcher *poGetDispatcher() const {
            DAB_ASSERT_RETURN_VAL(poSsiDispatcher, OSAL_NULL);
            ETG_TRACE_USR4_CLS((FC_DABTUNER_TR_UTIL_DISP,
                                "poGetDispatcher[%d] of %s",
                                poSsiDispatcher->u32GetInstanceId(),
                                pcGetName()));
            return poSsiDispatcher;

	
        }

	
		tVoid INCDataIndication(tU8 *pu8Data, tU32 u32Length);
		tVoid INCDataConfirmation() const;
		tVoid vGetDABThreadPrioandStacksize(tU32 &u32ThreadPrio,tU32 &u32StackSize) const;
		tVoid vGetMTCThreadPrioandStacksize(tU32 &u32ThreadPrio,tU32 &u32StackSize) const;
		virtual void onNewDatagramMessage(void* data, size_t length);
		virtual void onSocketConnectionNotEstablished();
		DatagramSocket* m_DABDatagramSocket;
		DatagramSocket* m_MTCDatagramSocket;
		static tVoid vCallBackADRState( tU32 u32State);
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
		tVoid vSendMecaDbusCommand(tU16 u16FBlockId,unsigned char *pu8ByteArray,tU16 u16MecaLen);
        virtual void vDispatchRUMessage(unsigned char *pu8ByteArray, int actualLength);
		virtual void vHandleSBRState(unsigned char SBRState);
#endif
    private:

        tVoid vResetAdr(tVoid) ;
        tVoid vDeBlock();

        tBool bSend(trMsgAdrOutput const * poMsgAdrOutput, tBool bReSend = FALSE);


        dabdrv_adrIf(tVoid);

        tVoid vClearQ(tVoid);

		
        /*-------------------------------------------*/
        /* Call back function for ADR control driver */
        /*-------------------------------------------*/

        tVoid vSend(trMsgAdrOutput* poMsgAdrOutput);

        tVoid vHandleIpnDataCon(tU32 u32Len, tU8 const *pu8Data);

        tBool _bSendBusy;
        
        DAB_tclPrioQueue<trMsgAdrOutput>_oOutQ;



        DAB_tclTimer _oAdrSupervisionTmr;
        DAB_tclTimer _oBlockSvTmr;
		DAB_tclTimer _oSocketTimer;
        tU32 _u32AdrSupervisionTmrValMs;
        tBool _bIsAdrResetActive;
        tBool _bReadyToSend;
        trMsgAdrOutput _oCurrentAdrOutput;
        DAB_tclDispatcher *poSsiDispatcher;

        OSAL_tIODescriptor m_hAdr3CtrlDevice;
        static dab_tenADRState m_enADRState;
        static tBool _bAdrMsgReceived;
		
		tBool m_socketNotCreated;
		tU8 m_SocketRetryCount;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
		tU8 _u8ADR3ResetCounter;
        tBool _bClearSystemFailureErrorLog;
        tVoid vUpdateSystemFailureITC();
#endif

    };

}

#endif
