/************************************************************************
 * FILE:        dabdrv_adrIf.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_adrIf
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_util.h"
#include "fc_dabtuner_gpio.h"

#include "dabdrv_adrIf.hpp"
#include "dabdrv_mecaIf.h"
#include "fc_dabtuner_clientSpm.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
#include "fc_dabtuner_main.h"
#include "AarsDBusProxy/tuner_gio_dbus_handler.h"
#include "AarsDBusProxy/tuner_gio_dbus_aarsproc_proxy.h"
#include "AarsDBusProxy/AarsDBusProxyControl.h"
#endif

#include "../../ai_osal_linux/components/devices/dev_adr3ctrl/include/dev_adr3ctrl.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_ADRIF 
#include "trcGenProj/Header/dabdrv_adrIf.cpp.trc.h"
#endif

#define TUN_REGPATH_THREAD                "APP_THREAD"
#define TUN_REGVALUE_DABTHREAD_PRIO_NAME     "DAB_INC_PRIO"
#define TUN_REGVALUE_DABTHREAD_STACK_SIZE_NAME      "DAB_INC_STCK"
#define TUN_REGVALUE_MTCTHREAD_PRIO_NAME     "MTC_INC_PRIO"
#define TUN_REGVALUE_MTCTHREAD_STACK_SIZE_NAME      "MTC_INC_STCK"

#define TUN_DABINCTHREAD_DEFAULT_PRIO                133
#define TUN_DABINCTHREAD_DEFAULT_STACKSIZE           4096
#define TUN_MTCINCTHREAD_DEFAULT_PRIO                133
#define TUN_MTCINCTHREAD_DEFAULT_STACKSIZE           4096
/**Vnd4kor Inc adaptations */
#ifdef __cplusplus
extern "C"
{
#include "inc.h"
}
#endif

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/poll.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#include <time.h>
#include <netinet/tcp.h>
#include "inc_ports.h"

#define DAB_FBLOCK_LUNID 18
#define MTC_FBLOCK_LUNID 24


#include "DatagramSocketCallbackIf.h"
#include "DatagramSocket.h"
#define DABDRV_IPN_MAX_OUT_Q_LEN 200

using namespace DAB;

namespace DAB {




    // a timer-event
    struct trMsgAdrSupervisionTimeOut:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgAdrSupervisionTimeOut"));
        };
    };

    // a timer-event
    struct trMsgAdrIfBlockSvTimeOut:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgAdrIfBlockSvTimeOut"));
        };

    };

    struct trMsgIpnCon:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        trMsgIpnCon(tU8 u8ConRes_=DAB_IPN_DATA_CON_RES_OK){
            aU8Data[enIpnMsgOffset_CON_RES]=u8ConRes_;
            u32Len=(tU32)enIpnMsgOffset_CON_RES+1;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgIpnCon:conRes=0x%02x len=%d",
                                aU8Data[enIpnMsgOffset_CON_RES], u32Len));
        };
        tU32 u32Len;
        tU8 aU8Data[(tU32)enIpnMsgOffset_CON_RES+1];
    };
	
	    struct trMsgSocketExpiryTimer:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgSocketExpiryTimer"));
        };
    };


    dab_tenADRState dabdrv_adrIf::m_enADRState = enADRState_Unknown;
    tBool dabdrv_adrIf::_bAdrMsgReceived = FALSE;
}


//lint -e{1732} "new in constructor for class 'dabdrv_adrIf' which has no assignment operator"
//lint -e{1733} new in constructor for class 'dabdrv_adrIf' which has no copy constructor
dabdrv_adrIf::dabdrv_adrIf(tVoid) {

	m_DABDatagramSocket = NULL;
	m_MTCDatagramSocket = NULL;



    _bSendBusy = FALSE;
    _u32AdrSupervisionTmrValMs = DAB_ADR_SUPERVISION_TIMER_MS;
    _bIsAdrResetActive = TRUE;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
    _bClearSystemFailureErrorLog = false;
	_u8ADR3ResetCounter = 0;
#endif
    _bReadyToSend=FALSE;
	m_socketNotCreated = FALSE;
	m_SocketRetryCount = 0;
    poSsiDispatcher=OSAL_NEW(DAB_tclDispatcher);
    if (OSAL_NULL != poSsiDispatcher) {
        poSsiDispatcher->vInit(DAB_GET_CONFIG().u32IpnPrio);
    }

    m_hAdr3CtrlDevice = OSAL_ERROR;

    // subsribe
    vSubscribe<trMsgAdrOutput>();
    vSubscribe<trMsgResetAdr>();
    vSubscribe<trMsgDeblockAdrIf>();
    vSubscribe<trMeca_RConSetWatchDog>();
    vSubscribe<trMsgIpnCon>();
    vSubscribe<trMsgAdrMsgReceived>();
    
}
dabdrv_adrIf::~dabdrv_adrIf(tVoid) {
    vClose();
    m_hAdr3CtrlDevice = OSAL_ERROR;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
    _bClearSystemFailureErrorLog = false;
	_u8ADR3ResetCounter = 0;
#endif


}    

tVoid dabdrv_adrIf::vInit(tVoid) {

    ETG_TRACE_USR1(("dabdrv_adrIf:vInit()"));
	fc_dabtuner_config *poConfig = fc_dabtuner_config::instance();
	if(poConfig == nullptr)
	{
		return;
	}
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
		if(poConfig->bIsSBRVariant())
		{
			AarsDBusProxyControl::instance()->vSetAarsDBusProxyImpl(DAB_FBLOCK_LUNID, this);
			AarsDBusProxyControl::instance()->vSetAarsDBusProxyImpl(MTC_FBLOCK_LUNID, this);
		}

#endif
    _oAdrSupervisionTmr.vInit(instance(),trMsgAdrSupervisionTimeOut());    
    _oBlockSvTmr.vInit(instance(),trMsgAdrIfBlockSvTimeOut());
    if(!poConfig->bIsSBRVariant())
    {
    	_oSocketTimer.vInit(instance(), trMsgSocketExpiryTimer());
    }

    _bSendBusy = FALSE;
    vClearQ();


    /*==========================================================================
    * open ADR control driver
    *------------------------------------------------------------------------*/
	if(!poConfig->bIsSBRVariant())
	{
		if (m_hAdr3CtrlDevice == OSAL_ERROR) {
			m_hAdr3CtrlDevice = OSAL_IOOpen( DAB_DRVADRIF_CONF_ADR_CONTROL_DRIVER_NAME, OSAL_EN_READWRITE);
			if ( OSAL_ERROR != m_hAdr3CtrlDevice )
			{
				tU32 u32ErrorCode = OSAL_s32IOControl( m_hAdr3CtrlDevice,
													   (tS32)OSAL_C_S32_IOCTRL_ADR3CTRL_REGISTER_RESET_CALLBACK,
													   (intptr_t) vCallBackADRState);

				NORMAL_M_ASSERT( OSAL_OK == u32ErrorCode);
			}
		}        
		vCreateSocket();
	}
}

tVoid dabdrv_adrIf::vCreateSocket(){
	tU32 u32ThreadPrio = 0;
	tU32 u32StackSize  = 0;    
	vGetDABThreadPrioandStacksize(u32ThreadPrio, u32StackSize);
	m_DABDatagramSocket = new DatagramSocket(this, u32StackSize, u32ThreadPrio, ((uint16_t)PORT_OFFSET |(uint16_t)DAB_FBLOCK_LUNID), AF_BOSCH_INC_ADR);
	
	vGetMTCThreadPrioandStacksize(u32ThreadPrio, u32StackSize);
	m_MTCDatagramSocket = new DatagramSocket(this, u32StackSize, u32ThreadPrio, ((uint16_t)PORT_OFFSET |(uint16_t)MTC_FBLOCK_LUNID), AF_BOSCH_INC_ADR);
}

	tVoid dabdrv_adrIf::vDestroySocket(){
					if (m_DABDatagramSocket != NULL)
		   {
				delete m_DABDatagramSocket;
				m_DABDatagramSocket = NULL;
			}	

			if (m_MTCDatagramSocket != NULL)
			{
				delete m_MTCDatagramSocket;
				m_MTCDatagramSocket = NULL;
		   }
	}
    
tVoid dabdrv_adrIf::vDeInit() {
    ETG_TRACE_USR4(("dabdrv_adrIf:vDeInit()"));
    vClose();
}

tVoid dabdrv_adrIf::vStartAdrCommunication() {
    ETG_TRACE_USR4(("dabdrv_adrIf:vStartAdrCommunication()"));
    if (!_oAdrSupervisionTmr.bValid()) {
        return;
    }
    _oAdrSupervisionTmr.vStart(_u32AdrSupervisionTmrValMs);
    _bReadyToSend=TRUE;
    vDeBlock();

}


tVoid dabdrv_adrIf::vStopAdrCommunication() {
    ETG_TRACE_USR4(("dabdrv_adrIf:vStopAdrCommunication()"));
    if (!_oAdrSupervisionTmr.bValid()) {
        return;
    }
    _oAdrSupervisionTmr.vStop();
    vClearQ();
    _bReadyToSend=FALSE;
    _bSendBusy=FALSE;

}
tVoid dabdrv_adrIf::vClose() {
    ETG_TRACE_USR4(("dabdrv_adrIf:vClose()"));
    if (!_oAdrSupervisionTmr.bValid()) {
        return;
    }

    // first stop our dispatcher
    if (poSsiDispatcher!=OSAL_NULL) {
        poSsiDispatcher->vClose();
    }
    _oAdrSupervisionTmr.vDeInit();
    _oBlockSvTmr.vDeInit();
	fc_dabtuner_config *poConfig = fc_dabtuner_config::instance();
	if(poConfig != nullptr)
	{
		if(!poConfig->bIsSBRVariant())
		{
			_oSocketTimer.vDeInit();
			vDestroySocket();
		}
	}
	// if (m_DABDatagramSocket != NULL)
   // {
		// delete m_DABDatagramSocket;
		// m_DABDatagramSocket = NULL;
	// }	

	// if (m_MTCDatagramSocket != NULL)
	// {
		// delete m_MTCDatagramSocket;
		// m_MTCDatagramSocket = NULL;
   // }

}


tVoid dabdrv_adrIf::vTraceState() const {
    ETG_TRACE_USR1(("  dabdrv_adrIf STATE: _bSendBusy=%d, OutQSize=%d u16WaitAnswer=%04x _bReadyToSend=%d",
                    _bSendBusy, _oOutQ.size(), ETG_CENUM(DAB_tenMecaMsgId,_oCurrentAdrOutput.u16WaitAnswer),
                    _bReadyToSend));
}

tVoid dabdrv_adrIf::vProcess(trMsgAdrOutput* poMsgAdrOutput) {
    if (DABDRV_MAX_ADR_OUT_LEN < poMsgAdrOutput->u32Len) {
        ETG_TRACE_COMP(("dabdrv_adrIf:vProcess(trMsgAdrOutput): too long (%d)",
                        poMsgAdrOutput->u32Len));
        poMsgAdrOutput->oSendInfo.vClear();
        return;
    }
    if (_oOutQ.size() >= DABDRV_IPN_MAX_OUT_Q_LEN) {
        ETG_TRACE_ERR(("dabdrv_adrIf:vProcess(trMsgAdrOutput): Queue full"));
        poMsgAdrOutput->oSendInfo.vClear();
        return;
    }

    if (_bSendBusy || _oCurrentAdrOutput.u16WaitAnswer ) {
        ETG_TRACE_USR1(("dabdrv_adrIf:vProcess(trMsgAdrOutput): put to Queue"));
        _oOutQ.push(*poMsgAdrOutput);
        return;
    }
    else {
        ETG_TRACE_USR1(("dabdrv_adrIf:vProcess(trMsgAdrOutput): send directly"));
        _bSendBusy = bSend(poMsgAdrOutput);
    }
}


tVoid dabdrv_adrIf::vProcess(trMsgIpnCon *prIpnCon) {
    vHandleIpnDataCon(prIpnCon->u32Len, prIpnCon->aU8Data);
}


tVoid dabdrv_adrIf::vProcess(trMeca_RConSetWatchDog *poSetWatchDog) {
    _u32AdrSupervisionTmrValMs= poSetWatchDog->bEnable ? DAB_ADR_SUPERVISION_TIMER_MS : 0;
    _oAdrSupervisionTmr.vStart(_u32AdrSupervisionTmrValMs);
}

tVoid dabdrv_adrIf::vHandleIpnDataCon(tU32 u32Len, tU8 const *pu8Data) {
    ETG_TRACE_USR4(("dabdrv_adrIf:vHandleIpnDataCon()"));
    _bAdrMsgReceived = TRUE;
    if (u32Len <= (tS32)enIpnMsgOffset_CON_RES ) {
        ETG_TRACE_COMP(("dabdrv_adrIf:vHandleIpnDataCon()():CON Invalid Len=%d",
                        u32Len));

        trMsgIpnError oError(enIpnError_TxError);
        DAB_vPostMsg(dabdrv_mecaIf::instance(), &oError);  
        return;
    }
    if (DAB_IPN_DATA_CON_RES_OK != pu8Data[enIpnMsgOffset_CON_RES]) {
        ETG_TRACE_COMP(("dabdrv_adrIf:vHandleIpnDataCon():CON wrong Res=%d",
                        pu8Data[enIpnMsgOffset_CON_RES]));
        trMsgIpnError oError(enIpnError_TxError);
        DAB_vPostMsg(dabdrv_mecaIf::instance(), &oError);  
        // resend last message from _oCurrentAdrOutput
        bSend( NULL, TRUE);
        return;
        // data have been sent, send next data if pending
    }
    if (!_oCurrentAdrOutput.u16WaitAnswer) {
        _bSendBusy=FALSE;
        if (!_oOutQ.empty()) {
            _oOutQ.vLock();
            if (bSend(&(_oOutQ.front()))) {
                _oOutQ.pop_front();
                _bSendBusy=TRUE;
            }
            _oOutQ.vUnLock();
        }
    } else {
        // todoo:start retransmission-timer
        _bReadyToSend=TRUE;
        _bSendBusy=FALSE;
    }
}

tVoid dabdrv_adrIf::vDeBlock() {
    // removed blocking-flag
    ETG_TRACE_USR4(("dabdrv_adrIf:vDeBlock()"));
    _oBlockSvTmr.vStop();
    _oCurrentAdrOutput.u16WaitAnswer=0;
    _oCurrentAdrOutput.oSendInfo.vClear();

        // adr is ready for new message, so start sending
}






tVoid dabdrv_adrIf::vProcess(trMsgResetAdr* poMsgResetAdr) {
    ETG_TRACE_USR4(("dabdrv_adrIf:vProcess(trMsgResetAdr)"));
    (tVoid)poMsgResetAdr;
    vResetAdr();
}

tVoid dabdrv_adrIf::vProcess(trMsgDeblockAdrIf* poMsgDeblockAdrIf) {
    ETG_TRACE_USR4(("dabdrv_adrIf:vProcess(trMsgDeblockAdrIf)"));
    (tVoid)poMsgDeblockAdrIf;
    vDeBlock();
}

tVoid dabdrv_adrIf::vProcess(trMsgAdrSupervisionTimeOut* poAdrSupervisionTimer){
    (tVoid)poAdrSupervisionTimer;
    ETG_TRACE_USR4(("dabdrv_mecaIf:process trMsgAdrSupervisionTimeOut"));
    if (_bAdrMsgReceived) {
        _bAdrMsgReceived = FALSE;
        _oAdrSupervisionTmr.vStart(_u32AdrSupervisionTmrValMs);
    } 
    else {
		
		if(m_socketNotCreated)
		{
			 _oAdrSupervisionTmr.vStart(_u32AdrSupervisionTmrValMs);
		}
		else
		{
        ETG_TRACE_USR4(("dabdrv_mecaIf:process trMsgAdrSupervisionTimeOut NO MSGs received"));
		vResetAdr();
		}
    }
};
tVoid dabdrv_adrIf::vProcess(trMsgAdrMsgReceived* poAdrMsgReceived){
    (tVoid)poAdrMsgReceived;
    ETG_TRACE_USR4(("dabdrv_mecaIf:process trMsgAdrMsgReceived"));
    _bAdrMsgReceived = TRUE;
};

tVoid dabdrv_adrIf::vProcess(trMsgAdrIfBlockSvTimeOut *poBlockSvTimer){
    (tVoid)poBlockSvTimer;
    ETG_TRACE_USR1(("dabdrv_adrIf:process trMsgAdrIfBlockSvTimeOut"));
    trMecaSendSvInfo &roSendInfo=_oCurrentAdrOutput.oSendInfo;
    if (roSendInfo.poMsg != OSAL_NULL) {
        ETG_TRACE_USR1(("dabdrv_adrIf:notify TimeOut Event"));
        poGetDispatcher()->vPostMsgNoCopy(roSendInfo.poMsgCaller, roSendInfo.poMsg);
        /* custody to poMsg goes to receiver, reset pointers to prevent later
           deleting of poMsg via trMecaSendSvInfo::vClear()
        */
        roSendInfo.poMsg=OSAL_NULL;
        roSendInfo.poMsgCaller=OSAL_NULL;
    }
    vDeBlock();
};

tVoid dabdrv_adrIf::vProcess(trMsgSocketExpiryTimer *poSocketExpiryTimer){
	(tVoid)poSocketExpiryTimer;
	ETG_TRACE_ERRMEM(("dabdrv_adrIf:process trMsgSocketExpiryTimer"));
	ETG_TRACE_USR1(("dabdrv_adrIf:process trMsgSocketExpiryTimer"));
	m_socketNotCreated = FALSE;
	vCreateSocket();	
}

tVoid dabdrv_adrIf::vClearQ(tVoid) {
    trMsgAdrOutput oAdrOutput;
    while ((!_oOutQ.empty()) && (_oOutQ.bPop(&oAdrOutput))) {  //Bug 246838 
        oAdrOutput.oSendInfo.vClear();
    }
	if(!_oOutQ.empty())
	{
		_oOutQ.clear();
	}
    _oCurrentAdrOutput.oSendInfo.vClear();
}


/*****************************************************************************
 * Call back function for ADR control driver for.
 ****************************************************************************/
tVoid dabdrv_adrIf::vCallBackADRState( tU32 u32State)
{
  ETG_TRACE_USR1(( " dabdrv_adrIf::vCallBackADRState() -> u32NewState=%d   actState=%d" ,u32State, m_enADRState));

  //dabdrv_adrIf::instance()->vTraceState();
  if ( m_enADRState == (dab_tenADRState)u32State )
      return;

  m_enADRState = (dab_tenADRState)u32State;
  if (u32State == (tU32)enADRState_DEAD ) {
      trMsgAdrStatus oAdrStatus(enAdrStatus_Dead);
      DAB_vPostMsg(dabdrv_mecaIf::instance(), &oAdrStatus);

      ETG_TRACE_USR4(( " dabdrv_adrIf:vCallBackADRState() -> ADR DEAD.\n"));
  }
  else if (u32State == (tU32)enADRState_ALIVE) {
      trMsgAdrStatus oAdrStatus(enAdrStatus_Alive);
      DAB_vPostMsg(dabdrv_mecaIf::instance(), &oAdrStatus);
      ETG_TRACE_USR4(( " dabdrv_adrIf:vCallBackADRState() -> ADR ALIVE.\n"));
	/*needed for sending response to audio incase of low voltage handling*/
	trMeca_CRdmSetMode rRdmSetMode;
	rRdmSetMode.enRdmMode = enMeca_RdmMode_GET;
	dabdrv_mecaIf::instance()->vSendMecaCommand(rRdmSetMode);
  }

}


tBool dabdrv_adrIf::bSend(trMsgAdrOutput const * poMsgAdrOutput, tBool bResend) {
	if (!bResend)
	{
		_oCurrentAdrOutput.oSendInfo.vClear();
		_oCurrentAdrOutput=*poMsgAdrOutput;
	}
	else
	{
		ETG_TRACE_USR1(("dabdrv_adrIf:bSend -> resend last message"));
	}

	_oBlockSvTmr.vStop();
	//todoo: stop wait-answer timer
	if (_oCurrentAdrOutput.u16WaitAnswer)
	{
		if (_oCurrentAdrOutput.oSendInfo.u32TimeOutMs)
		{
			_oBlockSvTmr.vStart(_oCurrentAdrOutput.oSendInfo.u32TimeOutMs);
		}
		//todoo:set flag: enter wait-answer, check if already _bRetransmit
		ETG_TRACE_USR1(("dabdrv_adrIf:bSend:set u16WaitAnswer=%04x",
				ETG_CENUM(DAB_tenMecaMsgId,_oCurrentAdrOutput.u16WaitAnswer)));
	}

	//lint -e(428) negative subscript
	ETG_TRACE_COMP(("dabdrv_adrIf:bSend:u32MecaRefId=%d len=%d\nOUT_BUF=%*p",
			_oCurrentAdrOutput.u32MecaRefId,
			_oCurrentAdrOutput.u32Len,
			ETG_LIST_LEN(_oCurrentAdrOutput.u32Len), ETG_LIST_PTR_T8(_oCurrentAdrOutput.au8AdrMsg)));
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	if(poConfig == nullptr)
	{
		return false;
	}
	if(!poConfig->bIsSBRVariant())
	{
		unsigned int iNumberOfBytes =0;

		if ((NULL != poMsgAdrOutput)&&
				(poMsgAdrOutput->u16FBlockId == DAB_FBLOCK_ID)&&
				(m_DABDatagramSocket!= NULL))
		{
			ETG_TRACE_USR1(("dabdrv_adrIf:bSend -> Sending DAB message"));
			iNumberOfBytes = m_DABDatagramSocket->sendMessage(const_cast<tU8*>(_oCurrentAdrOutput.au8AdrMsg),
					_oCurrentAdrOutput.u32Len);
		}
		if((NULL != poMsgAdrOutput)&&
				(poMsgAdrOutput->u16FBlockId == DAB_MTC_FBLOCK_ID)&&
				(m_MTCDatagramSocket!= NULL))
		{
			ETG_TRACE_USR1(("dabdrv_adrIf:bSend -> Sending MTC message"));
			iNumberOfBytes = m_MTCDatagramSocket->sendMessage(const_cast<tU8*>(_oCurrentAdrOutput.au8AdrMsg),
					_oCurrentAdrOutput.u32Len);
		}

		if(iNumberOfBytes == _oCurrentAdrOutput.u32Len )
		{
			INCDataConfirmation();
			return TRUE;
		}
		else
		{
			trMsgIpnError oError(enIpnError_TxError);
			DAB_vPostMsg(dabdrv_mecaIf::instance(), &oError);
			return FALSE;
		}
	}
	else
	{
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
		vSendMecaDbusCommand(_oCurrentAdrOutput.u16FBlockId,_oCurrentAdrOutput.au8AdrMsg,(tU16)_oCurrentAdrOutput.u32Len);
		INCDataConfirmation();
		return true;
#endif
	}
	return false;
}

// todo: this is just a test-version, handling of shutdown has to be confirmed
tVoid dabdrv_adrIf::vResetAdr(tVoid) { //This is made constant to satisfy lint

	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	if(poConfig != nullptr)
	{
		if (TRUE == _bIsAdrResetActive)
		{
			if(poConfig->bIsSBRVariant())
			{
			   ETG_TRACE_ERRMEM(("dabdrv_adrIf:RestartSBR"));
#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
				trMsgRestartSBRProcess rSrvRsp(true);
				DAB_vPostMsg(fc_dabtuner_clientSpm::instance(), &rSrvRsp);
#endif
			}
			else
			{
				if( OSAL_ERROR != m_hAdr3CtrlDevice )
				{
				   ETG_TRACE_ERRMEM(("dabdrv_adrIf:vResetAdr()"));
				   tS32 s32ErrorCode = OSAL_s32IOControl( m_hAdr3CtrlDevice,
                                              OSAL_C_S32_IOCTRL_ADR3CTRL_RESET_ADR3,
                                              (tS32) NULL );
					NORMAL_M_ASSERT( OSAL_OK == s32ErrorCode);
				}
			}
			trMsgIpnError oError(enIpnError_AdrLost);
			DAB_vPostMsg(dabdrv_mecaIf::instance(), &oError);
			#ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
            vUpdateSystemFailureITC();
			#endif
        }
    }
}
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
tVoid dabdrv_adrIf::vUpdateSystemFailureITC()
{
	_u8ADR3ResetCounter++;
	if(DAB_DRVADRIF_CONF_ADR3_MAXRESET_COUNTER==_u8ADR3ResetCounter)
	{
		_u8ADR3ResetCounter=0;
		vSetClearSystemFailureErrorLog(TRUE);
	}
}
#endif


	


	
tVoid dabdrv_adrIf::INCDataIndication(tU8 *pu8Data, tU32 u32Length)
{
    ETG_TRACE_USR1(("dabdrv_adrIf:vCallbackFnTsuInd u32Length=%d", u32Length));
    ETG_TRACE_USR1(("\n"
                    " ****************************************************************************************\n"
                    " * INC DATA       I N D \n"
                    " ****************************************************************************************"
                    ));
	   // send event to my thread to restart timer

    trMsgAdrInput *poAdrInput=NULL;
try
{
	poAdrInput = OSAL_NEW trMsgAdrInput(pu8Data, u32Length);
	if(poAdrInput == NULL)
	{
		ETG_TRACE_USR4(("dabdrv_adrIf::INCDataIndication poAdrInput is NULL"));
		return;
	}
	DAB_vPostMsgNoCopy(dabdrv_mecaIf::instance(), poAdrInput);
}
catch(std::bad_alloc)
	{
		ETG_TRACE_USR1(("Exception caught"));
		if(poAdrInput != NULL)
		{
			OSAL_DELETE poAdrInput;
		}
	}
	
}

/*******************************************************************************
* FUNCTION : INCDataConfirmation
*
* DESCRIPTION : posts event EVENT_INC_TX_READY to indicate message is 
*				sent to INC
*
* PARAMETER : 
*
* RETURNVALUE : tVoid
*
* HISTORY : 16.04.2013
* Initial version
*********************************************************************************/
tVoid dabdrv_adrIf::INCDataConfirmation() const
{

	ETG_TRACE_USR1(("dabdrv_adrIf:vCallbackFnDataCon "));
	trMsgIpnCon rMsgIpnCon(DAB_IPN_DATA_CON_RES_OK);
	DAB_vPostMsg(dabdrv_adrIf::instance(), &rMsgIpnCon);

}

tVoid dabdrv_adrIf::onNewDatagramMessage(void* data, size_t length){
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	if(poConfig == nullptr)
	{
		return;
	}
	if(!poConfig->bIsSBRVariant())
	{
		ETG_TRACE_USR1(("dabdrv_adrIf:onNewDatagramMessage "));
		dabdrv_adrIf::instance()->INCDataIndication((tU8*)data,(tU32)length);
	}
}
tVoid dabdrv_adrIf::onSocketConnectionNotEstablished(){
	ETG_TRACE_ERRMEM(( " dabdrv_adrIf::onSocketConnectionNotEstablished"));
	ETG_TRACE_USR1(( " dabdrv_adrIf::onSocketConnectionNotEstablished"));
	m_socketNotCreated = TRUE;
	if(m_SocketRetryCount<=5){
		m_SocketRetryCount++;
		_oSocketTimer.vStart(500);		
		vDestroySocket();
	}		
	else
	{
		ETG_TRACE_ERRMEM(( " dabdrv_adrIf::onSocketConnectionNotEstablished Max retries reached"));
	}
}

/*******************************************************************************
* FUNCTION : vGetDABThreadPrioandStacksize
*
* DESCRIPTION : gets the Thread Prio and Stack size from the registry.
*
* PARAMETER : (tU32 &u32ThreadPrio,tU32 &u32StackSize)
*
* RETURNVALUE : tVoid
*
* HISTORY : 16.04.2013 NGP1kor
* Initial version
*********************************************************************************/
tVoid dabdrv_adrIf::vGetDABThreadPrioandStacksize(tU32 &u32ThreadPrio,tU32 &u32StackSize) const
{
	
    // Read thread priority from registry
    if ( FALSE == scd_bGetAppConfigurationValue 
                                      ( 
                                         // CCA App ID
                                         CCA_C_U16_APP_FC_DABTUNER,

                                         // Registry path
                                         TUN_REGPATH_THREAD,

                                         // Registry entry for thread priority
                                         TUN_REGVALUE_DABTHREAD_PRIO_NAME,

                                         // Read priority value
                                         &u32ThreadPrio 
                                       ) 
          )
    {
      // Assign default value.
      u32ThreadPrio = TUN_DABINCTHREAD_DEFAULT_PRIO;
    
      // Indicate that the thread is running on default priority
      ETG_TRACE_ERR(( " vGetDABThreadPrioandStacksize ->  the thread is running on default priority (=%d)."
                      ,u32ThreadPrio
                    ));
    }
    else
    {
      ETG_TRACE_USR1(( " vGetDABThreadPrioandStacksize ->  the thread is running on Registry priority=%d."
                      ,u32ThreadPrio
                    ));
    }


    // Read thread stack size from registry
  if ( FALSE == scd_bGetAppConfigurationValue 
                                    ( 
                                       // CCA App ID
                                       CCA_C_U16_APP_FC_DABTUNER,

                                       // Registry path
                                       TUN_REGPATH_THREAD,

                                       // Registry entry for stack size
                                       TUN_REGVALUE_DABTHREAD_STACK_SIZE_NAME,

                                       // Read stack size value
                                       &u32StackSize 
                                     )
     )
  {
    u32StackSize  = TUN_DABINCTHREAD_DEFAULT_STACKSIZE;

    // Indicate that the thread is running on default priority
    ETG_TRACE_ERR(( " vGetDABThreadPrioandStacksize ->  the thread is running with default stack size (=%d)."
                    ,u32StackSize
                  ));
  }
  else
  {
    ETG_TRACE_USR1(( " vGetDABThreadPrioandStacksize ->  the thread is running with Registry stack size =%d."
                    ,u32StackSize
                  ));
  }
}
/*******************************************************************************
* FUNCTION : vGetMTCThreadPrioandStacksize
*
* DESCRIPTION : gets the Thread Prio and Stack size from the registry.
*
* PARAMETER : (tU32 &u32ThreadPrio,tU32 &u32StackSize)
*
* RETURNVALUE : tVoid
*
* HISTORY : 08.10.2013 RAG6KOR
* Initial version
*********************************************************************************/
tVoid dabdrv_adrIf::vGetMTCThreadPrioandStacksize(tU32 &u32ThreadPrio,tU32 &u32StackSize) const
{
	
    // Read thread priority from registry
    if ( FALSE == scd_bGetAppConfigurationValue 
                                      ( 
                                         // CCA App ID
                                         CCA_C_U16_APP_FC_DABTUNER,

                                         // Registry path
                                         TUN_REGPATH_THREAD,

                                         // Registry entry for thread priority
                                         TUN_REGVALUE_MTCTHREAD_PRIO_NAME,

                                         // Read priority value
                                         &u32ThreadPrio 
                                       ) 
          )
    {
      // Assign default value.
      u32ThreadPrio = TUN_MTCINCTHREAD_DEFAULT_PRIO;
    
      // Indicate that the thread is running on default priority
      ETG_TRACE_ERR(( " vGetMTCThreadPrioandStacksize ->  the thread is running on default priority (=%d)."
                      ,u32ThreadPrio
                    ));
    }
    else
    {
      ETG_TRACE_USR1(( " vGetMTCThreadPrioandStacksize ->  the thread is running on Registry priority=%d."
                      ,u32ThreadPrio
                    ));
    }


    // Read thread stack size from registry
  if ( FALSE == scd_bGetAppConfigurationValue 
                                    ( 
                                       // CCA App ID
                                       CCA_C_U16_APP_FC_DABTUNER,

                                       // Registry path
                                       TUN_REGPATH_THREAD,

                                       // Registry entry for stack size
                                       TUN_REGVALUE_MTCTHREAD_STACK_SIZE_NAME,

                                       // Read stack size value
                                       &u32StackSize 
                                     )
     )
  {
    u32StackSize  = TUN_MTCINCTHREAD_DEFAULT_STACKSIZE;

    // Indicate that the thread is running on default priority
    ETG_TRACE_ERR(( " vGetMTCThreadPrioandStacksize ->  the thread is running with default stack size (=%d)."
                    ,u32StackSize
                  ));
  }
  else
  {
    ETG_TRACE_USR1(( " vGetMTCThreadPrioandStacksize ->  the thread is running with Registry stack size =%d."
                    ,u32StackSize
                  ));
  }
}
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
tVoid dabdrv_adrIf::vSendMecaDbusCommand(tU16 u16FBlockId,unsigned char *pu8ByteArray,tU16 u16MecaLen)
{
	ETG_TRACE_USR4(("dabdrv_adrIf::vSendMecaDbusCommand "));
	unsigned char u8AarsLunId = DAB_FBLOCK_LUNID;
	if(u16FBlockId == DAB_MTC_FBLOCK_ID)
	{
		u8AarsLunId = MTC_FBLOCK_LUNID;
	}
	if (fc_dabtuner_tclApp::instance()->poDBus() != OSAL_NULL) {
		ETG_TRACE_USR4(("vSendMecaDbusCommand::Invoking AarsProc via DBus here LunId = %d ", u8AarsLunId));
		fc_dabtuner_tclApp::instance()->poDBus()->vPostMessage(u8AarsLunId, pu8ByteArray, u16MecaLen);

	} else {
		ETG_TRACE_USR4(("Aars Proxy service not configured for this project"));
	}
}
void dabdrv_adrIf::vDispatchRUMessage(unsigned char *pu8ByteArray, int actualLength)
{
	dabdrv_adrIf::instance()->INCDataIndication((tU8*)pu8ByteArray,actualLength);
}

void dabdrv_adrIf::vHandleSBRState(unsigned char SBRState)
{
	ETG_TRACE_USR1(("dabdrv_adrIf::vHandleSBRState"));
	vCallBackADRState(SBRState);
}
#endif
