/* ******************************************************FileHeaderBegin** *//**
 *
 * @file        DataPoolSCC.h
 *
 * generated header for the structure of SCC access. 
 *
 * @date        2013-011-20
 *
 * @note 
 *
 *  &copy; Copyright BoschSoftec GmbH Hildesheim. All Rights reserved!
 *
 *//* ***************************************************FileHeaderEnd******* */
#ifndef _DATA_POOL_SCC
#define _DATA_POOL_SCC

/************************************************************************
|defines and macros (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|typedefs and struct defs (scope: global)
|-----------------------------------------------------------------------*/
/*structure header infomation for PDD*/
typedef struct {
   tU32  u32VersionPool;
   tU32  u32Checksum;
   tU32  u32Size;
}TPddScc_Header;

/*-----------------------------------------------------------------------
 ---- structure TPddScc_VehFuncPDD for pool VehFuncPDD
 -----------------------------------------------------------------------*/
#define DATAPOOL_SCC_VERSION_POOL_VEHFUNCPDD     0x0001 
#define DATAPOOL_SCC_IDENTITY_NUMBER_VEHFUNCPDD  8

/*array numer of elements*/

typedef struct {
   tU8   SteeringPosition;
}TDataPoolScc_SteeringPosition;

typedef struct {
    TDataPoolScc_SteeringPosition   SteeringPosition;
}TDataPoolScc_VehFuncPDD;

typedef struct {
  TPddScc_Header    PddSccHeader;
  TDataPoolScc_VehFuncPDD   VehFuncPDD;
}TPddScc_VehFuncPDD;


/*-----------------------------------------------------------------------
 ---- structure TPddScc_DPCMD_AlignmentData for pool DPCMD_AlignmentData
 -----------------------------------------------------------------------*/
#define DATAPOOL_SCC_VERSION_POOL_DPCMD_ALIGNMENTDATA     0x0001 
#define DATAPOOL_SCC_IDENTITY_NUMBER_DPCMD_ALIGNMENTDATA  2

/*array numer of elements*/
#define DATAPOOL_SCC_ADCREFPLUSACTUALVOLTAGEVALUES_NUMBER  4

typedef struct {
   tU8   ADCRefPlusActualVoltageValues[DATAPOOL_SCC_ADCREFPLUSACTUALVOLTAGEVALUES_NUMBER];
}TDataPoolScc_ADCRefPlusActualVoltageValues;

typedef struct {
    TDataPoolScc_ADCRefPlusActualVoltageValues   ADCRefPlusActualVoltageValues;
}TDataPoolScc_DPCMD_AlignmentData;

typedef struct {
  TPddScc_Header    PddSccHeader;
  TDataPoolScc_DPCMD_AlignmentData   DPCMD_AlignmentData;
}TPddScc_DPCMD_AlignmentData;


/*-----------------------------------------------------------------------
 ---- structure TPddScc_DPCMD_CMVariantCoding for pool DPCMD_CMVariantCoding
 -----------------------------------------------------------------------*/
#define DATAPOOL_SCC_VERSION_POOL_DPCMD_CMVARIANTCODING     0x0001 
#define DATAPOOL_SCC_IDENTITY_NUMBER_DPCMD_CMVARIANTCODING  7

/*array numer of elements*/
#define DATAPOOL_SCC_CMVARIANTCODINGVALUE_NUMBER  32

typedef struct {
   tU8   CMVariantCodingValue[DATAPOOL_SCC_CMVARIANTCODINGVALUE_NUMBER];
}TDataPoolScc_CMVariantCodingValue;

typedef struct {
    TDataPoolScc_CMVariantCodingValue   CMVariantCodingValue;
}TDataPoolScc_DPCMD_CMVariantCoding;

typedef struct {
  TPddScc_Header    PddSccHeader;
  TDataPoolScc_DPCMD_CMVariantCoding   DPCMD_CMVariantCoding;
}TPddScc_DPCMD_CMVariantCoding;


/*-----------------------------------------------------------------------
 ---- structure TPddScc_DPCMC_PNM_DATA_SYNC_WITH_NVM for pool DPCMC_PNM_DATA_SYNC_WITH_NVM
 -----------------------------------------------------------------------*/
#define DATAPOOL_SCC_VERSION_POOL_DPCMC_PNM_DATA_SYNC_WITH_NVM     0x0000 
#define DATAPOOL_SCC_IDENTITY_NUMBER_DPCMC_PNM_DATA_SYNC_WITH_NVM  10

/*array numer of elements*/
#define DATAPOOL_SCC_NVMCONFIGURATIONVALUE_NUMBER  8

typedef struct {
   tU8   NVMConfigurationValue[DATAPOOL_SCC_NVMCONFIGURATIONVALUE_NUMBER];
}TDataPoolScc_NVMConfigurationValue;

typedef struct {
    TDataPoolScc_NVMConfigurationValue   NVMConfigurationValue;
}TDataPoolScc_DPCMC_PNM_DATA_SYNC_WITH_NVM;

typedef struct {
  TPddScc_Header    PddSccHeader;
  TDataPoolScc_DPCMC_PNM_DATA_SYNC_WITH_NVM   DPCMC_PNM_DATA_SYNC_WITH_NVM;
}TPddScc_DPCMC_PNM_DATA_SYNC_WITH_NVM;


/*-----------------------------------------------------------------------
 ---- structure TPddScc_ThmDpPDD for pool ThmDpPDD
 -----------------------------------------------------------------------*/
#define DATAPOOL_SCC_VERSION_POOL_THMDPPDD     0x0003 
#define DATAPOOL_SCC_IDENTITY_NUMBER_THMDPPDD  4

/*array numer of elements*/

typedef struct {
   tU16   PDD_THM_Version;
}TDataPoolScc_PDD_THM_Version;

typedef struct {
   tU8   PDD_THM_SensorID_1;
}TDataPoolScc_PDD_THM_SensorID_1;

typedef struct {
   tS16   PDD_THM_MaximumTemperature_1;
}TDataPoolScc_PDD_THM_MaximumTemperature_1;

typedef struct {
   tS16   PDD_THM_MinimumTemperature_1;
}TDataPoolScc_PDD_THM_MinimumTemperature_1;

typedef struct {
   tS16   PDD_THM_CriticalHighTemperature_1;
}TDataPoolScc_PDD_THM_CriticalHighTemperature_1;

typedef struct {
   tU8   PDD_THM_CriticalHighTemperatureHysteresis_1;
}TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_1;

typedef struct {
   tU16   PDD_THM_CriticalHighTemperatureTimeDelay_1;
}TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_1;

typedef struct {
   tS16   PDD_THM_HighTemperature_1;
}TDataPoolScc_PDD_THM_HighTemperature_1;

typedef struct {
   tU8   PDD_THM_HighTemperatureHysteresis_1;
}TDataPoolScc_PDD_THM_HighTemperatureHysteresis_1;

typedef struct {
   tU16   PDD_THM_HighTemperatureTimeDelay_1;
}TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_1;

typedef struct {
   tS16   PDD_THM_LowTemperature_1;
}TDataPoolScc_PDD_THM_LowTemperature_1;

typedef struct {
   tU8   PDD_THM_LowTemperatureHysteresis_1;
}TDataPoolScc_PDD_THM_LowTemperatureHysteresis_1;

typedef struct {
   tU16   PDD_THM_LowTemperatureTimeDelay_1;
}TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_1;

typedef struct {
   tS16   PDD_THM_CriticalLowTemperature_1;
}TDataPoolScc_PDD_THM_CriticalLowTemperature_1;

typedef struct {
   tU8   PDD_THM_CriticalLowTemperatureHysteresis_1;
}TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_1;

typedef struct {
   tU16   PDD_THM_CriticalLowTemperatureTimeDelay_1;
}TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_1;

typedef struct {
   tU8   PDD_THM_SensorID_2;
}TDataPoolScc_PDD_THM_SensorID_2;

typedef struct {
   tS16   PDD_THM_MaximumTemperature_2;
}TDataPoolScc_PDD_THM_MaximumTemperature_2;

typedef struct {
   tS16   PDD_THM_MinimumTemperature_2;
}TDataPoolScc_PDD_THM_MinimumTemperature_2;

typedef struct {
   tS16   PDD_THM_CriticalHighTemperature_2;
}TDataPoolScc_PDD_THM_CriticalHighTemperature_2;

typedef struct {
   tU8   PDD_THM_CriticalHighTemperatureHysteresis_2;
}TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_2;

typedef struct {
   tU16   PDD_THM_CriticalHighTemperatureTimeDelay_2;
}TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_2;

typedef struct {
   tS16   PDD_THM_HighTemperature_2;
}TDataPoolScc_PDD_THM_HighTemperature_2;

typedef struct {
   tU8   PDD_THM_HighTemperatureHysteresis_2;
}TDataPoolScc_PDD_THM_HighTemperatureHysteresis_2;

typedef struct {
   tU16   PDD_THM_HighTemperatureTimeDelay_2;
}TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_2;

typedef struct {
   tS16   PDD_THM_LowTemperature_2;
}TDataPoolScc_PDD_THM_LowTemperature_2;

typedef struct {
   tU8   PDD_THM_LowTemperatureHysteresis_2;
}TDataPoolScc_PDD_THM_LowTemperatureHysteresis_2;

typedef struct {
   tU16   PDD_THM_LowTemperatureTimeDelay_2;
}TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_2;

typedef struct {
   tS16   PDD_THM_CriticalLowTemperature_2;
}TDataPoolScc_PDD_THM_CriticalLowTemperature_2;

typedef struct {
   tU8   PDD_THM_CriticalLowTemperatureHysteresis_2;
}TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_2;

typedef struct {
   tU16   PDD_THM_CriticalLowTemperatureTimeDelay_2;
}TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_2;

typedef struct {
   tU8   PDD_THM_SensorID_3;
}TDataPoolScc_PDD_THM_SensorID_3;

typedef struct {
   tS16   PDD_THM_MaximumTemperature_3;
}TDataPoolScc_PDD_THM_MaximumTemperature_3;

typedef struct {
   tS16   PDD_THM_MinimumTemperature_3;
}TDataPoolScc_PDD_THM_MinimumTemperature_3;

typedef struct {
   tS16   PDD_THM_CriticalHighTemperature_3;
}TDataPoolScc_PDD_THM_CriticalHighTemperature_3;

typedef struct {
   tU8   PDD_THM_CriticalHighTemperatureHysteresis_3;
}TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_3;

typedef struct {
   tU16   PDD_THM_CriticalHighTemperatureTimeDelay_3;
}TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_3;

typedef struct {
   tS16   PDD_THM_HighTemperature_3;
}TDataPoolScc_PDD_THM_HighTemperature_3;

typedef struct {
   tU8   PDD_THM_HighTemperatureHysteresis_3;
}TDataPoolScc_PDD_THM_HighTemperatureHysteresis_3;

typedef struct {
   tU16   PDD_THM_HighTemperatureTimeDelay_3;
}TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_3;

typedef struct {
   tS16   PDD_THM_LowTemperature_3;
}TDataPoolScc_PDD_THM_LowTemperature_3;

typedef struct {
   tU8   PDD_THM_LowTemperatureHysteresis_3;
}TDataPoolScc_PDD_THM_LowTemperatureHysteresis_3;

typedef struct {
   tU16   PDD_THM_LowTemperatureTimeDelay_3;
}TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_3;

typedef struct {
   tS16   PDD_THM_CriticalLowTemperature_3;
}TDataPoolScc_PDD_THM_CriticalLowTemperature_3;

typedef struct {
   tU8   PDD_THM_CriticalLowTemperatureHysteresis_3;
}TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_3;

typedef struct {
   tU16   PDD_THM_CriticalLowTemperatureTimeDelay_3;
}TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_3;

typedef struct {
   tU8   PDD_THM_SensorID_4;
}TDataPoolScc_PDD_THM_SensorID_4;

typedef struct {
   tS16   PDD_THM_MaximumTemperature_4;
}TDataPoolScc_PDD_THM_MaximumTemperature_4;

typedef struct {
   tS16   PDD_THM_MinimumTemperature_4;
}TDataPoolScc_PDD_THM_MinimumTemperature_4;

typedef struct {
   tS16   PDD_THM_CriticalHighTemperature_4;
}TDataPoolScc_PDD_THM_CriticalHighTemperature_4;

typedef struct {
   tU8   PDD_THM_CriticalHighTemperatureHysteresis_4;
}TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_4;

typedef struct {
   tU16   PDD_THM_CriticalHighTemperatureTimeDelay_4;
}TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_4;

typedef struct {
   tS16   PDD_THM_HighTemperature_4;
}TDataPoolScc_PDD_THM_HighTemperature_4;

typedef struct {
   tU8   PDD_THM_HighTemperatureHysteresis_4;
}TDataPoolScc_PDD_THM_HighTemperatureHysteresis_4;

typedef struct {
   tU16   PDD_THM_HighTemperatureTimeDelay_4;
}TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_4;

typedef struct {
   tS16   PDD_THM_LowTemperature_4;
}TDataPoolScc_PDD_THM_LowTemperature_4;

typedef struct {
   tU8   PDD_THM_LowTemperatureHysteresis_4;
}TDataPoolScc_PDD_THM_LowTemperatureHysteresis_4;

typedef struct {
   tU16   PDD_THM_LowTemperatureTimeDelay_4;
}TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_4;

typedef struct {
   tS16   PDD_THM_CriticalLowTemperature_4;
}TDataPoolScc_PDD_THM_CriticalLowTemperature_4;

typedef struct {
   tU8   PDD_THM_CriticalLowTemperatureHysteresis_4;
}TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_4;

typedef struct {
   tU16   PDD_THM_CriticalLowTemperatureTimeDelay_4;
}TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_4;

typedef struct {
   tU8   PDD_THM_SensorID_5;
}TDataPoolScc_PDD_THM_SensorID_5;

typedef struct {
   tS16   PDD_THM_MaximumTemperature_5;
}TDataPoolScc_PDD_THM_MaximumTemperature_5;

typedef struct {
   tS16   PDD_THM_MinimumTemperature_5;
}TDataPoolScc_PDD_THM_MinimumTemperature_5;

typedef struct {
   tS16   PDD_THM_CriticalHighTemperature_5;
}TDataPoolScc_PDD_THM_CriticalHighTemperature_5;

typedef struct {
   tU8   PDD_THM_CriticalHighTemperatureHysteresis_5;
}TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_5;

typedef struct {
   tU16   PDD_THM_CriticalHighTemperatureTimeDelay_5;
}TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_5;

typedef struct {
   tS16   PDD_THM_HighTemperature_5;
}TDataPoolScc_PDD_THM_HighTemperature_5;

typedef struct {
   tU8   PDD_THM_HighTemperatureHysteresis_5;
}TDataPoolScc_PDD_THM_HighTemperatureHysteresis_5;

typedef struct {
   tU16   PDD_THM_HighTemperatureTimeDelay_5;
}TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_5;

typedef struct {
   tS16   PDD_THM_LowTemperature_5;
}TDataPoolScc_PDD_THM_LowTemperature_5;

typedef struct {
   tU8   PDD_THM_LowTemperatureHysteresis_5;
}TDataPoolScc_PDD_THM_LowTemperatureHysteresis_5;

typedef struct {
   tU16   PDD_THM_LowTemperatureTimeDelay_5;
}TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_5;

typedef struct {
   tS16   PDD_THM_CriticalLowTemperature_5;
}TDataPoolScc_PDD_THM_CriticalLowTemperature_5;

typedef struct {
   tU8   PDD_THM_CriticalLowTemperatureHysteresis_5;
}TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_5;

typedef struct {
   tU16   PDD_THM_CriticalLowTemperatureTimeDelay_5;
}TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_5;

typedef struct {
   tU8   PDD_THM_RESERVED;
}TDataPoolScc_PDD_THM_RESERVED;

typedef struct {
    TDataPoolScc_PDD_THM_Version   PDD_THM_Version;
    TDataPoolScc_PDD_THM_MaximumTemperature_1   PDD_THM_MaximumTemperature_1;
    TDataPoolScc_PDD_THM_MinimumTemperature_1   PDD_THM_MinimumTemperature_1;
    TDataPoolScc_PDD_THM_CriticalHighTemperature_1   PDD_THM_CriticalHighTemperature_1;
    TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_1   PDD_THM_CriticalHighTemperatureTimeDelay_1;
    TDataPoolScc_PDD_THM_HighTemperature_1   PDD_THM_HighTemperature_1;
    TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_1   PDD_THM_HighTemperatureTimeDelay_1;
    TDataPoolScc_PDD_THM_LowTemperature_1   PDD_THM_LowTemperature_1;
    TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_1   PDD_THM_LowTemperatureTimeDelay_1;
    TDataPoolScc_PDD_THM_CriticalLowTemperature_1   PDD_THM_CriticalLowTemperature_1;
    TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_1   PDD_THM_CriticalLowTemperatureTimeDelay_1;
    TDataPoolScc_PDD_THM_MaximumTemperature_2   PDD_THM_MaximumTemperature_2;
    TDataPoolScc_PDD_THM_MinimumTemperature_2   PDD_THM_MinimumTemperature_2;
    TDataPoolScc_PDD_THM_CriticalHighTemperature_2   PDD_THM_CriticalHighTemperature_2;
    TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_2   PDD_THM_CriticalHighTemperatureTimeDelay_2;
    TDataPoolScc_PDD_THM_HighTemperature_2   PDD_THM_HighTemperature_2;
    TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_2   PDD_THM_HighTemperatureTimeDelay_2;
    TDataPoolScc_PDD_THM_LowTemperature_2   PDD_THM_LowTemperature_2;
    TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_2   PDD_THM_LowTemperatureTimeDelay_2;
    TDataPoolScc_PDD_THM_CriticalLowTemperature_2   PDD_THM_CriticalLowTemperature_2;
    TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_2   PDD_THM_CriticalLowTemperatureTimeDelay_2;
    TDataPoolScc_PDD_THM_MaximumTemperature_3   PDD_THM_MaximumTemperature_3;
    TDataPoolScc_PDD_THM_MinimumTemperature_3   PDD_THM_MinimumTemperature_3;
    TDataPoolScc_PDD_THM_CriticalHighTemperature_3   PDD_THM_CriticalHighTemperature_3;
    TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_3   PDD_THM_CriticalHighTemperatureTimeDelay_3;
    TDataPoolScc_PDD_THM_HighTemperature_3   PDD_THM_HighTemperature_3;
    TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_3   PDD_THM_HighTemperatureTimeDelay_3;
    TDataPoolScc_PDD_THM_LowTemperature_3   PDD_THM_LowTemperature_3;
    TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_3   PDD_THM_LowTemperatureTimeDelay_3;
    TDataPoolScc_PDD_THM_CriticalLowTemperature_3   PDD_THM_CriticalLowTemperature_3;
    TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_3   PDD_THM_CriticalLowTemperatureTimeDelay_3;
    TDataPoolScc_PDD_THM_MaximumTemperature_4   PDD_THM_MaximumTemperature_4;
    TDataPoolScc_PDD_THM_MinimumTemperature_4   PDD_THM_MinimumTemperature_4;
    TDataPoolScc_PDD_THM_CriticalHighTemperature_4   PDD_THM_CriticalHighTemperature_4;
    TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_4   PDD_THM_CriticalHighTemperatureTimeDelay_4;
    TDataPoolScc_PDD_THM_HighTemperature_4   PDD_THM_HighTemperature_4;
    TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_4   PDD_THM_HighTemperatureTimeDelay_4;
    TDataPoolScc_PDD_THM_LowTemperature_4   PDD_THM_LowTemperature_4;
    TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_4   PDD_THM_LowTemperatureTimeDelay_4;
    TDataPoolScc_PDD_THM_CriticalLowTemperature_4   PDD_THM_CriticalLowTemperature_4;
    TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_4   PDD_THM_CriticalLowTemperatureTimeDelay_4;
    TDataPoolScc_PDD_THM_MaximumTemperature_5   PDD_THM_MaximumTemperature_5;
    TDataPoolScc_PDD_THM_MinimumTemperature_5   PDD_THM_MinimumTemperature_5;
    TDataPoolScc_PDD_THM_CriticalHighTemperature_5   PDD_THM_CriticalHighTemperature_5;
    TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_5   PDD_THM_CriticalHighTemperatureTimeDelay_5;
    TDataPoolScc_PDD_THM_HighTemperature_5   PDD_THM_HighTemperature_5;
    TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_5   PDD_THM_HighTemperatureTimeDelay_5;
    TDataPoolScc_PDD_THM_LowTemperature_5   PDD_THM_LowTemperature_5;
    TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_5   PDD_THM_LowTemperatureTimeDelay_5;
    TDataPoolScc_PDD_THM_CriticalLowTemperature_5   PDD_THM_CriticalLowTemperature_5;
    TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_5   PDD_THM_CriticalLowTemperatureTimeDelay_5;
    TDataPoolScc_PDD_THM_SensorID_1   PDD_THM_SensorID_1;
    TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_1   PDD_THM_CriticalHighTemperatureHysteresis_1;
    TDataPoolScc_PDD_THM_HighTemperatureHysteresis_1   PDD_THM_HighTemperatureHysteresis_1;
    TDataPoolScc_PDD_THM_LowTemperatureHysteresis_1   PDD_THM_LowTemperatureHysteresis_1;
    TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_1   PDD_THM_CriticalLowTemperatureHysteresis_1;
    TDataPoolScc_PDD_THM_SensorID_2   PDD_THM_SensorID_2;
    TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_2   PDD_THM_CriticalHighTemperatureHysteresis_2;
    TDataPoolScc_PDD_THM_HighTemperatureHysteresis_2   PDD_THM_HighTemperatureHysteresis_2;
    TDataPoolScc_PDD_THM_LowTemperatureHysteresis_2   PDD_THM_LowTemperatureHysteresis_2;
    TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_2   PDD_THM_CriticalLowTemperatureHysteresis_2;
    TDataPoolScc_PDD_THM_SensorID_3   PDD_THM_SensorID_3;
    TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_3   PDD_THM_CriticalHighTemperatureHysteresis_3;
    TDataPoolScc_PDD_THM_HighTemperatureHysteresis_3   PDD_THM_HighTemperatureHysteresis_3;
    TDataPoolScc_PDD_THM_LowTemperatureHysteresis_3   PDD_THM_LowTemperatureHysteresis_3;
    TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_3   PDD_THM_CriticalLowTemperatureHysteresis_3;
    TDataPoolScc_PDD_THM_SensorID_4   PDD_THM_SensorID_4;
    TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_4   PDD_THM_CriticalHighTemperatureHysteresis_4;
    TDataPoolScc_PDD_THM_HighTemperatureHysteresis_4   PDD_THM_HighTemperatureHysteresis_4;
    TDataPoolScc_PDD_THM_LowTemperatureHysteresis_4   PDD_THM_LowTemperatureHysteresis_4;
    TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_4   PDD_THM_CriticalLowTemperatureHysteresis_4;
    TDataPoolScc_PDD_THM_SensorID_5   PDD_THM_SensorID_5;
    TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_5   PDD_THM_CriticalHighTemperatureHysteresis_5;
    TDataPoolScc_PDD_THM_HighTemperatureHysteresis_5   PDD_THM_HighTemperatureHysteresis_5;
    TDataPoolScc_PDD_THM_LowTemperatureHysteresis_5   PDD_THM_LowTemperatureHysteresis_5;
    TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_5   PDD_THM_CriticalLowTemperatureHysteresis_5;
    TDataPoolScc_PDD_THM_RESERVED   PDD_THM_RESERVED;
}TDataPoolScc_ThmDpPDD;

typedef struct {
  TPddScc_Header    PddSccHeader;
  TDataPoolScc_ThmDpPDD   ThmDpPDD;
}TPddScc_ThmDpPDD;


/*-----------------------------------------------------------------------
 ---- structure TPddScc_DimmingDpPDD for pool DimmingDpPDD
 -----------------------------------------------------------------------*/
#define DATAPOOL_SCC_VERSION_POOL_DIMMINGDPPDD     0x0002 
#define DATAPOOL_SCC_IDENTITY_NUMBER_DIMMINGDPPDD  3

/*array numer of elements*/
#define DATAPOOL_SCC_BRIGTHNESS_CURVE_HMI_NIGHT_NUMBER  33
#define DATAPOOL_SCC_BRIGTHNESS_CURVE_HMI_DAY_NUMBER  33
#define DATAPOOL_SCC_KEYB_LED_CALIBRATION_VALUE_NUMBER  9
#define DATAPOOL_SCC_BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON_NUMBER  21

typedef struct {
   tU16   BRIGTHNESS_CURVE_HMI_NIGHT[DATAPOOL_SCC_BRIGTHNESS_CURVE_HMI_NIGHT_NUMBER];
}TDataPoolScc_BRIGTHNESS_CURVE_HMI_NIGHT;

typedef struct {
   tU16   BRIGTHNESS_CURVE_HMI_DAY[DATAPOOL_SCC_BRIGTHNESS_CURVE_HMI_DAY_NUMBER];
}TDataPoolScc_BRIGTHNESS_CURVE_HMI_DAY;

typedef struct {
   tU16   DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY;
}TDataPoolScc_DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY;

typedef struct {
   tU16   KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY;
}TDataPoolScc_KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY;

typedef struct {
   tU8   BRIGTHNESS_NO_OF_HMI_OFFSET;
}TDataPoolScc_BRIGTHNESS_NO_OF_HMI_OFFSET;

typedef struct {
   tU8   NUMBER_OF_KEYS;
}TDataPoolScc_NUMBER_OF_KEYS;

typedef struct {
   tU8   HIGH_TEMPERATURE;
}TDataPoolScc_HIGH_TEMPERATURE;

typedef struct {
   tU8   CRITICAL_TEMPERATURE;
}TDataPoolScc_CRITICAL_TEMPERATURE;

typedef struct {
   tS8   LOW_TEMPERATURE;
}TDataPoolScc_LOW_TEMPERATURE;

typedef struct {
   tU8   TEMP_HYSTERESIS;
}TDataPoolScc_TEMP_HYSTERESIS;

typedef struct {
   tU8   TEMP_COMPENSATION_PWM_MIN;
}TDataPoolScc_TEMP_COMPENSATION_PWM_MIN;

typedef struct {
   tU16   KEYB_LED_CALIBRATION_VALUE[DATAPOOL_SCC_KEYB_LED_CALIBRATION_VALUE_NUMBER];
}TDataPoolScc_KEYB_LED_CALIBRATION_VALUE;

typedef struct {
   tU8   BRANDNAME;
}TDataPoolScc_BRANDNAME;

typedef struct {
   tU8   DISPLAY_TYPE;
}TDataPoolScc_DISPLAY_TYPE;

typedef struct {
   tU8   DIMMING_COCKPIT_STRATEGY;
}TDataPoolScc_DIMMING_COCKPIT_STRATEGY;

typedef struct {
   tU8   KEY_BRIGHTNESS_NUMOF_OFFSETS;
}TDataPoolScc_KEY_BRIGHTNESS_NUMOF_OFFSETS;

typedef struct {
   tU8   DAMPING_STRATEGY;
}TDataPoolScc_DAMPING_STRATEGY;

typedef struct {
   tU8   DAMPING_SAMPLING_TIMETE;
}TDataPoolScc_DAMPING_SAMPLING_TIMETE;

typedef struct {
   tU8   DAMPING_CONSTANTK;
}TDataPoolScc_DAMPING_CONSTANTK;

typedef struct {
   tU8   DAMPING_CONSTANTJ;
}TDataPoolScc_DAMPING_CONSTANTJ;

typedef struct {
   tU16   BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY;
}TDataPoolScc_BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY;

typedef struct {
   tU16   BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT;
}TDataPoolScc_BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT;

typedef struct {
   tU16   BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT;
}TDataPoolScc_BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT;

typedef struct {
   tU16   BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON;
}TDataPoolScc_BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON;

typedef struct {
   tU16   BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF;
}TDataPoolScc_BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF;

typedef struct {
   tU16   BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON[DATAPOOL_SCC_BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON_NUMBER];
}TDataPoolScc_BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON;

typedef struct {
   tU16   DAY_NIGHT_DELAY;
}TDataPoolScc_DAY_NIGHT_DELAY;

typedef struct {
   tU8   DIMMING_ARCHITECTURE;
}TDataPoolScc_DIMMING_ARCHITECTURE;

typedef struct {
    TDataPoolScc_BRIGTHNESS_CURVE_HMI_NIGHT   BRIGTHNESS_CURVE_HMI_NIGHT;
    TDataPoolScc_BRIGTHNESS_CURVE_HMI_DAY   BRIGTHNESS_CURVE_HMI_DAY;
    TDataPoolScc_DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY   DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY;
    TDataPoolScc_KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY   KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY;
    TDataPoolScc_KEYB_LED_CALIBRATION_VALUE   KEYB_LED_CALIBRATION_VALUE;
    TDataPoolScc_BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY   BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY;
    TDataPoolScc_BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT   BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT;
    TDataPoolScc_BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT   BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT;
    TDataPoolScc_BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON   BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON;
    TDataPoolScc_BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF   BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF;
    TDataPoolScc_BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON   BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON;
    TDataPoolScc_DAY_NIGHT_DELAY   DAY_NIGHT_DELAY;
    TDataPoolScc_BRIGTHNESS_NO_OF_HMI_OFFSET   BRIGTHNESS_NO_OF_HMI_OFFSET;
    TDataPoolScc_NUMBER_OF_KEYS   NUMBER_OF_KEYS;
    TDataPoolScc_HIGH_TEMPERATURE   HIGH_TEMPERATURE;
    TDataPoolScc_CRITICAL_TEMPERATURE   CRITICAL_TEMPERATURE;
    TDataPoolScc_LOW_TEMPERATURE   LOW_TEMPERATURE;
    TDataPoolScc_TEMP_HYSTERESIS   TEMP_HYSTERESIS;
    TDataPoolScc_TEMP_COMPENSATION_PWM_MIN   TEMP_COMPENSATION_PWM_MIN;
    TDataPoolScc_BRANDNAME   BRANDNAME;
    TDataPoolScc_DISPLAY_TYPE   DISPLAY_TYPE;
    TDataPoolScc_DIMMING_COCKPIT_STRATEGY   DIMMING_COCKPIT_STRATEGY;
    TDataPoolScc_KEY_BRIGHTNESS_NUMOF_OFFSETS   KEY_BRIGHTNESS_NUMOF_OFFSETS;
    TDataPoolScc_DAMPING_STRATEGY   DAMPING_STRATEGY;
    TDataPoolScc_DAMPING_SAMPLING_TIMETE   DAMPING_SAMPLING_TIMETE;
    TDataPoolScc_DAMPING_CONSTANTK   DAMPING_CONSTANTK;
    TDataPoolScc_DAMPING_CONSTANTJ   DAMPING_CONSTANTJ;
    TDataPoolScc_DIMMING_ARCHITECTURE   DIMMING_ARCHITECTURE;
}TDataPoolScc_DimmingDpPDD;

typedef struct {
  TPddScc_Header    PddSccHeader;
  TDataPoolScc_DimmingDpPDD   DimmingDpPDD;
}TPddScc_DimmingDpPDD;


/*-----------------------------------------------------------------------
 ---- structure TPddScc_InputDP for pool InputDP
 -----------------------------------------------------------------------*/
#define DATAPOOL_SCC_VERSION_POOL_INPUTDP     0x0002 
#define DATAPOOL_SCC_IDENTITY_NUMBER_INPUTDP  1

/*array numer of elements*/
#define DATAPOOL_SCC_KEYMATRIXDATA_NUMBER  32
#define DATAPOOL_SCC_SYSTEMKEYDATA_NUMBER  4
#define DATAPOOL_SCC_CARBUSDATA_NUMBER  32
#define DATAPOOL_SCC_ITCOMMANDERDATA_NUMBER  16
#define DATAPOOL_SCC_RSCDATA_NUMBER  16

typedef struct {
   tU32   KeyMatrixData[DATAPOOL_SCC_KEYMATRIXDATA_NUMBER];
}TDataPoolScc_KeyMatrixData;

typedef struct {
   tU32   SystemKeyData[DATAPOOL_SCC_SYSTEMKEYDATA_NUMBER];
}TDataPoolScc_SystemKeyData;

typedef struct {
   tU32   CarBusData[DATAPOOL_SCC_CARBUSDATA_NUMBER];
}TDataPoolScc_CarBusData;

typedef struct {
   tU32   ITCommanderData[DATAPOOL_SCC_ITCOMMANDERDATA_NUMBER];
}TDataPoolScc_ITCommanderData;

typedef struct {
   tU32   RSCData[DATAPOOL_SCC_RSCDATA_NUMBER];
}TDataPoolScc_RSCData;

typedef struct {
    TDataPoolScc_KeyMatrixData   KeyMatrixData;
    TDataPoolScc_SystemKeyData   SystemKeyData;
    TDataPoolScc_CarBusData   CarBusData;
    TDataPoolScc_ITCommanderData   ITCommanderData;
    TDataPoolScc_RSCData   RSCData;
}TDataPoolScc_InputDP;

typedef struct {
  TPddScc_Header    PddSccHeader;
  TDataPoolScc_InputDP   InputDP;
}TPddScc_InputDP;


/*-----------------------------------------------------------------------
 ---- structure TPddScc_CsmDpPDD for pool CsmDpPDD
 -----------------------------------------------------------------------*/
#define DATAPOOL_SCC_VERSION_POOL_CSMDPPDD     0x0001 
#define DATAPOOL_SCC_IDENTITY_NUMBER_CSMDPPDD  6

/*array numer of elements*/

typedef struct {
   tU8   SlotNr;
}TDataPoolScc_SlotNr;

typedef struct {
   tU8   SteeringWheelType;
}TDataPoolScc_SteeringWheelType;

typedef struct {
   tU8   VoiceRec;
}TDataPoolScc_VoiceRec;

typedef struct {
   tU8   FuelType;
}TDataPoolScc_FuelType;

typedef struct {
   tU8   CameraSystem;
}TDataPoolScc_CameraSystem;

typedef struct {
   tU8   IpaHfp;
}TDataPoolScc_IpaHfp;

typedef struct {
   tU8   Sonar;
}TDataPoolScc_Sonar;

typedef struct {
   tU8   AntiTheft;
}TDataPoolScc_AntiTheft;

typedef struct {
   tU8   AnticipatoryLine;
}TDataPoolScc_AnticipatoryLine;

typedef struct {
   tU8   SteeringMsg;
}TDataPoolScc_SteeringMsg;

typedef struct {
   tU8   TrafficSignRec;
}TDataPoolScc_TrafficSignRec;

typedef struct {
   tU8   NaviFunc;
}TDataPoolScc_NaviFunc;

typedef struct {
   tU8   RCSType;
}TDataPoolScc_RCSType;

typedef struct {
   tU8   ITCommanderType;
}TDataPoolScc_ITCommanderType;

typedef struct {
   tU8   VCANMCANGateway;
}TDataPoolScc_VCANMCANGateway;

typedef struct {
   tU8   FuelConsumptionInfo;
}TDataPoolScc_FuelConsumptionInfo;

typedef struct {
   tU8   TPMS;
}TDataPoolScc_TPMS;

typedef struct {
   tU8   VDC;
}TDataPoolScc_VDC;

typedef struct {
   tU8   AdFunction;
}TDataPoolScc_AdFunction;

typedef struct {
   tU8   VehicleSetting;
}TDataPoolScc_VehicleSetting;

typedef struct {
   tU8   HudSetting;
}TDataPoolScc_HudSetting;

typedef struct {
   tU8   HvacType;
}TDataPoolScc_HvacType;

typedef struct {
   tU8   DigitalAssi;
}TDataPoolScc_DigitalAssi;

typedef struct {
   tU8   SendCountryInfo;
}TDataPoolScc_SendCountryInfo;

typedef struct {
    TDataPoolScc_SlotNr   SlotNr;
    TDataPoolScc_SteeringWheelType   SteeringWheelType;
    TDataPoolScc_VoiceRec   VoiceRec;
    TDataPoolScc_FuelType   FuelType;
    TDataPoolScc_CameraSystem   CameraSystem;
    TDataPoolScc_IpaHfp   IpaHfp;
    TDataPoolScc_Sonar   Sonar;
    TDataPoolScc_AntiTheft   AntiTheft;
    TDataPoolScc_AnticipatoryLine   AnticipatoryLine;
    TDataPoolScc_SteeringMsg   SteeringMsg;
    TDataPoolScc_TrafficSignRec   TrafficSignRec;
    TDataPoolScc_NaviFunc   NaviFunc;
    TDataPoolScc_RCSType   RCSType;
    TDataPoolScc_ITCommanderType   ITCommanderType;
    TDataPoolScc_VCANMCANGateway   VCANMCANGateway;
    TDataPoolScc_FuelConsumptionInfo   FuelConsumptionInfo;
    TDataPoolScc_TPMS   TPMS;
    TDataPoolScc_VDC   VDC;
    TDataPoolScc_AdFunction   AdFunction;
    TDataPoolScc_VehicleSetting   VehicleSetting;
    TDataPoolScc_HudSetting   HudSetting;
    TDataPoolScc_HvacType   HvacType;
    TDataPoolScc_DigitalAssi   DigitalAssi;
    TDataPoolScc_SendCountryInfo   SendCountryInfo;
}TDataPoolScc_CsmDpPDD;

typedef struct {
  TPddScc_Header    PddSccHeader;
  TDataPoolScc_CsmDpPDD   CsmDpPDD;
}TPddScc_CsmDpPDD;



#endif
