/**
* @file NavDataUpdateSetting.h
* @copyright (c) 2017-2020 Robert Bosch Car Multimedia GmbH
* @brief NavDataUpdate setting for Favorite region
* @addtogroup
* @{
*/

#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_NAVDATAUPDATESETTINGS_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_NAVDATAUPDATESETTINGS_H_

#include <sstream>
#include <string>
#include <set>
#include "InfoTypes.h"

namespace navmiddleware
{
namespace settings
{
enum FavoriteUpdateRegionStatus
{
   FAVORITE_UPDATE_REGION_STATUS__UKNOWN,
   FAVORITE_UPDATE_REGION_STATUS__ACTIVATED_DEFAULT_SETTINGS,
   FAVORITE_UPDATE_REGION_STATUS__SERVER_UPDATED_SETTINGS,
   FAVORITE_UPDATE_REGION_STATUS__STORED_SETTINGS,
   FAVORITE_UPDATE_REGION_STATUS__SUGGESTED_SETTINGS,
   FAVORITE_UPDATE_REGION_STATUS__USER_UPDATED_SETTINGS
};

inline ::std::string toString(FavoriteUpdateRegionStatus favoriteUpdateRegionStatus)
{
   switch (favoriteUpdateRegionStatus)
   {
   case FAVORITE_UPDATE_REGION_STATUS__ACTIVATED_DEFAULT_SETTINGS:
      return("FAVORITE_UPDATE_REGION_STATUS__ACTIVATED_DEFAULT_SETTINGS");

   case FAVORITE_UPDATE_REGION_STATUS__SERVER_UPDATED_SETTINGS:
      return("FAVORITE_UPDATE_REGION_STATUS__SERVER_UPDATED_SETTINGS");

   case FAVORITE_UPDATE_REGION_STATUS__STORED_SETTINGS:
      return("FAVORITE_UPDATE_REGION_STATUS__STORED_SETTINGS");

   case FAVORITE_UPDATE_REGION_STATUS__SUGGESTED_SETTINGS:
      return("FAVORITE_UPDATE_REGION_STATUS__SUGGESTED_SETTINGS");

   case FAVORITE_UPDATE_REGION_STATUS__USER_UPDATED_SETTINGS:
      return("FAVORITE_UPDATE_REGION_STATUS__USER_UPDATED_SETTINGS");

   default:
      return("FAVORITE_UPDATE_REGION_STATUS__UKNOWN");
   }
}

enum AutomaticMapUpdateStatus
{
   AUTOMATIC_MAP_UPDATE_STATUS__ENABLED,
   AUTOMATIC_MAP_UPDATE_STATUS__DISABLED
};

inline ::std::string toString(AutomaticMapUpdateStatus automaticMapUpdateStatus)
{
   switch (automaticMapUpdateStatus)
   {
   case AUTOMATIC_MAP_UPDATE_STATUS__ENABLED:
      return("AUTOMATIC_MAP_UPDATE_STATUS__ENABLED");

   case AUTOMATIC_MAP_UPDATE_STATUS__DISABLED:
      return("AUTOMATIC_MAP_UPDATE_STATUS__DISABLED");

   default:
      return("AUTOMATIC_MAP_UPDATE_STATUS__NOT_DEFINED");
   }
}

class NavDataUpdateFavoriteRegionSettings
{
public:

   class ProductIdentifier
   {
   public:
      ProductIdentifier()
         : m_productId(0)
         , m_supplierId(0)
         , m_baselineMapId(0)
      {}
      ProductIdentifier(uint32_t productId, uint32_t supplierId, uint32_t baselineMapId)
         : m_productId(productId)
         , m_supplierId(supplierId)
         , m_baselineMapId(baselineMapId)
      {}
      ~ProductIdentifier()
      {}

      uint32_t getBaselineMapId() const
      {
         return m_baselineMapId;
      }

      void setBaselineMapId(uint32_t baselineMapId)
      {
         m_baselineMapId = baselineMapId;
      }

      uint32_t getProductId() const
      {
         return m_productId;
      }

      void setProductId(uint32_t productId)
      {
         m_productId = productId;
      }

      uint32_t getSupplierId() const
      {
         return m_supplierId;
      }

      void setSupplierId(uint32_t supplierId)
      {
         m_supplierId = supplierId;
      }

      ::std::string toString() const
      {
         ::std::stringstream stream("productIdentifier payload:\n");
         stream << ::std::endl
                << "m_productId = " << m_productId << ::std::endl
                << "m_supplierId = " << m_supplierId << ::std::endl
                << "m_baselineMapId = " << m_baselineMapId << ::std::endl;
         return stream.str();
      }

      bool operator==(const ProductIdentifier& rhs) const
      {
         return ((m_productId == rhs.m_productId) &&
                 (m_supplierId == rhs.m_supplierId) &&
                 (m_baselineMapId == rhs.m_baselineMapId));
      }

      bool operator!=(const ProductIdentifier& rhs) const
      {
         return (!(*this == rhs));
      }

   private:
      uint32_t      m_productId;
      uint32_t      m_supplierId;
      uint32_t      m_baselineMapId;
   };

   NavDataUpdateFavoriteRegionSettings()
      : m_productIdentifier(0, 0, 0)
      , m_favoriteUpdateRegionStatus(FAVORITE_UPDATE_REGION_STATUS__UKNOWN)
      , m_automaticUpdate(false)
   {
   }

   ~NavDataUpdateFavoriteRegionSettings()
   {

   }

   ::std::string toString() const
   {
      ::std::stringstream stream("NavDataUpdateFavoriteRegionSettings payload:\n");
      stream << ::std::endl
             << m_productIdentifier.toString()
             << "m_regionIds = ";
      for (::std::set<uint32_t>::const_iterator it = m_updateRegionIds.begin(); it != m_updateRegionIds.end(); ++it)
      {
         stream << *it <<", ";
      }
      stream << ::std::endl
             << "m_favoriteUpdateRegionStatus = " << ::navmiddleware::settings::toString(m_favoriteUpdateRegionStatus) << ::std::endl;
      stream << "m_automaticUpdate = " << (m_automaticUpdate ? "true" : "false") << ::std::endl;

      return stream.str();
   }

   bool operator==(const NavDataUpdateFavoriteRegionSettings& rhs) const
   {
      return ((m_updateRegionIds == rhs.m_updateRegionIds) &&
              (m_productIdentifier == rhs.m_productIdentifier) &&
              (m_favoriteUpdateRegionStatus==rhs.m_favoriteUpdateRegionStatus) &&
              (m_automaticUpdate == rhs.m_automaticUpdate));
   }

   bool operator!=(const NavDataUpdateFavoriteRegionSettings& rhs) const
   {
      return (!(*this == rhs));
   }

   const ProductIdentifier& getProductIdentifier() const
   {
      return m_productIdentifier;
   }

   void setProductIdentifier(const ProductIdentifier& productIdentifier)
   {
      m_productIdentifier = productIdentifier;
   }

   const ::std::set<uint32_t>& getUpdateRegionIds() const
   {
      return m_updateRegionIds;
   }

   ::std::set<uint32_t>& getUpdateRegionIdsMutable()
   {
      return m_updateRegionIds;
   }

   FavoriteUpdateRegionStatus getFavoriteUpdateRegionStatus() const
   {
      return m_favoriteUpdateRegionStatus;
   }

   void setFavoriteUpdateRegionStatus(const FavoriteUpdateRegionStatus favoriteUpdateRegionStatus)
   {
      m_favoriteUpdateRegionStatus = favoriteUpdateRegionStatus;
   }

   void setAutomaticUpdate(bool automaticUpdate)
   {
      m_automaticUpdate = automaticUpdate;
   }

   bool isAutomaticUpdateActive() const
   {
      return m_automaticUpdate;
   }

private:
   ::std::set<uint32_t>          m_updateRegionIds;
   ProductIdentifier             m_productIdentifier;
   FavoriteUpdateRegionStatus    m_favoriteUpdateRegionStatus;
   bool                          m_automaticUpdate; /** JP specific interface */
};

}
}

#endif  // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_NAVDATAUPDATESETTINGS_H_
