/**
* @copyright (c) 2017-2020 Robert Bosch Car Multimedia GmbH
* @addtogroup NavMiddleware
* @{
*/

#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_LOCATIONBASEDSERVICESSETTINGS_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_LOCATIONBASEDSERVICESSETTINGS_H_

#include <string>

namespace navmiddleware
{
namespace settings
{

enum WeatherInformationSource
{
   WEATHER_INFORMATION_SOURCE__SXM,
   WEATHER_INFORMATION_SOURCE__TOMTOM
};

inline ::std::string toString(WeatherInformationSource weatherInformationSource)
{
   switch (weatherInformationSource)
   {
   case WEATHER_INFORMATION_SOURCE__SXM:
      return "WEATHER_INFORMATION_SOURCE__SXM";
   case WEATHER_INFORMATION_SOURCE__TOMTOM:
      return "WEATHER_INFORMATION_SOURCE__TOMTOM";
   default:
      return "<unknown>";
   }
}

class LocationBasedServicesSettings
{
public:
   LocationBasedServicesSettings()
      : m_weatherInformationSource(WEATHER_INFORMATION_SOURCE__SXM)
      , m_weatherDataCommunicationEnabled(false)
   {
   }

   LocationBasedServicesSettings(
      const WeatherInformationSource& weatherInformationSource,
      bool weatherDataCommunicationEnabled)

      : m_weatherInformationSource(weatherInformationSource)
      , m_weatherDataCommunicationEnabled(weatherDataCommunicationEnabled)
   {
   }

   bool operator == (const LocationBasedServicesSettings& rhs) const
   {
      return (m_weatherInformationSource == rhs.m_weatherInformationSource &&
              m_weatherDataCommunicationEnabled == rhs.m_weatherDataCommunicationEnabled);
   }

   bool operator != (const LocationBasedServicesSettings& rhs) const
   {
      return !(*this == rhs);
   }

   WeatherInformationSource getWeatherInformationSource() const
   {
      return m_weatherInformationSource;
   }

   void setWeatherInformationSource(WeatherInformationSource weatherInformationSource)
   {
      m_weatherInformationSource = weatherInformationSource;
   }

   bool isWeatherDataCommunicationStateEnabled() const
   {
      return m_weatherDataCommunicationEnabled;
   }

   void setWeatherDataCommunicationEnabled(bool weatherDataCommunicationEnabled)
   {
      m_weatherDataCommunicationEnabled = weatherDataCommunicationEnabled;
   }

   ::std::string toString() const
   {
      ::std::stringstream stream("LocationBasedServicesSettings payload:\n");
      stream << ::std::endl;

      stream << "\tm_weatherInformationSource: " << ::navmiddleware::settings::toString(m_weatherInformationSource) << ::std::endl
             << "\tm_weatherDataCommunicationEnabled: " << m_weatherDataCommunicationEnabled << ::std::endl;

      return stream.str();
   }

private:
   WeatherInformationSource m_weatherInformationSource;
   bool                     m_weatherDataCommunicationEnabled;
};

}
}
#endif  // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_LOCATIONBASEDSERVICESSETTINGS_H_
