/*
 * InterfaceTraceConfig.h
 * @copyright (c) 2015-2020 Robert Bosch Car Multimedia GmbH
 * @addtogroup navmiddleware
 * @{
 */

#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INTERFACETRACECONFIG_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INTERFACETRACECONFIG_H_

#include <asf/core/Logger.h>
#include <asf/core/Logging.h>
#include <utility>
#include <string>

#define INTERFACE_LOGGER(DOMAINLOGGER) DEFINE_LOGGER(_logger##DOMAINLOGGER, "navmiddleware/"#DOMAINLOGGER);

#ifdef _MSC_VER
#define LOG_INTERFACE(DOMAINLOGGER, FORMAT,...) LOG_INTERFACE_INFO(DOMAINLOGGER, FORMAT, __VA_ARGS__)
#define LOG_INTERFACE_STATIC(DOMAINLOGGER, FORMAT,...) LOG_INTERFACE_INFO_STATIC(DOMAINLOGGER, FORMAT, __VA_ARGS__)
#define LOG_INTERFACE_INFO(DOMAINLOGGER, FORMAT,...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_INFO(FORMAT, __VA_ARGS__); }
#define LOG_INTERFACE_INFO_STATIC(DOMAINLOGGER, FORMAT,...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_INFO_STATIC(FORMAT, __VA_ARGS__); }
#define LOG_INTERFACE_DEBUG(DOMAINLOGGER, FORMAT,...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_DEBUG(FORMAT, __VA_ARGS__); }
#define LOG_INTERFACE_DEBUG_STATIC(DOMAINLOGGER, FORMAT,...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_DEBUG_STATIC(FORMAT, __VA_ARGS__); }
#define LOG_INTERFACE_WARN(DOMAINLOGGER, FORMAT,...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_WARN(FORMAT, __VA_ARGS__); }
#define LOG_INTERFACE_WARN_STATIC(DOMAINLOGGER, FORMAT,...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_WARN_STATIC(FORMAT, FORMAT, __VA_ARGS__); }
#define LOG_INTERFACE_ERROR(DOMAINLOGGER, FORMAT,...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_ERROR(FORMAT, __VA_ARGS__); }
#define LOG_INTERFACE_ERROR_STATIC(DOMAINLOGGER, FORMAT,...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_ERROR_STATIC(FORMAT, __VA_ARGS__); }
#else
#define LOG_INTERFACE(DOMAINLOGGER, ...) LOG_INTERFACE_INFO(DOMAINLOGGER, __VA_ARGS__)
#define LOG_INTERFACE_STATIC(DOMAINLOGGER, ...) LOG_INTERFACE_INFO_STATIC(DOMAINLOGGER, __VA_ARGS__)
#define LOG_INTERFACE_INFO(DOMAINLOGGER, ...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_INFO(__VA_ARGS__); }
#define LOG_INTERFACE_INFO_STATIC(DOMAINLOGGER, ...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_INFO_STATIC(__VA_ARGS__); }
#define LOG_INTERFACE_DEBUG(DOMAINLOGGER, ...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_DEBUG(__VA_ARGS__); }
#define LOG_INTERFACE_DEBUG_STATIC(DOMAINLOGGER, ...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_DEBUG_STATIC(__VA_ARGS__); }
#define LOG_INTERFACE_WARN(DOMAINLOGGER, ...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_WARN(__VA_ARGS__); }
#define LOG_INTERFACE_WARN_STATIC(DOMAINLOGGER, ...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_WARN_STATIC(__VA_ARGS__); }
#define LOG_INTERFACE_ERROR(DOMAINLOGGER, ...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_ERROR(__VA_ARGS__); }
#define LOG_INTERFACE_ERROR_STATIC(DOMAINLOGGER, ...) { SET_LOGGER(_logger##DOMAINLOGGER); LOG_ERROR_STATIC(__VA_ARGS__); }
#endif

namespace
{
void enableLogger(const ::std::string& logger, ::asf::core::Logging::Level level)
{
   ::asf::core::Logging::LoggerConfiguration lc;
   ::std::string matchExpression = "";
   ::asf::core::Logger::getConfiguration(lc, matchExpression);
   lc.getLoggerLevelMutable().insert(std::pair< ::std::string, ::asf::core::Logging::Level>(logger, level));
   ::asf::core::Logger::setConfiguration(lc);
}
void disableLogger(const ::std::string& logger)
{
   ::asf::core::Logging::LoggerConfiguration lc;
   ::std::string matchExpression = "";
   ::asf::core::Logger::getConfiguration(lc, matchExpression);
   lc.getLoggerLevelMutable().insert(std::pair< ::std::string, ::asf::core::Logging::Level>(logger, ::asf::core::Logging::Level__Off));
   ::asf::core::Logger::setConfiguration(lc);
}
}


#define ENABLE_INTERFACE_LOGGER(DOMAINLOGGER, LEVEL) enableLogger("navmiddleware/"#DOMAINLOGGER, LEVEL)
#define DISABLE_INTERFACE_LOGGER(DOMAINLOGGER) disableLogger("navmiddleware/"#DOMAINLOGGER)


#endif  // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INTERFACETRACECONFIG_H_
