/**
* @copyright (c) 2015-2020 Robert Bosch Car Multimedia GmbH
* @addtogroup NavMiddleware
* @{
*/

#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INFO_ENGINEERINGINFOS_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INFO_ENGINEERINGINFOS_H_

#include <string>
#include <sstream>
#include <vector>

namespace navmiddleware
{

class EngineeringInfos
{
public:
   EngineeringInfos(): m_isMenu(false), m_isUserInput(false), m_selectedMenuLevel(0) {}
   virtual ~EngineeringInfos() {}

   const ::std::string& getTitle() const
   {
      return m_title;
   }
   void setTitle(const ::std::string& title)
   {
      m_title = title;
   }

   bool isMenu() const
   {
      return m_isMenu;
   }
   void setIsMenu(bool isMenu)
   {
      m_isMenu = isMenu;
   }

   bool isUserInput() const
   {
      return m_isUserInput;
   }
   void setIsUserInput(bool isUserInput)
   {
      m_isUserInput = isUserInput;
   }

   const ::std::string& getValue() const
   {
      return m_value;
   }
   void setValue(const ::std::string& value)
   {
      m_value = value;
   }

   const ::std::vector < ::std::string >& getMenuItems() const
   {
      return m_menuItems;
   }
   ::std::vector < ::std::string>& getMenuItems()
   {
      return m_menuItems;
   }
   void setMenuItems(const ::std::vector< ::std::string >& menuItems)
   {
      m_menuItems = menuItems;
   }

   unsigned int getSelectedMenuLevel() const
   {
      return m_selectedMenuLevel;
   }
   void setSelectedMenuLevel(unsigned int selectedMenuLevel)
   {
      m_selectedMenuLevel = selectedMenuLevel;
   }

   ::std::string toString() const
   {
      ::std::stringstream stream("EngineeringInfos payload:\n");

      stream << "title =" << m_title << ","
             << "is menu = "<< (m_isMenu? "true":"false") << ","
             << "m_isUserInput = " << (m_isUserInput? "true":"false") << ","
             << "Value = "<< m_value << ","
             << "Selected Menu level = "<< m_selectedMenuLevel << ::std::endl;

      for(unsigned int menuListIndex = 0; menuListIndex < getMenuItems().size(); menuListIndex++)
      {
         stream << "Menu list index = "<< menuListIndex << std::endl
                << " Menu string = " << getMenuItems().at(menuListIndex).c_str() << std::endl;
      }

      return stream.str();
   }

   bool operator==(const EngineeringInfos& rhs) const
   {
      return (m_title == rhs.m_title)   &&
             (m_isMenu == rhs.m_isMenu) &&
             (m_isUserInput == rhs.m_isUserInput) &&
             (m_value == rhs.m_value) &&
             (m_menuItems == rhs.m_menuItems) &&
             (m_selectedMenuLevel == rhs.m_selectedMenuLevel);
   }

   bool operator!=(const EngineeringInfos& rhs) const
   {
      return ! (*this == rhs);
   }

private:
   ::std::string m_title;
   bool m_isMenu;
   bool m_isUserInput;
   ::std::string m_value;
   ::std::vector< ::std::string > m_menuItems;
   unsigned int m_selectedMenuLevel;
};

class EngineeringDebugInfos
{
public:
   EngineeringDebugInfos() {}
   virtual ~EngineeringDebugInfos() {}

   void setComponent(const ::std::string& component)
   {
      m_component = component;
   }

   const ::std::string& getComponent() const
   {
      return m_component;
   }

   void setDebugInformation(const ::std::vector< ::std::string >& debugInformation)
   {
      m_debugInformation = debugInformation;
   }

   const ::std::vector< ::std::string >& getDebugInformation() const
   {
      return m_debugInformation;
   }

   bool operator==(const EngineeringDebugInfos& rhs) const
   {
      return (m_component == rhs.m_component) &&
             (m_debugInformation == rhs.m_debugInformation);
   }

   bool operator!=(const EngineeringDebugInfos& rhs) const
   {
      return ! (*this == rhs);
   }

   ::std::string toString() const
   {
      ::std::stringstream stream("EngineeringDebugInfos payload:\n");

      stream << "m_component =" << m_component << ::std::endl;
      stream << "Debug Information =" << ::std::endl;

      for(unsigned int listIndex = 0; listIndex < getDebugInformation().size(); listIndex++)
      {
         stream << getDebugInformation().at(listIndex).c_str() << ::std::endl;
      }

      return stream.str();
   }

private:
   //will contain the information about the component.
   //Example: TrafficDebugInformation, RouteDebugInformation...
   ::std::string m_component;
   ::std::vector< ::std::string > m_debugInformation;
};

} /* namespace navmiddleware */

#endif // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INFO_ENGINEERINGINFOS_H_
