/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     TaskPool.h
 *\brief
 *
 *\author   CM/ESA2
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2017 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_THREADING_TASKPOOL_H
#define ASF_THREADING_TASKPOOL_H
#include <boost/shared_ptr.hpp>
#include <set>
#include <string>
#include <vector>
#include "asf/core/MessageQueue.h"
#include "asf/core/StartStopWaitIF.h"
#include "asf/core/Types.h"
#include "asf/threading/Mutex.h"
#include "asf/threading/RunnableIF.h"
#include "asf/threading/Thread.h"

namespace asf {
namespace threading {

class TaskPool : public ::asf::core::StartStopWaitIF {
public:
    TaskPool(uint32 count, const std::string& name);

    virtual ~TaskPool();

    void start();

    void stop();

    void waitForCompletion();

    void execute(const ::boost::shared_ptr< RunnableIF >& run);

private:
    static void* threadFunction(void* arg);

    void runTasks();

    void addActiveRunner(const ::boost::shared_ptr< RunnableIF >& runner);

    void removeActiveRunner(const ::boost::shared_ptr< RunnableIF >& runner);

    void interruptActiveRunner();

    uint32 _count;

    std::string _name;

    ::asf::core::MessageQueue< RunnableIF > _runnerQueue;

    Mutex _threadPoolMutex;

    std::vector< Thread* > _threadPool;

    Mutex _activeRunnerMutex;

    std::set< ::boost::shared_ptr< RunnableIF > > _activeRunner;

    bool _interruptedActiveRunner;

    DECLARE_CLASS_LOGGER();
};

}  // namespace threading
}  // namespace asf

#endif  // ASF_THREADING_TASKPOOL_H
