/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     Signal.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_THREADING_SIGNAL_H
#define ASF_THREADING_SIGNAL_H

#include "asf/core/Types.h"

namespace asf {
namespace threading {

class SignalImpl {
public:
    virtual ~SignalImpl() {}

    virtual void lock() const = 0;

    virtual void unlock() const = 0;

    virtual void wait() = 0;

    virtual void notify_one() = 0;

    virtual void notify_all() = 0;
};

class Signal {
public:
    Signal();

    virtual ~Signal();

    void lock() const;

    void unlock() const;

    void wait();

    void notify_one();

    void notify_all();

private:
    Signal(const Signal&);

    Signal& operator=(const Signal&);

    SignalImpl* _poImpl;
};

}  // namespace threading
}  // namespace asf

#endif  // ASF_THREADING_SIGNAL_H
