/*********************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2019
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *********************************************************************/

#ifndef ASF_THREADING_ONCE_H
#define ASF_THREADING_ONCE_H

#include <pthread.h>
#include "asf/core/Types.h"

#define ASF_ONCE_INIT PTHREAD_ONCE_INIT

namespace asf {
namespace threading {

typedef pthread_once_t once_t;

inline void callOnce(once_t& onceFlag, void (*callable)()) { pthread_once(&onceFlag, callable); }

}  // namespace threading
}  // namespace asf

#endif  // ASF_THREADING_ONCE_H
