/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     Mutex.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_THREADING_MUTEX_H
#define ASF_THREADING_MUTEX_H

namespace asf {
namespace threading {

class MutexImpl;

class Mutex {
public:
    Mutex();

    virtual ~Mutex();

    void lock() const;

    void unlock() const;

private:
    Mutex(const Mutex&);

    Mutex& operator=(const Mutex&);

    MutexImpl* _poImpl;
};

class MutexImpl {
public:
    virtual ~MutexImpl() {}

    virtual void lock() const = 0;

    virtual void unlock() const = 0;
};

}  // namespace threading
}  // namespace asf

#endif  // ASF_THREADING_MUTEX_H
