/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     BlobOutputStream.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/

#ifndef ASF_STREAM_BLOBOUTPUTSTREAM_H
#define ASF_STREAM_BLOBOUTPUTSTREAM_H

#include "asf/core/Blob.h"
#include "asf/stream/OutputStreamIF.h"

namespace asf {
namespace stream {

/**
 * A stream which writes data into a memory buffer.
 *
 * TODO: Rename Blob into Buffer
 * TODO: add an option to not grow the buffer (e.g. a buffer is preallocated
 * of a fixed size, no overrun should happen)
 */
class BlobOutputStream : public OutputStreamIF {
public:
    BlobOutputStream(::asf::core::Blob& blob) : _blob(blob) {}

    virtual size_t write(const void* buffer, size_t size) {
        _blob.push_back(buffer, size);
        return size;
    }

private:
    ::asf::core::Blob& _blob;
};
}  // namespace stream
}  // namespace asf

#endif
