/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_DBUS_ORG_FREEDESKTOP_DBUS_PROPERTIESSTUB_H
#define ASF_DBUS_ORG_FREEDESKTOP_DBUS_PROPERTIESSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/org/freedesktop/DBus/Properties.h"
#include "boost/shared_ptr.hpp"
#include <map>
#include <string>
#include <vector>

namespace asf {
namespace dbus {
namespace org {
namespace freedesktop {
namespace DBus {
namespace Properties {

class PropertiesStubDelegate;

class PropertiesStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the PropertiesStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    PropertiesStub (const std::string& portName);

    /**
     * Create an instance of the PropertiesStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    PropertiesStub (const std::string& portName, const std::string& objectPath);

    /**
     * Create an instance of the PropertiesStub without a provided port in the cmc file.
     *
     * Not intended to be used outside of ASF itself
     *
     * @param connector the connector used for offering the service
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    PropertiesStub(::asf::dbus::DBusConnector& connector, const std::string& objectPath);

    virtual ~PropertiesStub();

    // signal 'PropertiesChanged'

    /**
     * Raise the signal 'PropertiesChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PropertiesChanged'</b>:
     *
     * If the meaning of "PropertiesChanged" isn't clear, then there should be a description here.
     */
    void sendPropertiesChangedSignal(const ::std::string& interface_name, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& changed_properties, const ::std::vector< ::std::string >& invalidated_properties);

    // method 'Get'

    /**
     * The method onGet() is called by ASF when a client invokes the method
     * 'Get'. A subclass has to implement this method and send back a response
     * to the client either with the sendGet() or sendGetError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'Get'</b>:
     *
     * If the meaning of "Get" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetRequest (const ::boost::shared_ptr< GetRequest >& request) = 0;

    /**
     * The method sendGetResponse() sends a response of a previous method
     * invocation of 'Get' back to the client.
     *
     * <b>Documentation of 'Get'</b>:
     *
     * If the meaning of "Get" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGet(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetResponse (const ::asf::dbus::DBusVariant& value, act_t act = 0);

    /**
     * The method sendGetError() sends an error response of a previous method
     * invocation of 'Get' back to the client.
     *
     * <b>Documentation of 'Get'</b>:
     *
     * If the meaning of "Get" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGet(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetAll'

    /**
     * The method onGetAll() is called by ASF when a client invokes the method
     * 'GetAll'. A subclass has to implement this method and send back a
     * response to the client either with the sendGetAll() or
     * sendGetAllError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetAll'</b>:
     *
     * If the meaning of "GetAll" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetAllRequest (const ::boost::shared_ptr< GetAllRequest >& request) = 0;

    /**
     * The method sendGetAllResponse() sends a response of a previous method
     * invocation of 'GetAll' back to the client.
     *
     * <b>Documentation of 'GetAll'</b>:
     *
     * If the meaning of "GetAll" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetAll(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetAllResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act = 0);

    /**
     * The method sendGetAllError() sends an error response of a previous
     * method invocation of 'GetAll' back to the client.
     *
     * <b>Documentation of 'GetAll'</b>:
     *
     * If the meaning of "GetAll" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetAll(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetAllError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Set'

    /**
     * The method onSet() is called by ASF when a client invokes the method
     * 'Set'. A subclass has to implement this method and send back a response
     * to the client either with the sendSet() or sendSetError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'Set'</b>:
     *
     * If the meaning of "Set" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetRequest (const ::boost::shared_ptr< SetRequest >& request) = 0;

    /**
     * The method sendSetResponse() sends a response of a previous method
     * invocation of 'Set' back to the client.
     *
     * <b>Documentation of 'Set'</b>:
     *
     * If the meaning of "Set" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSet(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetResponse (act_t act = 0);

    /**
     * The method sendSetError() sends an error response of a previous method
     * invocation of 'Set' back to the client.
     *
     * <b>Documentation of 'Set'</b>:
     *
     * If the meaning of "Set" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSet(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class PropertiesStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Properties
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace dbus
} // namespace asf

#endif // ASF_DBUS_ORG_FREEDESKTOP_DBUS_PROPERTIESSTUB_H
