/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusProxy.h
 *\brief
 *
 *\author   CM-AI/PJ-G31
 *          stefan.baron3@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_DBUS_DBUSPROXY_H
#define ASF_DBUS_DBUSPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"

#include <dbus/dbus.h>

class DBusProxyTest;
class DBusProxyRegistryTest;
class DBusMessageFactoryTest;

namespace asf {
namespace dbus {

class DBusProxyDelegate;
class DBusDaemonProxy;
class DBusPropertiesProxyWrapper;

/**
 * The DBusProxy class is the base class for representing DBus services
 */
class DBusProxy : public ::asf::core::Proxy {
public:
    const std::string& getDBusBusName() const;

    const std::string& getDBusObjectPath() const;

    const std::string& getInterfaceName() const;

    /**
     * Get the D-Bus connector options
     *
     * @return The D-Bus connector options defined in the application manifest
     */
    const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& getConnectorOptions() const;

    /**
     * Get the D-Bus bus type
     *
     * @deprecated use getConnectorOptions() instead
     *
     * @return The D-Bus bus type, system or session bus
     */
    ::DBusBusType getBusType() const;

protected:
    void createHelperProxies(bool hasProperties = true);

    DBusProxy(const std::string& portName,
              const std::string& interfaceName,
              const ::asf::core::ServiceAvailableIF& serviceAvailable,
              const ::asf::core::Logger& logger);

    virtual ~DBusProxy();

    ::boost::shared_ptr< ::asf::dbus::DBusProxyDelegate > _dbusProxyDelegate;

    ::boost::shared_ptr< ::asf::dbus::DBusDaemonProxy > _dbusDaemonProxy;

    ::asf::dbus::DBusPropertiesProxyWrapper* _dbusPropertiesProxyWrapper;

private:
    DBusProxy(const DBusProxy&);

    DBusProxy& operator=(const DBusProxy&);

    ::asf::core::Logger& _logger;

    friend class ::DBusProxyTest;
    friend class ::DBusProxyRegistryTest;
    friend class ::DBusMessageFactoryTest;
};
}  // namespace dbus
}  // namespace asf

#endif
