/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusMessageFactory.h
 *\brief
 *
 *\author   CM-AI/PJ-G31
 *          stefan.baron3@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_DBUS_DBUSMESSAGEFACTORY_H
#define ASF_DBUS_DBUSMESSAGEFACTORY_H

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/ServiceMessage.h"
#include "asf/core/Types.h"

#include "asf/dbus/DBusSerialRegistry.h"

namespace asf {
namespace dbus {

class DBusProxyRegistry;
class DBusUniqueIdRegistry;
class DBusProxyDelegate;
class DBusStubRegistry;

/**
 * The DBusMessagFactory creates DBusMessage objects out of the data
 * typically received by DBus daemon.
 */
class DBusMessageFactory : public ::asf::core::ComponentMessageAdapter {
public:
    DBusMessageFactory(const ::boost::shared_ptr< DBusSerialRegistry >& serialRegistry,
                       DBusProxyRegistry& proxyRegistry,
                       DBusStubRegistry& stubRegistry,
                       const std::string& busName);

    virtual ::asf::core::ServiceMessage* createServiceMessage(
        const ::boost::shared_ptr< ::asf::core::Blob >& blobMessage,
        ::asf::core::CommunicationStack* comStack,
        ::asf::core::ConnectionIFSharedPtr connection);

    virtual ::asf::core::ConnectionMessage* createConnectionMessage(
        ::asf::core::ConnectionIFSharedPtr, bool, bool);

private:
    ::asf::core::MessageSharedPtr createSharedDBusSignal(
        const ::boost::shared_ptr< DBusProxyDelegate >& proxyDelegate,
        ::DBusMessage* dbusMessage) const;

    void sendSharedDBusSignal(
        ::boost::shared_ptr< std::vector< ::boost::shared_ptr< DBusProxyDelegate > > > proxyList,
        ::DBusMessage* dbusMessage) const;

    template < class T >
    DBusMessage* createASFDBusMessage(T t,
                                      ::DBusMessage* dbusMessage,
                                      ::asf::core::CommunicationStack* comStack,
                                      ::asf::core::ConnectionIFSharedPtr connection,
                                      DBusSerialRegistry::DBusAsyncObject& asyncReplyObject);

    DBusProxyRegistry& _proxyRegistry;

    ::boost::shared_ptr< DBusSerialRegistry > _serialRegistry;

    DBusUniqueIdRegistry& _uniqueIdRegistry;

    DBusStubRegistry& _stubRegistry;

    const std::string _busName;

    DECLARE_CLASS_LOGGER();
};
}  // namespace dbus
}  // namespace asf

#endif
