/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusImports.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_DBUS_DBUSIMPORTS_H
#define ASF_DBUS_DBUSIMPORTS_H

#include "asf/core/Types.h"
#include "asf/dbus/DBusImportedPort.h"

#include <list>

namespace asf {
namespace dbus {

class DBusImports {
public:
    DBusImports() {}

    virtual ~DBusImports() {}

    DBusImportedPort& addImport(
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& options);

private:
    std::list< DBusImportedPort > _imports;
};

}  // namespace dbus
}  // namespace asf

#endif  // ASF_DBUS_DBUSIMPORTS_H
