/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusImportedPort.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_DBUS_DBUSIMPORTEDPORT_H
#define ASF_DBUS_DBUSIMPORTEDPORT_H

#include "asf/core/ImportedPort.h"
#include "asf/core/Types.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"

#include <dbus/dbus.h>
#include <string>

namespace asf {
namespace dbus {

class DBusImportedPort : public ::asf::core::ImportedPort {
public:
    DBusImportedPort(const std::string& busName,
                     const std::string& objectPath,
                     const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& options)
        : ImportedPort("", ""),
          _busName(busName),
          _objectPath(objectPath),
          _connectorOptions(options) {}

    virtual ~DBusImportedPort() {}

    const std::string& getBusName() const { return _busName; }

    const std::string& getObjectPath() const { return _objectPath; }

    const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& getConnectorOptions()
        const {
        return _connectorOptions;
    }

private:
    std::string _busName;

    std::string _objectPath;

    const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector _connectorOptions;
};

}  // namespace dbus
}  // namespace asf

#endif  // ASF_DBUS_DBUSIMPORTEDPORT_H
