/*********************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2019
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *********************************************************************/

#ifndef DBUS_ERROR_H_
#define DBUS_ERROR_H_

#include <dbus/dbus.h>
#include <string>
#include "asf/core/Logger.h"

namespace asf {
namespace dbus {

class DBusConnection;
class DBusUtils;

class DBusError {
public:
    DBusError();

    ~DBusError();

    operator bool() const;

    void clear();

    std::string getName() const;

    std::string getMessage() const;

private:
    ::DBusError _dbusError;

    DECLARE_CLASS_LOGGER();

    friend class DBusConnection;
    friend class DBusUtils;
};

}  // namespace dbus
}  // namespace asf

#endif  // DBUS_ERROR_H_
