/*********************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2019
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *********************************************************************/

#ifndef ASF_CORE_VERSIONCHECK_H
#define ASF_CORE_VERSIONCHECK_H

#include "asf/core/Types.h"

#if defined(_MSC_VER) || defined(ANDROID) || defined(__INTEGRITY)
#define ASF_VERSION_CHECK_PRIORITY(FUNC_RETURN, FUNC_NAME) FUNC_RETURN FUNC_NAME()
#else
#define ASF_VERSION_CHECK_PRIORITY(FUNC_RETURN, FUNC_NAME) \
    __attribute__((__constructor__(101))) FUNC_RETURN FUNC_NAME()
#endif

#define ASF_CORE_VERSION_CHECK(MAJOR, MINOR, PATCH, QUALIFIER, LIBNAME)         \
    ASF_VERSION_CHECK_PRIORITY(void, coreVersionCheckInit) {                    \
        ::asf::core::coreVersionCheck(MAJOR, MINOR, PATCH, QUALIFIER, LIBNAME); \
    }

#define ASF_GENERATOR_VERSION_CHECK(MAJOR, MINOR, PATCH, QUALIFIER, LIBNAME)         \
    ASF_VERSION_CHECK_PRIORITY(void, generatorVersionCheckInit) {                    \
        ::asf::core::generatorVersionCheck(MAJOR, MINOR, PATCH, QUALIFIER, LIBNAME); \
    }

/**
 * This define is used in the generated type files to ensure that the generator version check won't
 * be optimized out by the linker.
 */
#if defined(_MSC_VER) || defined(ANDROID)
#define ASF_GENERATOR_VERSION_CHECK_DECLARE
#else
#define ASF_GENERATOR_VERSION_CHECK_DECLARE                                      \
    void generatorVersionCheckInit();                                            \
    static void (*fpGeneratorVersionCheckInit)(void) __attribute__((__used__)) = \
        &generatorVersionCheckInit;
#endif

namespace asf {
namespace core {

extern "C" {

void coreVersionCheck(
    uint32 major, uint32 minor, uint32 patch, const char* qualifier, const char* name);

void generatorVersionCheck(
    uint32 major, uint32 minor, uint32 patch, const char* qualifier, const char* name);
}
}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_VERSIONCHECK_H
