/****************************************************************************
 * Automotive Service Framework (ASF)
 *
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2014
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     Utf8String.h
 *\brief    Utf8 helper functions
 *
 *\author   CM-AI/ECA2
 *          christoph.perick@de.bosch.com
 ***************************************************************************/
#ifndef UTF8STRING_H
#define UTF8STRING_H

#include "asf/core/Types.h"

#include <cstring>
#include <string>

namespace asf {
namespace core {

class Utf8String {
public:
    static bool isValid(const unsigned char* str, size_t length);

    inline static bool isValid(const char* str, size_t length) {
        return isValid((const unsigned char*)str, length);
    }

    inline static bool isValid(const char* str) {
        return isValid((const unsigned char*)str, strlen(str));
    }

    inline static bool isValid(const std::string& str) {
        return isValid((const unsigned char*)str.c_str(), str.length());
    }

    inline static bool isValidAndLog(const char* str) { return isValidAndLog(str, strlen(str)); }

    inline static bool isValidAndLog(const std::string& str) {
        return isValidAndLog(str.c_str(), str.length());
    }

    static bool isValidAndLog(const std::string* str);

    static bool isValidAndLog(const char* str, size_t length);
};

}  // namespace core
}  // namespace asf

#endif
