/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2016
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     Types.h
 *\brief    Type definitions of integer types
 *
 *\author   CM-AI/ESA2
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2016 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/

#ifndef ASF_TYPES_H
#define ASF_TYPES_H

#include "Warnings.h"

#include <stdint.h>

// make size_t available
#include <stdlib.h>

// for UINT_MAX, see below
#include <climits>

// make ssize_t available
#ifdef _MSC_VER
#include <BaseTsd.h>
typedef SSIZE_T ssize_t;
#endif

typedef int8_t int8;
typedef int16_t int16;
typedef int32_t int32;
typedef int64_t int64;

typedef uint8_t uint8;
typedef uint16_t uint16;
typedef uint32_t uint32;
typedef uint64_t uint64;

// asynchronous completion token
typedef uintptr_t act_t;

namespace asf {

// milli-seconds
typedef unsigned int ms_t;

static const ms_t MS_T_MAX = UINT_MAX;

// message id
// see doc/DD_Definition_MessageId.md for more information
typedef uint64 msgId_t;

// ASF doesn't use the id_t type for internal identifier, because the id_t type can differ between
// platforms. On linux id_t is defined as an unsigned int whereas for QNX it is a signed integer.
typedef uint32 identifier_t;

static const identifier_t IDENTIFIER_T_MAX = UINT32_MAX;

}  // namespace asf

#endif
