/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012-2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ThreadConfiguration.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_BASE_THREAD_CONFIGURATION_HPP
#define ASF_BASE_THREAD_CONFIGURATION_HPP

#include "asf/core/Types.h"

namespace asf {
namespace core {

/**
 * A ThreadConfiguration represents the thread/thread pool
 * configuration data which can be specified in the application
 * model
 */
class ThreadConfiguration {
public:
    ThreadConfiguration(size_t threadCount) : _threadCount(threadCount) {}

    ThreadConfiguration(const ThreadConfiguration& tc) : _threadCount(tc._threadCount) {}

    size_t getThreadCount() const { return _threadCount; }

private:
    size_t _threadCount;

    // TODO: add more fields like stack size and priority
};

}  // namespace core
}  // namespace asf

#endif
