/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     Stub.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

// !!!!!!!! When changing this file please update the ASF User Guide !!!!!!!!!!!

#ifndef ASF_CORE_STUB_H
#define ASF_CORE_STUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"

#include <cassert>
#include <string>

namespace asf {
namespace core {

/**
 * Base class of all generated stubs. The stub is the server side
 * representation of a service and intended for subclassing.
 */
class Stub {
public:
    Stub(const std::string& portName) : _portName(portName) {}

    virtual ~Stub() {}

    /**
     * The port name as defined in the component manifest (.cmc file).
     */
    const std::string& getPortName() const { return _portName; }

private:
    std::string _portName;

    DECLARE_CLASS_LOGGER();
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_STUB_H
