/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ServiceMessage.cpp
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_SERVICEMESSAGE_H
#define ASF_CORE_SERVICEMESSAGE_H

#include "asf/core/ComponentMessage.h"
#include "asf/core/IncomingOutgoingIF.h"
#include "asf/core/Types.h"
#include "asf/threading/Thread.h"

namespace asf {
namespace core {

class CommunicationStack;

class ServiceMessage : public ComponentMessage {
public:
    ServiceMessage() : _stack(0) {}

    ServiceMessage(CommunicationStack* stack, ConnectionIFSharedPtr remote)
        : _stack(stack), _remote(remote) {}

    virtual ~ServiceMessage() { _stack = 0; }

    void setCommunicationStack(CommunicationStack* stack) { _stack = stack; }

    CommunicationStack* getCommunicationStack() const { return _stack; }

    void setRemoteConnection(ConnectionIFSharedPtr remote) { _remote = remote; }

    ConnectionIFSharedPtr getRemoteConnection() const { return _remote; }

    virtual bool isRemote() const { return (_remote && _stack != 0); }

    virtual const ::std::string& getServiceId() const { return _noname; }

protected:
    CommunicationStack* _stack;
    ConnectionIFSharedPtr _remote;

private:
    static std::string _noname;
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_SERVICEMESSAGE_H
