/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     Payload.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_PAYLOAD_H
#define ASF_CORE_PAYLOAD_H

#include <boost/shared_ptr.hpp>
#include "asf/core/Logger.h"
#include "asf/core/Types.h"

namespace asf {
namespace core {

/**
 * Payload is the base class for all data structure representing the payload of
 * a message. A payload has a member act (asynchronous completion token) which
 * identifies the message pair, e.g. a request response pair.
 */
class Payload {
public:
    Payload() : _act(0) {}

    virtual ~Payload() {}

    virtual Payload* clone() {
        Payload* rv = new Payload();
        CHECK_ALLOCATION(rv);
        rv->setAct(getAct());
        return rv;
    }

    void setAct(act_t act) { _act = act; }

    act_t getAct() const { return _act; }

    Payload& operator=(const Payload& rhs) {
        if (this != &rhs) {
            _act = rhs._act;
        }
        return *this;
    }

private:
    act_t _act;
};

typedef ::boost::shared_ptr< ::asf::core::Payload > PayloadSharedPtr;

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_PAYLOAD_H
