/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     Message.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_CORE_MESSAGE_H
#define ASF_CORE_MESSAGE_H

#include <boost/shared_ptr.hpp>
#include "asf/core/Time.h"
#include "asf/core/Types.h"
#include "asf/threading/AtomicCounter.h"

namespace asf {
namespace core {

class Message;

typedef ::boost::shared_ptr< Message > MessageSharedPtr;

class Message {
public:
    Message() : _msgId(Message::createUniqueMsgId()), _timestamp(Time::getElapsedTimeMs()) {}

    virtual ~Message() {}

    /**
     * Each Message object provides an unique id which is used e.g. in the logging output to
     * identify messages. To guarantee an unique id the message id is realized using a atomic
     * counter and is incremented on each instantiation of a message.
     */
    msgId_t getMessageId() const { return _msgId; }

    ms_t getTimeStamp() const { return _timestamp; }

    virtual void process() = 0;

    static msgId_t createUniqueMsgId();

    static MessageSharedPtr getCurrentMessage();

private:
    msgId_t _msgId;

    ms_t _timestamp;

    static ::asf::threading::AtomicCounter< msgId_t > _uniqueMsgId;
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_MESSAGE_H
