/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2015
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     LoggingBackendExtern.h
 *\brief
 *
 *\author   CM-AI/ESA2
 *          christoph.perick@de.bosch.com
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2015 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_LOGGINBACKENDEXTERN_H
#define ASF_CORE_LOGGINBACKENDEXTERN_H

#include "asf/core/LoggingBackendIF.h"
#include "asf/core/Types.h"

/**
 * Invoked by ASF to create the logging backend. The returned instance will be used
 * to perform logging.
 */
extern "C" ::asf::core::LoggingBackendIF* createLoggingBackend(void);

/**
 * Invoked by ASF to destroy the logging backend. Called at the end of the application
 * life cycle.
 */
extern "C" void destroyLoggingBackend(::asf::core::LoggingBackendIF* lb);

/**
 * Invoked by ASF to perform a version check. The backend will only be used when the returned
 * major version equals the LoggingBackendIF::API_MAJOR_VERSION. Otherwise the logging backend
 * is treated as incompatible.
 */
extern "C" void getLoggingBackendVersion(uint32& major, uint32& minor, uint32& patch);

#endif
