#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_CORE_LOGGING_H
#define ASF_CORE_LOGGING_H

#include "asf/core/LoggingConst.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>

/**
 * The Logging service is used to configure the log levels of an ASF
 * application. Furthermore it can be used to read log messages from
 * the running application.
 *
 * Initial contribution - Christoph Kulla, christoph.kulla@de.bosch.com
 */

namespace asf {
namespace core {
namespace Logging {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class LoggerConfiguration;


/**
 * If the meaning of "LoggerConfiguration" isn't clear, then there should be a description here.
 */
class LoggerConfiguration {
public:

    /**
     * Default constructor
     */
    inline  LoggerConfiguration ();

    /**
     * Copy constructor
     */
    inline  LoggerConfiguration (const LoggerConfiguration &rhs);

    /**
     * All fields constructor
     */
    inline  LoggerConfiguration (const ::std::map< ::std::string, Level >& loggerLevel_, const ::std::string& backend_, const ::std::string& backendLibraryPath_, const ::std::map< ::std::string, ::std::string >& backendConfiguration_, bool disableColoring_, bool outputErrorOnStderr_, const ::std::string& logFile_, bool appendToLogFile_);

    /**
     * Destructor
     */
    inline  ~LoggerConfiguration();

    /**
     * Assignment operator
     */
    inline LoggerConfiguration& operator = (const LoggerConfiguration& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoggerConfiguration& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoggerConfiguration& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoggerConfiguration& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoggerConfiguration& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "loggerLevel"

    static const int kLoggerLevel = 0;

    /**
     * Clears the field "loggerLevel".
     *
     * The field will be set to its default value. The hasLoggerLevel()
     * method will return false.
     */
    inline void clearLoggerLevel();

    /**
     * Checks whether the field "loggerLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoggerLevel()). Otherwise it will return false.
     */
    inline bool hasLoggerLevel () const;

    /**
     * Returns the value of the member "loggerLevel".
     *
     * Configuration of the log levels. Logger names are mapped to the desired log level.
     *
     * The logger name is interpreted as an exact match when no star, '*', at the end
     * is given. If a star is given at the end it matches all loggers starting with the
     * given name.
     *
     * Example:
     *
     *    "loggerLevel" : {
     *        "*" : "Info"
     *        "/example/echo/EchoService*" : "Debug"
     *    }
     *
     * @return The value of the field "loggerLevel"
     */
    inline const ::std::map< ::std::string, Level >& getLoggerLevel () const;

    /**
     * Retrieves the value of the field "loggerLevel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "loggerLevel".
     */
    inline ::std::map< ::std::string, Level >& getLoggerLevelMutable ();

    /**
     * Sets the value of the member "loggerLevel".
     *
     * Configuration of the log levels. Logger names are mapped to the desired log level.
     *
     * The logger name is interpreted as an exact match when no star, '*', at the end
     * is given. If a star is given at the end it matches all loggers starting with the
     * given name.
     *
     * Example:
     *
     *    "loggerLevel" : {
     *        "*" : "Info"
     *        "/example/echo/EchoService*" : "Debug"
     *    }
     *
     * @param loggerLevel The value which will be set
     */
    inline void setLoggerLevel (const ::std::map< ::std::string, Level >& loggerLevel_);

    // API of field "backend"

    static const int kBackend = 1;

    /**
     * Clears the field "backend".
     *
     * The field will be set to its default value. The hasBackend()
     * method will return false.
     */
    inline void clearBackend();

    /**
     * Checks whether the field "backend" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBackend()). Otherwise it will return false.
     */
    inline bool hasBackend () const;

    /**
     * Returns the value of the member "backend".
     *
     * Configuration of the backend. The system tries to load on runtime a external logging
     * backend by name.
     *
     * If the backend name "examplebackend" is given, ASF tries to load the shared library
     * "libexamplebackend.so.1".
     *
     * If the system runs on windows, it tries to load the dynamic link library
     * "examplebackend.dll"
     *
     * @return The value of the field "backend"
     */
    inline const ::std::string& getBackend () const;

    /**
     * Retrieves the value of the field "backend" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "backend".
     */
    inline ::std::string& getBackendMutable ();

    /**
     * Sets the value of the member "backend".
     *
     * Configuration of the backend. The system tries to load on runtime a external logging
     * backend by name.
     *
     * If the backend name "examplebackend" is given, ASF tries to load the shared library
     * "libexamplebackend.so.1".
     *
     * If the system runs on windows, it tries to load the dynamic link library
     * "examplebackend.dll"
     *
     * @param backend The value which will be set
     */
    inline void setBackend (const ::std::string& backend_);

    /**
     * Sets the value of the member "backend".
     *
     * Configuration of the backend. The system tries to load on runtime a external logging
     * backend by name.
     *
     * If the backend name "examplebackend" is given, ASF tries to load the shared library
     * "libexamplebackend.so.1".
     *
     * If the system runs on windows, it tries to load the dynamic link library
     * "examplebackend.dll"
     *
     * @param backend The value which will be set
     */
    inline void setBackend (const char* backend_);

    /**
     * Sets the value of the member "backend".
     *
     * Configuration of the backend. The system tries to load on runtime a external logging
     * backend by name.
     *
     * If the backend name "examplebackend" is given, ASF tries to load the shared library
     * "libexamplebackend.so.1".
     *
     * If the system runs on windows, it tries to load the dynamic link library
     * "examplebackend.dll"
     *
     * @param backend The value which will be set
     */
    inline void setBackend (const char* value, size_t size);

    // API of field "backendLibraryPath"

    static const int kBackendLibraryPath = 2;

    /**
     * Clears the field "backendLibraryPath".
     *
     * The field will be set to its default value. The hasBackendLibraryPath()
     * method will return false.
     */
    inline void clearBackendLibraryPath();

    /**
     * Checks whether the field "backendLibraryPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBackendLibraryPath()). Otherwise it will return false.
     */
    inline bool hasBackendLibraryPath () const;

    /**
     * Returns the value of the member "backendLibraryPath".
     *
     * Path to the library specified in backend (requires a trailing slash).
     *
     * The parameter is optional. If present the backend library will be looked up in the
     * specified path. If not present the system's library search strategy will be used to
     * find the library.
     *
     * @return The value of the field "backendLibraryPath"
     */
    inline const ::std::string& getBackendLibraryPath () const;

    /**
     * Retrieves the value of the field "backendLibraryPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "backendLibraryPath".
     */
    inline ::std::string& getBackendLibraryPathMutable ();

    /**
     * Sets the value of the member "backendLibraryPath".
     *
     * Path to the library specified in backend (requires a trailing slash).
     *
     * The parameter is optional. If present the backend library will be looked up in the
     * specified path. If not present the system's library search strategy will be used to
     * find the library.
     *
     * @param backendLibraryPath The value which will be set
     */
    inline void setBackendLibraryPath (const ::std::string& backendLibraryPath_);

    /**
     * Sets the value of the member "backendLibraryPath".
     *
     * Path to the library specified in backend (requires a trailing slash).
     *
     * The parameter is optional. If present the backend library will be looked up in the
     * specified path. If not present the system's library search strategy will be used to
     * find the library.
     *
     * @param backendLibraryPath The value which will be set
     */
    inline void setBackendLibraryPath (const char* backendLibraryPath_);

    /**
     * Sets the value of the member "backendLibraryPath".
     *
     * Path to the library specified in backend (requires a trailing slash).
     *
     * The parameter is optional. If present the backend library will be looked up in the
     * specified path. If not present the system's library search strategy will be used to
     * find the library.
     *
     * @param backendLibraryPath The value which will be set
     */
    inline void setBackendLibraryPath (const char* value, size_t size);

    // API of field "backendConfiguration"

    static const int kBackendConfiguration = 3;

    /**
     * Clears the field "backendConfiguration".
     *
     * The field will be set to its default value. The hasBackendConfiguration()
     * method will return false.
     */
    inline void clearBackendConfiguration();

    /**
     * Checks whether the field "backendConfiguration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBackendConfiguration()). Otherwise it will return false.
     */
    inline bool hasBackendConfiguration () const;

    /**
     * Returns the value of the member "backendConfiguration".
     *
     * This map holds backend specific configuration data. This configuration
     * data is forwarded to the backend implementation via the LoggingBackendIF::init() method
     *
     * Example for FileHandleLoggingBackend:
     *
     *    "backendConfiguration" : {
     *        "disableColoring" : "true"
     *        "outputErrorOnStderr" : "false"
     *        "appendToLogFile" : "true"
     *        "logFile" : "mylogging.txt"
     *    }
     *
     * @return The value of the field "backendConfiguration"
     */
    inline const ::std::map< ::std::string, ::std::string >& getBackendConfiguration () const;

    /**
     * Retrieves the value of the field "backendConfiguration" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "backendConfiguration".
     */
    inline ::std::map< ::std::string, ::std::string >& getBackendConfigurationMutable ();

    /**
     * Sets the value of the member "backendConfiguration".
     *
     * This map holds backend specific configuration data. This configuration
     * data is forwarded to the backend implementation via the LoggingBackendIF::init() method
     *
     * Example for FileHandleLoggingBackend:
     *
     *    "backendConfiguration" : {
     *        "disableColoring" : "true"
     *        "outputErrorOnStderr" : "false"
     *        "appendToLogFile" : "true"
     *        "logFile" : "mylogging.txt"
     *    }
     *
     * @param backendConfiguration The value which will be set
     */
    inline void setBackendConfiguration (const ::std::map< ::std::string, ::std::string >& backendConfiguration_);

    // API of field "disableColoring"

    static const int kDisableColoring = 4;

    /**
     * Clears the field "disableColoring".
     *
     * The field will be set to its default value. The hasDisableColoring()
     * method will return false.
     */
    inline void clearDisableColoring();

    /**
     * Checks whether the field "disableColoring" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisableColoring()). Otherwise it will return false.
     */
    inline bool hasDisableColoring () const;

    /**
     * Returns the value of the member "disableColoring".
     *
     * Disable coloring of log output (suppress escape sequences).
     *
     * DisableColoring will be set to true by default if a logFile is given.
     *
     * @return The value of the field "disableColoring"
     */
    inline bool getDisableColoring () const;

    /**
     * Sets the value of the member "disableColoring".
     *
     * Disable coloring of log output (suppress escape sequences).
     *
     * DisableColoring will be set to true by default if a logFile is given.
     *
     * @param disableColoring The value which will be set
     */
    inline void setDisableColoring (bool disableColoring_);

    // API of field "outputErrorOnStderr"

    static const int kOutputErrorOnStderr = 5;

    /**
     * Clears the field "outputErrorOnStderr".
     *
     * The field will be set to its default value. The hasOutputErrorOnStderr()
     * method will return false.
     */
    inline void clearOutputErrorOnStderr();

    /**
     * Checks whether the field "outputErrorOnStderr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutputErrorOnStderr()). Otherwise it will return false.
     */
    inline bool hasOutputErrorOnStderr () const;

    /**
     * Returns the value of the member "outputErrorOnStderr".
     *
     * Prints error and fatal messages on stderr. Useful for death tests
     * with google test which parse the output on stderr.
     *
     * This is set to true in the LoggerEnvironment class (asfgtest).
     *
     * @return The value of the field "outputErrorOnStderr"
     */
    inline bool getOutputErrorOnStderr () const;

    /**
     * Sets the value of the member "outputErrorOnStderr".
     *
     * Prints error and fatal messages on stderr. Useful for death tests
     * with google test which parse the output on stderr.
     *
     * This is set to true in the LoggerEnvironment class (asfgtest).
     *
     * @param outputErrorOnStderr The value which will be set
     */
    inline void setOutputErrorOnStderr (bool outputErrorOnStderr_);

    // API of field "logFile"

    static const int kLogFile = 6;

    /**
     * Clears the field "logFile".
     *
     * The field will be set to its default value. The hasLogFile()
     * method will return false.
     */
    inline void clearLogFile();

    /**
     * Checks whether the field "logFile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLogFile()). Otherwise it will return false.
     */
    inline bool hasLogFile () const;

    /**
     * Returns the value of the member "logFile".
     *
     * The name of the log file to write the logging output to.
     * If logFile is not given the output will be written to stdout and stderr.
     *
     * @return The value of the field "logFile"
     */
    inline const ::std::string& getLogFile () const;

    /**
     * Retrieves the value of the field "logFile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "logFile".
     */
    inline ::std::string& getLogFileMutable ();

    /**
     * Sets the value of the member "logFile".
     *
     * The name of the log file to write the logging output to.
     * If logFile is not given the output will be written to stdout and stderr.
     *
     * @param logFile The value which will be set
     */
    inline void setLogFile (const ::std::string& logFile_);

    /**
     * Sets the value of the member "logFile".
     *
     * The name of the log file to write the logging output to.
     * If logFile is not given the output will be written to stdout and stderr.
     *
     * @param logFile The value which will be set
     */
    inline void setLogFile (const char* logFile_);

    /**
     * Sets the value of the member "logFile".
     *
     * The name of the log file to write the logging output to.
     * If logFile is not given the output will be written to stdout and stderr.
     *
     * @param logFile The value which will be set
     */
    inline void setLogFile (const char* value, size_t size);

    // API of field "appendToLogFile"

    static const int kAppendToLogFile = 7;

    /**
     * Clears the field "appendToLogFile".
     *
     * The field will be set to its default value. The hasAppendToLogFile()
     * method will return false.
     */
    inline void clearAppendToLogFile();

    /**
     * Checks whether the field "appendToLogFile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppendToLogFile()). Otherwise it will return false.
     */
    inline bool hasAppendToLogFile () const;

    /**
     * Returns the value of the member "appendToLogFile".
     *
     * Append output to the logFile rather then to overwrite it.
     *
     * @return The value of the field "appendToLogFile"
     */
    inline bool getAppendToLogFile () const;

    /**
     * Sets the value of the member "appendToLogFile".
     *
     * Append output to the logFile rather then to overwrite it.
     *
     * @param appendToLogFile The value which will be set
     */
    inline void setAppendToLogFile (bool appendToLogFile_);

    static const LoggerConfiguration &getDefaultInstance();

private:

    static const ::std::map< ::std::string, Level >& getStringToLevelMap_DefaultInstance ();

    static const ::std::map< ::std::string, ::std::string >& getStringToStringMap_DefaultInstance ();

    inline void set_has_loggerLevel ();

    inline void clear_has_loggerLevel ();

    inline void set_has_backend ();

    inline void clear_has_backend ();

    inline void set_has_backendLibraryPath ();

    inline void clear_has_backendLibraryPath ();

    inline void set_has_backendConfiguration ();

    inline void clear_has_backendConfiguration ();

    inline void set_has_disableColoring ();

    inline void clear_has_disableColoring ();

    inline void set_has_outputErrorOnStderr ();

    inline void clear_has_outputErrorOnStderr ();

    inline void set_has_logFile ();

    inline void clear_has_logFile ();

    inline void set_has_appendToLogFile ();

    inline void clear_has_appendToLogFile ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::std::map< ::std::string, Level > _loggerLevel;

    ::std::string _backend;

    ::std::string _backendLibraryPath;

    ::std::map< ::std::string, ::std::string > _backendConfiguration;

    bool _disableColoring;

    bool _outputErrorOnStderr;

    ::std::string _logFile;

    bool _appendToLogFile;

};

inline  LoggerConfiguration::LoggerConfiguration ()  :
    _loggerLevel (),
    _backend ("asflogging"),
    _backendLibraryPath (),
    _backendConfiguration (),
    _disableColoring (false),
    _outputErrorOnStderr (false),
    _logFile (),
    _appendToLogFile (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LoggerConfiguration::LoggerConfiguration (const LoggerConfiguration &rhs)  :
    _loggerLevel (),
    _backend ("asflogging"),
    _backendLibraryPath (),
    _backendConfiguration (),
    _disableColoring (false),
    _outputErrorOnStderr (false),
    _logFile (),
    _appendToLogFile (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LoggerConfiguration::LoggerConfiguration (const ::std::map< ::std::string, Level >& loggerLevel_, const ::std::string& backend_, const ::std::string& backendLibraryPath_, const ::std::map< ::std::string, ::std::string >& backendConfiguration_, bool disableColoring_, bool outputErrorOnStderr_, const ::std::string& logFile_, bool appendToLogFile_)  :
    _loggerLevel (loggerLevel_),
    _backend (backend_),
    _backendLibraryPath (backendLibraryPath_),
    _backendConfiguration (backendConfiguration_),
    _disableColoring (disableColoring_),
    _outputErrorOnStderr (outputErrorOnStderr_),
    _logFile (logFile_),
    _appendToLogFile (appendToLogFile_)
{
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (backend_)) abort();
        #endif
    }
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (backendLibraryPath_)) abort();
        #endif
    }
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (logFile_)) abort();
        #endif
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LoggerConfiguration::~LoggerConfiguration() {
}

inline LoggerConfiguration& LoggerConfiguration::operator = (const LoggerConfiguration& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLoggerLevel()) {
            setLoggerLevel(rhs.getLoggerLevel());
        } else {
            clearLoggerLevel();
        }
        if (rhs.hasBackend()) {
            setBackend(rhs.getBackend());
        } else {
            clearBackend();
        }
        if (rhs.hasBackendLibraryPath()) {
            setBackendLibraryPath(rhs.getBackendLibraryPath());
        } else {
            clearBackendLibraryPath();
        }
        if (rhs.hasBackendConfiguration()) {
            setBackendConfiguration(rhs.getBackendConfiguration());
        } else {
            clearBackendConfiguration();
        }
        if (rhs.hasDisableColoring()) {
            setDisableColoring(rhs.getDisableColoring());
        } else {
            clearDisableColoring();
        }
        if (rhs.hasOutputErrorOnStderr()) {
            setOutputErrorOnStderr(rhs.getOutputErrorOnStderr());
        } else {
            clearOutputErrorOnStderr();
        }
        if (rhs.hasLogFile()) {
            setLogFile(rhs.getLogFile());
        } else {
            clearLogFile();
        }
        if (rhs.hasAppendToLogFile()) {
            setAppendToLogFile(rhs.getAppendToLogFile());
        } else {
            clearAppendToLogFile();
        }
    }
    return *this;
}

inline bool LoggerConfiguration::operator == (const LoggerConfiguration& rhs) const {
    return (((!hasLoggerLevel() && !rhs.hasLoggerLevel()) || getLoggerLevel() == rhs.getLoggerLevel()) &&
        ((!hasBackend() && !rhs.hasBackend()) || getBackend() == rhs.getBackend()) &&
        ((!hasBackendLibraryPath() && !rhs.hasBackendLibraryPath()) || getBackendLibraryPath() == rhs.getBackendLibraryPath()) &&
        ((!hasBackendConfiguration() && !rhs.hasBackendConfiguration()) || getBackendConfiguration() == rhs.getBackendConfiguration()) &&
        ((!hasDisableColoring() && !rhs.hasDisableColoring()) || getDisableColoring() == rhs.getDisableColoring()) &&
        ((!hasOutputErrorOnStderr() && !rhs.hasOutputErrorOnStderr()) || getOutputErrorOnStderr() == rhs.getOutputErrorOnStderr()) &&
        ((!hasLogFile() && !rhs.hasLogFile()) || getLogFile() == rhs.getLogFile()) &&
        ((!hasAppendToLogFile() && !rhs.hasAppendToLogFile()) || getAppendToLogFile() == rhs.getAppendToLogFile()));
}

inline bool LoggerConfiguration::operator != (const LoggerConfiguration& rhs) const {
    return ! (*this == rhs);
}

inline bool LoggerConfiguration::operator < (const LoggerConfiguration& rhs) const {
    if (hasLoggerLevel() || rhs.hasLoggerLevel()) {
        if (getLoggerLevel() < rhs.getLoggerLevel()) return true;
        if (getLoggerLevel() > rhs.getLoggerLevel()) return false;
    }
    if (hasBackend() || rhs.hasBackend()) {
        if (getBackend() < rhs.getBackend()) return true;
        if (getBackend() > rhs.getBackend()) return false;
    }
    if (hasBackendLibraryPath() || rhs.hasBackendLibraryPath()) {
        if (getBackendLibraryPath() < rhs.getBackendLibraryPath()) return true;
        if (getBackendLibraryPath() > rhs.getBackendLibraryPath()) return false;
    }
    if (hasBackendConfiguration() || rhs.hasBackendConfiguration()) {
        if (getBackendConfiguration() < rhs.getBackendConfiguration()) return true;
        if (getBackendConfiguration() > rhs.getBackendConfiguration()) return false;
    }
    if (hasDisableColoring() || rhs.hasDisableColoring()) {
        if (getDisableColoring() < rhs.getDisableColoring()) return true;
        if (getDisableColoring() > rhs.getDisableColoring()) return false;
    }
    if (hasOutputErrorOnStderr() || rhs.hasOutputErrorOnStderr()) {
        if (getOutputErrorOnStderr() < rhs.getOutputErrorOnStderr()) return true;
        if (getOutputErrorOnStderr() > rhs.getOutputErrorOnStderr()) return false;
    }
    if (hasLogFile() || rhs.hasLogFile()) {
        if (getLogFile() < rhs.getLogFile()) return true;
        if (getLogFile() > rhs.getLogFile()) return false;
    }
    if (hasAppendToLogFile() || rhs.hasAppendToLogFile()) {
        if (getAppendToLogFile() < rhs.getAppendToLogFile()) return true;
        if (getAppendToLogFile() > rhs.getAppendToLogFile()) return false;
    }
    return false;
}

inline bool LoggerConfiguration::operator > (const LoggerConfiguration& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LoggerConfiguration::clear() {
    clearLoggerLevel();
    clearBackend();
    clearBackendLibraryPath();
    clearBackendConfiguration();
    clearDisableColoring();
    clearOutputErrorOnStderr();
    clearLogFile();
    clearAppendToLogFile();
}

inline void LoggerConfiguration::clearLoggerLevel() {
    if (hasLoggerLevel()) {
         clear_has_loggerLevel();
        _loggerLevel.clear();
     }
}

inline bool LoggerConfiguration::hasLoggerLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, Level >& LoggerConfiguration::getLoggerLevel () const {
    return _loggerLevel;
}

inline ::std::map< ::std::string, Level >& LoggerConfiguration::getLoggerLevelMutable () {
    set_has_loggerLevel();
    return _loggerLevel;
}

inline void LoggerConfiguration::setLoggerLevel (const ::std::map< ::std::string, Level >& loggerLevel_) {
    set_has_loggerLevel();
    this->_loggerLevel = loggerLevel_;
}

inline void LoggerConfiguration::clearBackend() {
    if (hasBackend()) {
         clear_has_backend();
        _backend = "asflogging";
     }
}

inline bool LoggerConfiguration::hasBackend () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& LoggerConfiguration::getBackend () const {
    return _backend;
}

inline ::std::string& LoggerConfiguration::getBackendMutable () {
    set_has_backend();
    return _backend;
}

inline void LoggerConfiguration::setBackend (const ::std::string& backend_) {
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (backend_)) abort();
        #endif
    }
    set_has_backend();
    this->_backend = backend_;
}

inline void LoggerConfiguration::setBackend (const char* backend_) {
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (backend_)) abort();
        #endif
    }
    set_has_backend();
    this->_backend.assign(backend_);
}

inline void LoggerConfiguration::setBackend (const char* value, size_t size) {
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (value)) abort();
        #endif
    }
    set_has_backend();
    this->_backend.assign(value, size);
}

inline void LoggerConfiguration::clearBackendLibraryPath() {
    if (hasBackendLibraryPath()) {
         clear_has_backendLibraryPath();
        _backendLibraryPath.clear();
     }
}

inline bool LoggerConfiguration::hasBackendLibraryPath () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& LoggerConfiguration::getBackendLibraryPath () const {
    return _backendLibraryPath;
}

inline ::std::string& LoggerConfiguration::getBackendLibraryPathMutable () {
    set_has_backendLibraryPath();
    return _backendLibraryPath;
}

inline void LoggerConfiguration::setBackendLibraryPath (const ::std::string& backendLibraryPath_) {
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (backendLibraryPath_)) abort();
        #endif
    }
    set_has_backendLibraryPath();
    this->_backendLibraryPath = backendLibraryPath_;
}

inline void LoggerConfiguration::setBackendLibraryPath (const char* backendLibraryPath_) {
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (backendLibraryPath_)) abort();
        #endif
    }
    set_has_backendLibraryPath();
    this->_backendLibraryPath.assign(backendLibraryPath_);
}

inline void LoggerConfiguration::setBackendLibraryPath (const char* value, size_t size) {
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (value)) abort();
        #endif
    }
    set_has_backendLibraryPath();
    this->_backendLibraryPath.assign(value, size);
}

inline void LoggerConfiguration::clearBackendConfiguration() {
    if (hasBackendConfiguration()) {
         clear_has_backendConfiguration();
        _backendConfiguration.clear();
     }
}

inline bool LoggerConfiguration::hasBackendConfiguration () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::map< ::std::string, ::std::string >& LoggerConfiguration::getBackendConfiguration () const {
    return _backendConfiguration;
}

inline ::std::map< ::std::string, ::std::string >& LoggerConfiguration::getBackendConfigurationMutable () {
    set_has_backendConfiguration();
    return _backendConfiguration;
}

inline void LoggerConfiguration::setBackendConfiguration (const ::std::map< ::std::string, ::std::string >& backendConfiguration_) {
    set_has_backendConfiguration();
    this->_backendConfiguration = backendConfiguration_;
}

inline void LoggerConfiguration::clearDisableColoring() {
    if (hasDisableColoring()) {
         clear_has_disableColoring();
        _disableColoring = false;
     }
}

inline bool LoggerConfiguration::hasDisableColoring () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool LoggerConfiguration::getDisableColoring () const {
    return _disableColoring;
}

inline void LoggerConfiguration::setDisableColoring (bool disableColoring_) {
    set_has_disableColoring();
    this->_disableColoring = disableColoring_;
}

inline void LoggerConfiguration::clearOutputErrorOnStderr() {
    if (hasOutputErrorOnStderr()) {
         clear_has_outputErrorOnStderr();
        _outputErrorOnStderr = false;
     }
}

inline bool LoggerConfiguration::hasOutputErrorOnStderr () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool LoggerConfiguration::getOutputErrorOnStderr () const {
    return _outputErrorOnStderr;
}

inline void LoggerConfiguration::setOutputErrorOnStderr (bool outputErrorOnStderr_) {
    set_has_outputErrorOnStderr();
    this->_outputErrorOnStderr = outputErrorOnStderr_;
}

inline void LoggerConfiguration::clearLogFile() {
    if (hasLogFile()) {
         clear_has_logFile();
        _logFile.clear();
     }
}

inline bool LoggerConfiguration::hasLogFile () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& LoggerConfiguration::getLogFile () const {
    return _logFile;
}

inline ::std::string& LoggerConfiguration::getLogFileMutable () {
    set_has_logFile();
    return _logFile;
}

inline void LoggerConfiguration::setLogFile (const ::std::string& logFile_) {
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (logFile_)) abort();
        #endif
    }
    set_has_logFile();
    this->_logFile = logFile_;
}

inline void LoggerConfiguration::setLogFile (const char* logFile_) {
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (logFile_)) abort();
        #endif
    }
    set_has_logFile();
    this->_logFile.assign(logFile_);
}

inline void LoggerConfiguration::setLogFile (const char* value, size_t size) {
    {
        #ifndef NDEBUG
            if (!::asf::core::Utf8String::isValidAndLog (value)) abort();
        #endif
    }
    set_has_logFile();
    this->_logFile.assign(value, size);
}

inline void LoggerConfiguration::clearAppendToLogFile() {
    if (hasAppendToLogFile()) {
         clear_has_appendToLogFile();
        _appendToLogFile = false;
     }
}

inline bool LoggerConfiguration::hasAppendToLogFile () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool LoggerConfiguration::getAppendToLogFile () const {
    return _appendToLogFile;
}

inline void LoggerConfiguration::setAppendToLogFile (bool appendToLogFile_) {
    set_has_appendToLogFile();
    this->_appendToLogFile = appendToLogFile_;
}

inline void LoggerConfiguration::set_has_loggerLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void LoggerConfiguration::clear_has_loggerLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LoggerConfiguration::set_has_backend () {
    _has_bits_[0] |= 1u << 1;
}

inline void LoggerConfiguration::clear_has_backend () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LoggerConfiguration::set_has_backendLibraryPath () {
    _has_bits_[0] |= 1u << 2;
}

inline void LoggerConfiguration::clear_has_backendLibraryPath () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void LoggerConfiguration::set_has_backendConfiguration () {
    _has_bits_[0] |= 1u << 3;
}

inline void LoggerConfiguration::clear_has_backendConfiguration () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void LoggerConfiguration::set_has_disableColoring () {
    _has_bits_[0] |= 1u << 4;
}

inline void LoggerConfiguration::clear_has_disableColoring () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void LoggerConfiguration::set_has_outputErrorOnStderr () {
    _has_bits_[0] |= 1u << 5;
}

inline void LoggerConfiguration::clear_has_outputErrorOnStderr () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void LoggerConfiguration::set_has_logFile () {
    _has_bits_[0] |= 1u << 6;
}

inline void LoggerConfiguration::clear_has_logFile () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void LoggerConfiguration::set_has_appendToLogFile () {
    _has_bits_[0] |= 1u << 7;
}

inline void LoggerConfiguration::clear_has_appendToLogFile () {
    _has_bits_[0] &= ~ (1u << 7);
}

} // namespace Logging
} // namespace core
} // namespace asf

#endif // ASF_CORE_LOGGING_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
