/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     IncomingOutgoingIF.h
 *\brief
 *
 *\author   CM-PS/ETC1-PEC2HI
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/
#ifndef ASF_CORE_INCOMING_OUTGOING_H
#define ASF_CORE_INCOMING_OUTGOING_H

#include "asf/core/ConnectionIF.h"
#include "asf/core/StartStopWaitIF.h"

namespace asf {
namespace core {

class OutgoingIF {
public:
    virtual ~OutgoingIF() {}

    virtual ConnectionIFSharedPtr connectServer(const std::string& /*address*/) {
        return ConnectionIFSharedPtr();
    }

    virtual void disconnectServer(ConnectionIFSharedPtr /*connection*/) {}

    virtual ssize_t sendData(ConnectionIFSharedPtr connection, size_t size, const uint8* data) = 0;
};

class IncomingIF {
public:
    enum enError {
        EN_ERROR_UNKNOWN = 0,
        EN_ERROR_CANT_INIT_SERVER,
        EN_ERROR_CANT_ACCEPT_CONNECTION,
        EN_ERROR_LOST_CONNECTION
    };

    virtual ~IncomingIF() {}

    virtual void setOutgoingIF(OutgoingIF* pOutgoing) = 0;

    virtual void onConnected(ConnectionIFSharedPtr connection) = 0;

    virtual void onDisconnected(ConnectionIFSharedPtr connection) = 0;

    virtual void onReceivedData(ConnectionIFSharedPtr connection,
                                size_t size,
                                const uint8* pu8Data) = 0;

    virtual void onError(ConnectionIFSharedPtr connection, enError err) = 0;
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_INCOMING_OUTGOING_H
