/*********************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2019
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *********************************************************************/

#ifndef ASF_CORE_EXCEPTIONS
#define ASF_CORE_EXCEPTIONS

#ifdef __GNUC__

	#ifdef  __EXCEPTIONS
		#define ASF_HAVE_EXCEPTIONS
	#endif

	#ifdef  __GXX_RTTI
		#define ASF_RTTI_ENABLED
	#endif
#else

	#ifdef _MSC_VER
		#ifdef  _CPPUNWIND
			#define ASF_HAVE_EXCEPTIONS
		#endif

#elif defined __ghs__
#ifdef __EXCEPTIONS
#define ASF_HAVE_EXCEPTIONS
#endif

#else
#error "Compiler not recognized for detecting exception handling status"
#endif

		#ifdef ASF_HAVE_EXCEPTIONS
#define __try try
#define __catch(X) catch (X)
#define __throw_exception_again throw
		#else
#define __try if (true)
#define __catch(X) if (false)
#define __throw_exception_again
#endif

#endif

#endif
