/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ConnectionMessage.h
 *\brief
 *
 *\author   CM-AI/PJ-CF11.1
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_CONNECTIONMESSAGE_H
#define ASF_CORE_CONNECTIONMESSAGE_H
#include <boost/shared_ptr.hpp>
#include "asf/core/ComponentMessage.h"
#include "asf/core/ConnectionIF.h"
#include "asf/core/Types.h"

namespace asf {
namespace core {

class ConnectionMessage : public ComponentMessage {
public:
    ConnectionMessage(ConnectionIFSharedPtr connection, bool isStub, bool isCon)
        : _connection(connection), _isStub(isStub), _isConnected(isCon) {}

    virtual ~ConnectionMessage() {}

    virtual bool isRemote() const { return false; }

    virtual bool sendRemote() { return false; }

    ConnectionIFSharedPtr getConnection() const { return _connection; }

    bool isStubConnection() const { return _isStub; }

    bool isProxyConnection() const { return (!_isStub); }

    bool isConnected() const { return _isConnected; }

private:
    ConnectionIFSharedPtr _connection;
    bool _isStub;
    bool _isConnected;
};

typedef ::boost::shared_ptr< ConnectionMessage > ConnectionMessageSharedPtr;

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_CONNECTIONMESSAGE_H
