/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     Blob.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_CORE_BLOB_H
#define ASF_CORE_BLOB_H

#include <cstdlib>
#include <cstring>
#include "asf/core/Types.h"

namespace asf {
namespace core {

/**
 * A Blob represents an arbitrary number of bytes allocated on the heap.
 */
class Blob {
public:
    /**
     * Creates an empty blob of size 0
     */
    Blob();

    Blob(const uint8* bytes, size_t size);

    Blob(const Blob& rhs);

    ~Blob();

    Blob& operator=(const Blob& rhs);

    bool operator==(const Blob& rhs) const;

    bool operator!=(const Blob& rhs) const;

    bool operator<(const Blob& rhs) const;

    bool operator>(const Blob& rhs) const;

    size_t getSize() const;

    /**
     * Sets the size of the blob.
     *
     * A new memory buffer will be allocated and all bytes will be initialized by 0.
     */
    void setSize(size_t size);

    const uint8* getBytes() const;

    uint8* getBytes();

    void push_back(uint8 byte);

    void push_back(const void* buffer, size_t size);

    void setData(const void* buffer, size_t size);

private:
    uint8* _bytes;

    size_t _size;
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_BLOB_H
