/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsServiceStreamer.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2017 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSSERVICESTREAMER_H
#define ASF_CMS_CMSSERVICESTREAMER_H

#include <cassert>
#include <iostream>
#include <map>
#include <vector>
#include "asf/cms/CmsMessage.h"
#include "asf/core/Logger.h"
#include "asf/core/Message.h"
#include "asf/core/ServiceStreamer.h"
#include "asf/core/Types.h"
#include "asf/threading/Mutex.h"

class CmsServiceStreamerTest;

namespace asf {
namespace cms {

class CmsServiceStreamer : public ::asf::core::ServiceStreamer {
public:
    CmsServiceStreamer() { init(); }

    virtual ~CmsServiceStreamer() {}

    typedef void (CmsServiceStreamer::*MsgFunction)(::asf::cms::CmsMessage& msg);

    typedef std::map< std::string, MsgFunction > MsgFunctionMap;

    typedef std::pair< std::string, MsgFunction > MsgFunctionPair;

    // deserialize incoming raw data and binds the parameter object to the message
    bool deserializeCmsMessage(CmsMessage& msg);

    bool serializeCmsMessage(CmsMessage& msg);

    bool addSerializer(CmsTypes::CmsMessageHeader::CmsMessageType type,
                       std::string functionId,
                       MsgFunction func);

    bool addDeserializer(CmsTypes::CmsMessageHeader::CmsMessageType type,
                         std::string functionId,
                         MsgFunction func);

    virtual bool deserialize(::asf::core::Message& msg) {
        return deserializeCmsMessage(static_cast< CmsMessage& >(msg));
    }

    virtual bool serialize(::asf::core::Message& msg) {
        return serializeCmsMessage(static_cast< CmsMessage& >(msg));
    }

private:
    // stub maps
    MsgFunctionMap _deserializerRequestMap;
    MsgFunctionMap _deserializerRegisterMap;
    MsgFunctionMap _deserializerDeregisterMap;
    MsgFunctionMap _deserializerGetMap;
    MsgFunctionMap _deserializerSetMap;
    MsgFunctionMap _deserializerAbortMap;

    MsgFunctionMap _serializerResponseMap;
    MsgFunctionMap _serializerNotifyMap;
    MsgFunctionMap _serializerRequestErrorMap;
    MsgFunctionMap _serializerRegisterErrorMap;
    MsgFunctionMap _serializerGetErrorMap;
    MsgFunctionMap _serializerSetErrorMap;
    MsgFunctionMap _serializerProgressMap;

    // proxy maps
    MsgFunctionMap _serializerRequestMap;
    MsgFunctionMap _serializerRegisterMap;
    MsgFunctionMap _serializerDeregisterMap;
    MsgFunctionMap _serializerGetMap;
    MsgFunctionMap _serializerSetMap;
    MsgFunctionMap _serializerAbortMap;

    MsgFunctionMap _deserializerResponseMap;
    MsgFunctionMap _deserializerNotifyMap;
    MsgFunctionMap _deserializerRequestErrorMap;
    MsgFunctionMap _deserializerRegisterErrorMap;
    MsgFunctionMap _deserializerGetErrorMap;
    MsgFunctionMap _deserializerSetErrorMap;
    MsgFunctionMap _deserializerProgressMap;

    std::map< int32, MsgFunctionMap* > _serializerMapToMsgType;
    std::map< int32, MsgFunctionMap* > _deserializerMapToMsgType;

    MsgFunctionMap* getSerializerMapFromMessageType(
        CmsTypes::CmsMessageHeader::CmsMessageType type);
    MsgFunctionMap* getDeserializerMapFromMessageType(
        CmsTypes::CmsMessageHeader::CmsMessageType type);

    void init();

    friend class ::CmsServiceStreamerTest;

    DECLARE_CLASS_LOGGER();
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CMS_CMSSERVICESTREAMER_H
