/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsMessageAdapter.h
 *\brief
 *
 *\author   CM-AI/PJ-CF11.1
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_CMSMESSAGEADAPTER_H
#define ASF_CORE_CMSMESSAGEADAPTER_H

#include "asf/cms/CmsExports.h"
#include "asf/cms/CmsHeaderEncoderIF.h"
#include "asf/cms/CmsImports.h"
#include "asf/cms/CmsMessage.h"
#include "asf/cms/CmsProxyRegistry.h"
#include "asf/cms/CmsStubDelegate.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Stub.h"
#include "asf/core/Types.h"
#include "asf/threading/Mutex.h"

namespace asf {
namespace cms {

class CmsMessageAdapter : public ::asf::core::ComponentMessageAdapter {
public:
    CmsMessageAdapter(CmsHeaderEncoderIF& headerEncoder);

    virtual ~CmsMessageAdapter();

    virtual ::asf::core::ServiceMessage* createServiceMessage(
        const ::boost::shared_ptr< ::asf::core::Blob >& blobMessage,
        ::asf::core::CommunicationStack* comStack,
        ::asf::core::ConnectionIFSharedPtr connection);

    virtual ::asf::core::ConnectionMessage* createConnectionMessage(
        ::asf::core::ConnectionIFSharedPtr connection, bool isStub, bool isConnected);

    CmsExportedPort& addExport(::asf::core::ProvidedPort& providedPort,
                               const std::string& exportName);

    CmsImportedPort& addImport(const std::string& exportedPortName, const std::string& url);

    CmsExportedPort* getExport(const std::string& exportName);

    bool isExportedService(CmsMessage& msg);

    bool serializeHeader(CmsMessage& msg) { return _headerEncoder.serialize(msg); }

    bool serializeEnd(CmsMessage& msg) { return _headerEncoder.serializeEnd(msg); }

private:
    CmsHeaderEncoderIF& _headerEncoder;

    CmsImports _imports;

    CmsExports _exports;

    DECLARE_CLASS_LOGGER();
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CORE_CMSMESSAGEADAPTER_H
