/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsBinPrimitivesReader.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSBINPRIMITIVESREADER
#define ASF_CMS_CMSBINPRIMITIVESREADER

#include "asf/stream/BlobInputStream.h"
#include "asf/stream/FourBytePaddingInputStream.h"
#include "asf/stream/PrimitivesReader.h"

namespace asf {
namespace cms {

/**
 * This is a helper class which represents the input streaming configuration
 * for the cms bin format.
 */
class CmsBinPrimitivesReader {
public:
    CmsBinPrimitivesReader(::asf::core::Blob& blob, size_t offset = 0)
        : _reader(_fourBytePaddingInputStream),
          _blobInputStream(blob, offset),
          _fourBytePaddingInputStream(_blobInputStream) {}

    ::asf::stream::PrimitivesReader& getReader() { return _reader; }

    ::asf::stream::PrimitivesReader _reader;

private:
    ::asf::stream::BlobInputStream _blobInputStream;

    ::asf::stream::FourBytePaddingInputStream _fourBytePaddingInputStream;
};
}  // namespace cms
}  // namespace asf

#endif
