/*********************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2019
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *********************************************************************/

#ifndef ASF_CCA__DEFAULT_TYPES_CCA_H
#define ASF_CCA__DEFAULT_TYPES_CCA_H

#include "asf/cca/CcaTypes.h"

#include "asf/stream/MemoryStream.h"

void serializeCca(const ::asf::cca::CcaTypes::DefaultError& in,
                  ::asf::stream::MemoryStream& out,
                  unsigned int majorVersion);

void deserializeCca(::asf::stream::MemoryStream& in,
                    ::asf::cca::CcaTypes::DefaultError& out,
                    unsigned int majorVersion);

void serializeCca(const ::asf::cca::CcaTypes::DefaultMessage& in,
                  ::asf::stream::MemoryStream& out,
                  unsigned int majorVersion);

void deserializeCca(::asf::stream::MemoryStream& in,
                    ::asf::cca::CcaTypes::DefaultMessage& out,
                    unsigned int majorVersion);

#endif
