/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_CCA_CCATYPESCONST_H
#define ASF_CCA_CCATYPESCONST_H

#include <cstddef>

/**
 * This type collection specifies the cca message headers as described in
 * "CCA Services - Definition and Use", 02.01, 2011-09-20, see
 * https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-182610/cca_services_v02.01_english_draft.doc
 */

namespace asf {
namespace cca {
namespace CcaTypes {

/**
 * If the meaning of "Status" isn't clear, then there should be a description here.
 */
enum SrvSupplierStatus_Status {

    /**
     * Application is known but not started
     */
    SrvSupplierStatus_Status__Unavailable = 0u,
    /**
     * Application is initialized
     */
    SrvSupplierStatus_Status__Available = 1u,
    /**
     * There is no application which offers the service
     */
    SrvSupplierStatus_Status__Unknown = 2u

};

bool SrvSupplierStatus_Status_Parse (const char *str, size_t length, SrvSupplierStatus_Status &value);

const char* SrvSupplierStatus_Status_Name (SrvSupplierStatus_Status value);

bool SrvSupplierStatus_Status_IsValid (SrvSupplierStatus_Status value);

/**
 * If the meaning of "Status" isn't clear, then there should be a description here.
 */
enum AppInfoStatus_Status {

    /**
     * Application is known but not started
     */
    AppInfoStatus_Status__Unavailable = 0u,
    /**
     * Application is initialized
     */
    AppInfoStatus_Status__Available = 1u,
    /**
     * There is no application which offers the service
     */
    AppInfoStatus_Status__Unknown = 2u,
    /**
     * E.g. repeated registration for the same application without prior
     * deregistration.
     */
    AppInfoStatus_Status__RegistrationError = 3u

};

bool AppInfoStatus_Status_Parse (const char *str, size_t length, AppInfoStatus_Status &value);

const char* AppInfoStatus_Status_Name (AppInfoStatus_Status value);

bool AppInfoStatus_Status_IsValid (AppInfoStatus_Status value);

/**
 * If the meaning of "RegistrationStatus" isn't clear, then there should be a description here.
 */
enum RegistrationStatus {

    /**
     * If the meaning of "NoSuccess" isn't clear, then there should be a description here.
     */
    RegistrationStatus__NoSuccess = 0u,
    /**
     * If the meaning of "Success" isn't clear, then there should be a description here.
     */
    RegistrationStatus__Success = 1u,
    /**
     * If the meaning of "Denied" isn't clear, then there should be a description here.
     */
    RegistrationStatus__Denied = 2u

};

bool RegistrationStatus_Parse (const char *str, size_t length, RegistrationStatus &value);

const char* RegistrationStatus_Name (RegistrationStatus value);

bool RegistrationStatus_IsValid (RegistrationStatus value);

/**
 * If the meaning of "AvailabilityState" isn't clear, then there should be a description here.
 */
enum AvailabilityState {

    /**
     * If the meaning of "Available" isn't clear, then there should be a description here.
     */
    AvailabilityState__Available = 0u,
    /**
     * If the meaning of "Unavailable" isn't clear, then there should be a description here.
     */
    AvailabilityState__Unavailable = 1u,
    /**
     * If the meaning of "Denied" isn't clear, then there should be a description here.
     */
    AvailabilityState__Denied = 2u

};

bool AvailabilityState_Parse (const char *str, size_t length, AvailabilityState &value);

const char* AvailabilityState_Name (AvailabilityState value);

bool AvailabilityState_IsValid (AvailabilityState value);

/**
 * If the meaning of "OpCode" isn't clear, then there should be a description here.
 */
enum ServiceData_OpCode {

    /**
     * If the meaning of "Set" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__Set,
    /**
     * If the meaning of "Get" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__Get,
    /**
     * If the meaning of "MethodStart" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__MethodStart,
    /**
     * If the meaning of "UpReg" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__UpReg,
    /**
     * If the meaning of "RelUpReg" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__RelUpReg,
    /**
     * If the meaning of "MethodAbort" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__MethodAbort,
    /**
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__Status,
    /**
     * If the meaning of "MethodResult" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__MethodResult,
    /**
     * If the meaning of "Error" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__Error,
    /**
     * If the meaning of "AbortResult" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__AbortResult,
    /**
     * If the meaning of "MethodResultFirst" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__MethodResultFirst,
    /**
     * If the meaning of "MethodResultMiddle" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__MethodResultMiddle,
    /**
     * If the meaning of "MethodResultLast" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__MethodResultLast,
    /**
     * If the meaning of "ClientPortAck" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__ClientPortAck,
    /**
     * If the meaning of "ServerPortAck" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__ServerPortAck,
    /**
     * If the meaning of "Increment" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__Increment = 16u,
    /**
     * If the meaning of "Decrement" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__Decrement = 17u,
    /**
     * If the meaning of "PureSet" isn't clear, then there should be a description here.
     */
    ServiceData_OpCode__PureSet = 18u

};

bool ServiceData_OpCode_Parse (const char *str, size_t length, ServiceData_OpCode &value);

const char* ServiceData_OpCode_Name (ServiceData_OpCode value);

bool ServiceData_OpCode_IsValid (ServiceData_OpCode value);

/**
 * An error message contains an 16 bits wide error number (ErrorCode), whereby
 * the error numbers 0 to 255 are defined for general errors and are thus unavailable
 * for service-specific use. In the absence of any statement to the contrary, they are
 * possible for both methods and properties.
 */
enum CcaErrorCode {

    /**
     * An unknown error has occurred which is not covered by the other error number.
     *
     * Sending this error number by the server must be avoided, as the client has
     * neither any further information about the cause nor received possible
     * indications about rectification. A rule applicable to the server is that the
     * error number must be sent back to the client which describes the error most
     * accurately.
     */
    CcaErrorCode__Unspecified,
    /**
     * The ServiceID transmitted is invalid, i.e. it does not correspond to the one
     * previously stated in a ServiceRegister message.
     */
    CcaErrorCode__UnknownSvcId,
    /**
     * The function transmitted is not defined for the service stated.
     */
    CcaErrorCode__UnknownFctId,
    /**
     * The OpCode is outside the permissible range of 0x00 to 0x09
     * (c.f. paragraph 10.6 ) This does not depend upon whether the OpCode is
     * supported by the function (c.f. OpCodeNotSupported).
     */
    CcaErrorCode__InvalidOpCode,
    /**
     * The type of message in the IPC header is invalid.
     */
    CcaErrorCode__InvalidCCAType,
    /**
     * At least one of the parameters transferred is outside the permissible
     * range (e.g. the temperature for the air conditioning system is only specified
     * as [10...30] and otherwise invalid.
     */
    CcaErrorCode__ParameterOutOfRange,
    /**
     * The RegisterID transferred is invalid, i.e. it does not correspond to the one
     * previously stated in a ServiceRegister message.
     */
    CcaErrorCode__UnknownRegId,
    /**
     * The version of the CCA message in the IPC header is not supported by the
     * server. The currently valid version is 0x0002.
     */
    CcaErrorCode__VersionNotSupported,
    /**
     * At least one parameter for the specified function is missing. This error
     * message is sent if the appropriate request message does not contain the
     * necessary number of parameters (matching the interface description).
     */
    CcaErrorCode__ParameterMissing,
    /**
     * At least one parameter for the specified function is superfluous.
     */
    CcaErrorCode__ParameterTooMany,
    /**
     * The function is available but cannot currently be initiated because it is
     * already being implemented (c.f. paragraph 7.3). This function will not be
     * placed in a queue. (applicable to methods only).
     */
    CcaErrorCode__Busy,
    /**
     * The function has been implemented but cannot be initiated at present
     * (c.f. paragraph 11.2 ). (applicable to methods only).
     */
    CcaErrorCode__TemporaryNotAvailable,
    /**
     * The OpCode represents the refinement of the function. The OpCode is not
     * supported for the function specified. The validity of an OpCode emerges
     * firstly from the application  and secondly from the description of the interface.
     */
    CcaErrorCode__OpCodeNotSupported,
    /**
     * An internal error has occurred during execution of the function.
     */
    CcaErrorCode__InternalFailure,
    /**
     * Registration for spontaneous notifications has failed. This error is sent
     * by the server, if no further clients can register for reasons of capacity
     * or if the client has already registered successfully (applicable to properties
     * only).
     */
    CcaErrorCode__UpRegFailure,
    /**
     * Deregistration for spontaneous notifications has failed. This error is sent
     * by the server, if at server side the client is not listed as previously
     * successfully registered (applicable to properties only).
     */
    CcaErrorCode__RelUpRegFailure

};

bool CcaErrorCode_Parse (const char *str, size_t length, CcaErrorCode &value);

const char* CcaErrorCode_Name (CcaErrorCode value);

bool CcaErrorCode_IsValid (CcaErrorCode value);

/**
 * If the meaning of "ProxyState" isn't clear, then there should be a description here.
 */
enum ProxyState {

    /**
     * If the meaning of "Init" isn't clear, then there should be a description here.
     */
    ProxyState__Init,
    /**
     * If the meaning of "SrvSupplierRegisterSent" isn't clear, then there should be a description here.
     */
    ProxyState__SrvSupplierRegisterSent,
    /**
     * If the meaning of "ServiceRegisterSent" isn't clear, then there should be a description here.
     */
    ProxyState__ServiceRegisterSent,
    /**
     * If the meaning of "ServiceRegisterConfirmed" isn't clear, then there should be a description here.
     */
    ProxyState__ServiceRegisterConfirmed,
    /**
     * If the meaning of "ServiceAvailable" isn't clear, then there should be a description here.
     */
    ProxyState__ServiceAvailable,
    /**
     * If the meaning of "ServiceUnavailable" isn't clear, then there should be a description here.
     */
    ProxyState__ServiceUnavailable,
    /**
     * If the meaning of "Disconnected" isn't clear, then there should be a description here.
     */
    ProxyState__Disconnected,
    /**
     * If the meaning of "InDestructor" isn't clear, then there should be a description here.
     */
    ProxyState__InDestructor

};

bool ProxyState_Parse (const char *str, size_t length, ProxyState &value);

const char* ProxyState_Name (ProxyState value);

bool ProxyState_IsValid (ProxyState value);

/**
 * If the meaning of "SystemErrorCode" isn't clear, then there should be a description here.
 */
enum SystemErrorCode {

    /**
     * This error code is used to signal an error when a service was used without
     * being available, such like starting a method before the service came available.
     */
    SystemErrorCode__ServiceNotAvailable

};

bool SystemErrorCode_Parse (const char *str, size_t length, SystemErrorCode &value);

const char* SystemErrorCode_Name (SystemErrorCode value);

bool SystemErrorCode_IsValid (SystemErrorCode value);

} // namespace CcaTypes
} // namespace cca
} // namespace asf

#endif // ASF_CCA_CCATYPESCONST_H
