/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     CcaQueueTransport.h
 *\brief
 *
 *\author   CM-AI/PJ-CF11.1
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CCA_CCAQUEUETRANSPORT_H
#define ASF_CCA_CCAQUEUETRANSPORT_H

#include "asf/cca/CcaQueueConnection.h"
#include "asf/core/Blob.h"
#include "asf/core/IncomingOutgoingIF.h"
#include "asf/threading/Mutex.h"
#include "asf/threading/ThreadRunnableExecutor.h"

#include <map>

namespace asf {
namespace cca {

class OsalQueue;

class CcaQueueTransport : public ::asf::core::OutgoingIF,
                          public ::asf::threading::RunnableIF,
                          public ::asf::core::StartStopWaitIF {
public:
    CcaQueueTransport(::asf::core::IncomingIF* poIncomingEvent,
                      uint16 backChannelAppId,
                      uint16 maxMessages = 100);

    ~CcaQueueTransport();

    ssize_t sendData(size_t size, const uint8* pData);

    // implement OutgoingIF
    virtual ssize_t sendData(::asf::core::ConnectionIFSharedPtr connection,
                             size_t size,
                             const uint8* pu8Data);

    uint16 getClientCount() const { return (uint16)_connections.size(); }

    // ClientOutgoingIF implementation
    virtual ::asf::core::ConnectionIFSharedPtr connectServer(const std::string& address);

    virtual void disconnectServer(::asf::core::ConnectionIFSharedPtr connection);

    // StartStopWaitIF implementation
    virtual void start();

    virtual void stop();

    virtual void waitForCompletion();

    uint16 getMaxMessages() const;

private:
    CcaQueueTransport(const CcaQueueTransport&);

    CcaQueueTransport& operator=(const CcaQueueTransport&);

    void createBackChannelQueue();

    typedef std::map< uint32, CcaQueueConnectionSharedPtr > AppIdClientConnectionMap;

    typedef std::pair< uint32, CcaQueueConnectionSharedPtr > AppIdClientConnectionPair;

    // RunnableIF implementation
    virtual ::asf::threading::RunnableIF::tenRun enRun();

    ::asf::core::ConnectionIFSharedPtr connectServer(const std::string& address, uint16 appId);

    uint16 getSourceApplicationId(uint8* data, size_t size) const;

    ::asf::core::IncomingIF* _poIncomingEvent;

    AppIdClientConnectionMap _connections;

    ::asf::threading::ThreadRunnableExecutor* _poReceiverThread;

    uint16 _backChannelAppId;

    std::string _backChannelQueueName;

    OsalQueue* _backChannelQueue;

    ::asf::core::Blob _receiveBlob;

    bool _stopped;

    ::asf::threading::Mutex _lock;

    uint16 _maxMessages;
};

}  // namespace cca
}  // namespace asf

#endif  // ASF_CCA_CCAQUEUETRANSPORT_H
