/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     CcaQueueConnection.h
 *\brief
 *
 *\author   CM-AI/PJ-CF11.1
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CCA_CCACLIENTCONNECTION_H
#define ASF_CCA_CCACLIENTCONNECTION_H

#include "asf/core/IncomingOutgoingIF.h"

#include <string>

namespace asf {
namespace cca {

class OsalQueue;

class CcaQueueConnection : public ::asf::core::ConnectionIF {
public:
    CcaQueueConnection(const std::string& address,
                       uint16 sourceApplicationId,
                       uint16 serverApplicationId);

    virtual ~CcaQueueConnection();

    bool connectServer();

    void disconnectServer();

    // ConnectionIF implementation

    virtual ssize_t sendData(size_t size, const uint8* pu8Data);

    virtual ::asf::identifier_t getConnectionId() { return 0; }

    const std::string& getQueueName() const { return _serverQueueName; }

    uint16 getSourceApplicationId() const { return _sourceApplicationId; }

    uint16 getDestinationApplicationId() const { return _serverApplicationId; }

    bool isConnected() const { return _isConnected; }

private:
    CcaQueueConnection(const CcaQueueConnection&);

    CcaQueueConnection& operator=(const CcaQueueConnection&);

    std::string _address;

    std::string _serverQueueName;

    uint16 _sourceApplicationId;

    uint16 _serverApplicationId;

    OsalQueue* _osalQueue;

    bool _isConnected;
};

typedef ::boost::shared_ptr< CcaQueueConnection > CcaQueueConnectionSharedPtr;

}  // namespace cca
}  // namespace asf

#endif  // ASF_CCA_CCACLIENTCONNECTION_H
