/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     CcaMessage.h
 *\brief
 *
 *\author   CM-AI/PJ-CF11.1
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CCA_CCAMESSAGE_H
#define ASF_CCA_CCAMESSAGE_H

#include "asf/core/Blob.h"
#include "asf/core/Logger.h"
#include "asf/core/ServiceMessage.h"

#include "asf/stream/MemoryStream.h"

#include "asf/cca/CcaPayloadDecorator.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaStubDelegate.h"
#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesJson.h"

#include <boost/shared_ptr.hpp>
#include <boost/weak_ptr.hpp>

namespace asf {
namespace cca {

// this macros are used by the generated proxy code

#define CCA_MESSAGE(var, header, payloadType, payloadInstance)                                     \
    ::asf::cca::CcaMessage var(                                                                    \
        ::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(header), _ccaProxyDelegate); \
    INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION(                                                  \
        var.getPayloadDecorator(), payloadType, payloadInstance);

#define CCA_LOOPBACK_MESSAGE(var, header, payloadType, payloadInstance)                            \
    ::asf::cca::CcaMessage var(                                                                    \
        ::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(header), _ccaProxyDelegate); \
    INIT_CCA_PAYLOAD_DECORATOR_FOR_LOOPBACK(                                                       \
        var.getPayloadDecorator(), payloadType, payloadInstance);

#define CCA_MOST_MESSAGE(var, header, payloadType, payloadInstance)                                \
    ::asf::cca::CcaMessage var(                                                                    \
        ::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(header), _ccaProxyDelegate); \
    INIT_CCA_PAYLOAD_DECORATOR_FOR_MOST_SERIALIZATION(                                             \
        var.getPayloadDecorator(), payloadType, payloadInstance);

#define CCA_MOST_LOOPBACK_MESSAGE(var, header, payloadType, payloadInstance)                       \
    ::asf::cca::CcaMessage var(                                                                    \
        ::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(header), _ccaProxyDelegate); \
    INIT_CCA_PAYLOAD_DECORATOR_FOR_MOST_LOOPBACK(                                                  \
        var.getPayloadDecorator(), payloadType, payloadInstance);

/**
 * A CcaMessage represents a message from the CCA framework.
 */
class CcaMessage : public ::asf::core::ServiceMessage {
public:
    /**
     * Create a CcaMessage with header only
     */
    CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader > header,
               ::boost::weak_ptr< ::asf::cca::CcaProxyDelegate > ccaProxyDelegate);

    /**
     * Create an incoming / received CcaMessage from a received header,
     * the yet to be decoded payload and a proxy which should process this
     * message.
     */
    CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader > header,
               ::boost::shared_ptr< ::asf::stream::MemoryStream > serializedPayload,
               ::boost::weak_ptr< ::asf::cca::CcaProxyDelegate > ccaProxyDelegate);

    /**
     * Create an incoming / received CcaMessage from a received header,
     * the yet to be decoded payload and a stub which should process this
     * message.
     */
    CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader > header,
               ::boost::shared_ptr< ::asf::stream::MemoryStream > serializedPayload,
               ::asf::cca::CcaStubDelegate* stub);

    const ::asf::cca::CcaTypes::CcaMessageHeader& getHeader() const;

    ::asf::cca::CcaTypes::CcaMessageHeader& getHeaderMutable() const;

    ::boost::shared_ptr< ::asf::core::Payload > getPayload();

    virtual ::asf::core::MessageSharedPtr clone() const {
        return ::asf::core::MessageSharedPtr(new ::asf::cca::CcaMessage(*this));
    };

    virtual void processMessage();

    virtual void setIsRemote(bool remote) { _isRemote = remote; }

    virtual bool isRemote() const { return _isRemote; }

    virtual bool sendRemote();

    virtual bool serialize(::asf::core::Blob& blob) const;

    void logDebugMessageHeader(::asf::core::Logger& _logger) const;

    void logInfoMessageHeader(::asf::core::Logger& _logger) const;

    void logInfoMessage(::asf::core::Logger& _logger);

    void logInfoMessageJsonOnly(::asf::core::Logger& _logger);

    ::boost::shared_ptr< ::asf::core::Proxy > getProxyShared()
        const;  // used by generated proxies as argument in callbacks

    ::asf::cca::CcaPayloadDecorator& getPayloadDecorator();

protected:
    ::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader > _header;

    ::boost::weak_ptr< ::asf::cca::CcaProxyDelegate > _proxyDelegate;

    ::asf::cca::CcaStubDelegate* _stubDelegate;

    ::asf::cca::CcaPayloadDecorator _payloadDecorator;

private:
    // Outgoing message

    void serializePayload(::asf::stream::MemoryStream& memoryStream) const;

    // Incoming message

    ::boost::shared_ptr< ::asf::stream::MemoryStream > _serializedPayload;

    void deserializePayload();

    bool isProxyDelegateValid() const;

    /**
     * The flag _isRemote is true per default but will be false when
     * sending internal messages to itself, e.g. error messages
     */
    bool _isRemote;

    DECLARE_CLASS_LOGGER();
};
}  // namespace cca
}  // namespace asf

#endif
