/**
* @copyright (c) 2015-2020 Robert Bosch Car Multimedia GmbH
* @addtogroup aivi_pres_ctrl
* @{
*/

#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_CALLBACK_PROPERTYUPDATECALLBACK_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_CALLBACK_PROPERTYUPDATECALLBACK_H_

#include <vector>
#include "PropertyIdentifiers.h"

namespace navmiddleware
{

/**
* navigation middleware callback to propagate property updates up to the HMI layer.
*/
class PropertyUpdateCallback
{
public:

   typedef ::std::vector<PropertyIdentifiers> T_PropertyIdentifierContainer;

   PropertyUpdateCallback() {}
   virtual ~PropertyUpdateCallback() {}

   virtual void onPropertyUpdate(const T_PropertyIdentifierContainer& propertyIdentifiers) = 0;
};

} // navmiddlewarecallback

#endif  // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_CALLBACK_PROPERTYUPDATECALLBACK_H_
