/**
* @copyright (c) 2015-2019 Robert Bosch Car Multimedia GmbH
* @addtogroup aivi_pres_ctrl
* @{
*/

#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_CALLBACK_PROPERTYIDENTIFIERS_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_CALLBACK_PROPERTYIDENTIFIERS_H_

namespace navmiddleware
{

/**
* property identifier enum
*/
enum PropertyIdentifiers
{
   LIFECYCLE_STARTED = 0,
   LIFECYCLE_STOPPED,
   LIFECYCLE_NAVDATAUPDATE_STARTED,
   LIFECYCLE_NAVDATAUPDATE_FINISHED,
   LIFECYCLE_NAVDATA_RECOVERY,

   GUIDANCE_STATE_CHANGED = 100,
   GUIDANCE_MANEUVERINFOS_CHANGED,
   GUIDANCE_MANEUVERVIEW_CHANGED,
   GUIDANCE_SPEEDLIMIT_CHANGED,
   GUIDANCE_OVERSPEED_CHANGED,
   GUIDANCE_ARRIVALINFOS_CHANGED,
   GUIDANCE_DESTINATIONS_CHANGED,
   GUIDANCE_SIGNPOST_CHANGED,
   GUIDANCE_HORIZONEVENT_CHANGED,
   GUIDANCE_SPEEDCAM_CHANGED,
   GUIDANCE_SPEEDCAM_DISTANCE_CHANGED,
   GUIDANCE_TRAFFICSIGN_CHANGED,
   GUIDANCE_TRAFFIC_ENFORCEMENT_INFO_CHANGED,
   GUIDANCE_DESTINATION_REACHED,
   GUIDANCE_GUARDIAN_ANGEL_ALERT_CHANGED,
   GUIDANCE_UNREACHABLE_DESTINATION_ALERT_CHANGED,
   GUIDANCE_LOW_BATTERY_ALERT_CHANGED,
   GUIDANCE_AD2_AVAILABILITY_CHANGED,
   GUIDANCE_STARTED_ON_PLANNED_ROUTE,
   GUIDANCE_WAYPOINT_SKIPPED,
   GUIDANCE_DESTINATION_DETECTED_BASED_ON_LEARNED_ROUTES,
   GUIDANCE_TRAFFIC_EVENTS_DETECTED_ON_LEARNED_ROUTES,
   GUIDANCE_VEHICLE_RESTRICTIONS_CHANGED,
   GUIDANCE_VEHICLE_RESTRICTIONS_AVAILABLE,
   GUIDANCE_COUNTRY_DETAILS_AVAILABLE,
   GUIDANCE_NEAREST_CHARGING_STATION_INFO_CHANGED,
   GUIDANCE_LAST_GUIDED_ITEM_DETAILS_AVAILABLE,
   GUIDANCE_SETTINGS_CHANGED = 150,
   GUIDANCE_EV_BATTERY_STATUS_WARNING_SETTINGS_CHANGED,
   GUIDANCE_ECONAV_SWITCH_STATUS_CHANGED,
   GUIDANCE_ECONAV_STATUS_CHANGED,
   GUIDANCE_URBAN_ZEV_DRIVING_OPTION_STATUS_CHANGED,

   LOCATION_ADRESS_INPUT_INFO_CHANGED = 200,
   LOCATION_ADDRESS_SPELLER_INFO_CHANGED,
   LOCATION_ADDRESS_ELEMENTS_CHANGED,
   LOCATION_LAST_SELECTED_ADDRESS_ELEMENTS_CHANGED,
   LOCATION_POI_INPUT_INFO_CHANGED = 210,
   LOCATION_POI_ENTRIES_CHANGED,
   LOCATION_POI_SHORTCUT_INFORMATION_UPDATED,
   LOCATION_POI_ENTRY_ATTRIBUTES_AVAILABLE,
   LOCATION_POI_ENTRY_ATTRIBUTES_ERROR,
   LOCATION_POI_CATEGORY_SPELLER_INFO_CHANGED,
   LOCATION_ONLINE_POI_AVAILABILITY_CHANGED,
   LOCATION_POI_ICON_INFORMATION_UPDATED,
   LOCATION_FREE_TEXT_SEARCH_RESULTS_CHANGED = 220,
   LOCATION_FREE_TEXT_SEARCH_SPELLER_INFO_CHANGED,
   LOCATION_FREE_TEXT_SEARCH_RESULT_ATTRIBUTES_AVAILABLE,
   LOCATION_FREE_TEXT_SEARCH_RESULT_ATTRIBUTES_ERROR,
   LOCATION_ONLINE_FREE_TEXT_SEARCH_AVAILABILITY_CHANGED,
   LOCATION_FREE_TEXT_SEARCH_RESUME_STATUS_CHANGED,
   LOCATION_ENTRY_SELECTION_STATUS_CHANGED,
   LOCATION_SDS_ADDRESS_WITH_OPTIONS_CHANGED = 230,
   LOCATION_SDS_ELEMENTS_CHANGED,
   LOCATION_SDS_PATTERNS_CHANGED,
   LOCATION_SDS_GLOBAL_DATA_CHANGED,
   LOCATION_SDS_ID_LIST_COUNTRY_AND_SUBCOUNTRY_CHANGED,
   LOCATION_SDS_NAMES_FOR_NDS_IDS_CHANGED,
   LOCATION_SDS_PHONEMES_FOR_NDS_IDS_CHANGED,
   LOCATION_SDS_CITY_HAS_STREETS_CHANGED,
   LOCATION_BASIC_DETAILS_AVAILABLE = 240, // deprecated
   LOCATION_BASIC_DETAILS_ERROR, // deprecated
   LOCATION_ATTRIBUTES_AVAILABLE,
   LOCATION_ATTRIBUTES_ERROR,
   LOCATION_IMAGE_INFO_AVAILABLE,
   LOCATION_COORDINATE_RESOLVED = 250,
   LOCATION_COORDINATE_RESOLVE_FAILED,
   LOCATION_ONLINE_SEARCH_AVAILABILITY_CHANGED, // JPN Specific
   LOCATION_ADDRESS_FORMAT_AVAILABLE,
   LOCATION_ADDRESS_INFOS_BASED_ON_POSITION_CHANGED,
   LOCATION_REFRESH_STATUS_CHANGED,
   //<-- INF4CV
   LOCATION_UPOIS_IMPORT_STATUS_CHANGED = 260,
   LOCATION_UPOIS_DELETED,
   //->

   MAP_PRESENTATION_MODE_CHANGED = 300,
   MAP_CAMERAINFOS_CHANGED,
   MAP_VIEWSTATUS_CHANGED,
   MAP_PICKING_RESULTS_AVAILABLE,
   MAP_PICKING_DETAIL_RESULT_AVAILABLE,
   MAP_CAMERAMODE_CHANGED,
   MAP_SHOW_TM_DETAIL_CHANGED,
   MAP_TOUCH_EVENT,
   MAP_NOMINAL_SCALES_CHANGED,
   MAP_SET_MAP_CAMERA_AND_VIEW_MODES_DONE,
   MAP_SHOW_INTERSECTION_MAP_CHANGED,
   MAP_INTERSECTION_MAP_VECTOR_DATA_CHANGED,
   MAP_USER_POI_ICONS_AVAILABLE,
   MAP_INTERSECTION_MAP_CARSOR_POSITION_CHANGED,
   MAP_WEATHER_FEATURES_STATUS_CHANGED,
   MAP_PICKING_RESULTS_DISTANCE_UPDATE,
   MAP_SETTINGS_POI_CATEGORIES_UPDATED,
   MAP_AVOIDAREA_HMI_OVERLAY_INFO_CHANGED,
   MAP_TRANSFORMED_VIEW_POSITIONS_AVAILABLE,
   MAP_STREET_VIEW_PREVIEW_IMAGE_AVAILABLE,
   MAP_PREPARE_SATELLITE_VIEW_STATUS_CHANGED,
   MAP_PICKED_INDEX_FROM_POI_ICONS_CHANGED,
   MAP_RECOMMENDED_SCALE_RANGE_CHANGED,
   MAP_PREPARE_STREET_VIEW_STATUS_CHANGED,
   MAP_ONLINE_FEATURE_AVAILABILITY_CHANGED,
   MAP_VIDEO_STREAM_STATUS_CHANGED,
   MAP_CAPTURE_RESULT_AVAILABLE,
   MAP_DYNAMICICON_REQUEST_RESULT_AVAILABLE,
   MAP_ADD_DYNAMIC_AREA_USER_STYLE_RESULT_AVAILABLE,

   POSITION_INFO_CHANGED = 400,
   POSITION_SIMULATION_MODE_CHANGED,
   POSITION_SENSORINFO_CHANGED,
   POSITION_STATUS_CHANGED,
   POSITION_WHERE_AM_I_CHANGED,
   POSITION_TRIP_REPLAY_STATUS_CHANGED,
   POSITION_QUALITY_CHANGED,
   POSITION_RNW_DATA_AVAILABILITY_CHANGED,
   POSITION_VEHICLE_MOVING_STATE_CHANGED,
   POSITION_HOME_POSITION_STATUS_CHANGED,
   POSITION_TRIP_RECORDING_STATUS_CHANGED,
   POSITION_DEBUG_INFO_CHANGED,

   ROUTE_ARRIVALINFOS_CHANGED = 500,
   ROUTE_ARRIVALINFOS_ALTERNATIVES_CHANGED,
   ROUTE_WAYPOINTINFOS_CHANGED,
   ROUTE_SETTINGS_CHANGED,
   ROUTE_TRAFFICIMPACT_ALTERNATIVE_CHANGED,
   ROUTE_DESTINATIONS_CHANGED,
   ROUTE_LIST_INFO_CHANGED,
   ROUTE_LIST_ERROR,
   ROUTE_LIST_INVALIDATE,
   ROUTE_PRE_CALCULATION_STARTED,
   ROUTE_CALCULATION_STARTED,
   ROUTE_CALCULATION_STOPPED,
   ROUTE_CALCULATION_INFO_CHANGED,
   ROUTE_JAMAHEADINFO_CHANGED,
   ROUTE_STATUS_CHANGED,
   ROUTE_LEARNED_ROUTES_DELETED,
   ROUTE_OPENING_HOURS_REACHABILITY_INDICATION,
   ROUTE_COUNTRY_AND_STATE_INFO_CHANGED,
   ROUTE_RESTRICTION_AVOIDED,
   ROUTE_LCV_RESTRICTION_VIOLATION_STATUS_CHANGED,
   ROUTE_SHAPE_POINTS_AVAILABILITY_CHANGED,
   ROUTE_SHAPE_POINTS_INFO_CHANGED,
   //<-- INF4CV
   ROUTE_HARDPHYSICAL_RESTRICTION_VIOLATION_STATUS_CHANGED,
   ROUTE_HARDGENERAL_RESTRICTION_VIOLATION_STATUS_CHANGED,
   ROUTE_SOFTPHYSICAL_RESTRICTION_VIOLATION_STATUS_CHANGED,
   //->
   ROUTE_RANGEPREDICTION_INFO_CHANGED = 550,
   ROUTE_AUTOMATIC_CHARGING_STATION_DETECTION_INFO_CHANGED,
   ROUTE_AUTOMATIC_CHARGING_STATION_DETECTION_INVALIDATE,
   ROUTE_PRE_CALCULATION_WITH_AUTOMATIC_CHARGING_STATIONS_STATUS_CHANGED,
   ROUTE_APPROACHING_CHARGING_STATION,

   TRAFFICMESSAGE_INFO_LIST_CHANGED = 600,
   TRAFFICMESSAGE_INFO_DETAILS_CHANGED,
   TRAFFICMESSAGE_LIST_INVALIDATE,
   TRAFFICMESSAGE_INDEX_CHANGED,
   TRAFFICMESSAGE_XURGENT_CHANGED,
   TRAFFICMESSAGE_RECEPTION_STATUS_CHANGED,
   TRAFFICMESSAGE_ICONFILTER_LIST_CHANGED,
   TRAFFICMESSAGE_SETTINGS_CHANGED,
   TRAFFICMESSAGE_DETOUR_RESULT_CHANGED,

   DESTINATIONMEMORY_LAST_DESTINATION_LIST_CHANGED = 700,
   DESTINATIONMEMORY_HOME_LIST_CHANGED,
   DESTINATIONMEMORY_WORK_LIST_CHANGED,
   DESTINATIONMEMORY_ADDR_BOOK_LIST_CHANGED,
   DESTINATIONMEMORY_ADDRESS_GADGET_LIST_CHANGED,
   DESTINATIONMEMORY_PERSONAL_EPOI_LIST_CHANGED,
   DESTINATIONMEMORY_FAVORITE_WEATHER_ALERTS_LIST_CHANGED,
   DESTINATIONMEMORY_STORE_ENTRY_STATUS_CHANGED,
   DESTINATIONMEMORY_ENTRY_DETAILS_AVAILABLE,
   DESTINATIONMEMORY_ENTRY_POSITION_CHANGED,
   DESTINATIONMEMORY_HOME_ENTRY_REMOVED,
   DESTINATIONMEMORY_WORK_ENTRY_REMOVED,
   DESTINATIONMEMORY_ADDR_BOOK_ENTRY_REMOVED,
   DESTINATIONMEMORY_LAST_DESTINATION_LIST_ITEM_REMOVED,
   DESTINATIONMEMORY_LAST_DESTINATION_LIST_STATUS_CHANGED,
   DESTINATIONMEMORY_ADDRESSBOOK_STATUS_CHANGED,
   DESTINATIONMEMORY_STORED_ROUTES_LIST_CHANGED,
   DESTINATIONMEMORY_STORE_ROUTE_STATUS_CHANGED,
   DESTINATIONMEMORY_ROUTE_REMOVED,
   DESTINATIONMEMORY_ROUTE_DETAILS_AVAILABLE,
   DESTINATIONMEMORY_ROUTE_MODIFIED,
   DESTINATIONMEMORY_LAST_DEPARTURE_CHANGED,
   DESTINATIONMEMORY_LAST_DEPARTURE_REMOVED,
   DESTINATIONMEMORY_UPDATE_LAST_DESTINATIONS_STATUS_CHANGED,
   DESTINATIONMEMORY_INSERT_LAST_DESTINATIONS_STATUS_CHANGED,
   DESTINATIONMEMORY_STORE_ENTRIES_STATUS_CHANGED,
   DESTINATIONMEMORY_LAST_DESTINATIONS_HISTORY_AVAILABLE,
   DESTINATIONMEMORY_SELECTION_STATUS_CHANGED,
   DESTINATIONMEMORY_ADDRESSBOOK_USED_GROUPS_CHANGED,

   NAVDATAUPDATE_UPDATE_LIST_CHANGED = 800,
   NAVDATAUPDATE_UPDATE_STATUS_CHANGED,
   NAVDATAUPDATE_UPDATE_INFO_CHANGED,
   NAVDATAUPDATE_INSTALLATION_STARTED,
   NAVDATAUPDATE_COMPATIBILITY_CHANGED,
   NAVDATAUPDATE_DEVICE_STATUS_CHANGED,
   NAVDATAUPDATE_UPDATE_PREPARATION_STATUS_CHANGED,
   NAVDATAUPDATE_VERSION_INFO_CHANGED,
   NAVDATAUPDATE_UPDATE_SELECTION_STATUS_CHANGED,
   NAVDATAUPDATE_COMPONENT_INSTALL_RESULT_CHANGED,
   NAVDATAUPDATE_COMPONENT_DEINSTALL_RESULT_CHANGED,
   NAVDATAUPDATE_COMPONENT_STATUS_CHANGED,
   NAVDATAUPDATE_CONTEXT_CHANGED,
   NAVDATAUPDATE_NAVDATA_STATUS_CHANGED,
   NAVDATAUPDATE_FAVORITE_REGION_SETTINGS_CHANGED,
   NAVDATAUPDATE_UPDATE_FAVORITE_REGION_SETTINGS_RESULT_CHANGED,
   NAVDATAUPDATE_AVAILABLE_SCOMO_UPDATE_INFO_CHANGED,
   NAVDATAUPDATE_CATALOGUE_STATUS_CHANGED,
   NAVDATAUPDATE_PART_NUMBER_INFO_CHANGED,
   NAVDATAUPDATE_DATASET_INFO_CHANGED,
   NAVDATAUPDATE_DATASET_USER_REG_CHANGED,
   NAVDATAUPDATE_UPDATE_HISTORY_CHANGED,
   NAVDATAUPDATE_AUTOMATIC_MAP_UPDATE_STATUS_CHANGED,
   NAVDATAUPDATE_AUTOMATIC_MAP_UPDATE_STATUS_RESULT_CHANGED,
   NAVDATAUPDATE_AUTOMATIC_FULL_UPDATE_STATUS_CHANGED,
   NAVDATAUPDATE_INVENTORY_INFO_CHANGED,

   CONFIGURATION_AVOID_AREA_LIST_CHANGED = 900,
   CONFIGURATION_SET_CONFIG_RESULT,
   CONFIGURATION_NAVIGATION_VERSION_CHANGED,
   CONFIGURATION_E2E_STATUS_CHANGED,

   ENGINEERING_MENU_CHANGED = 1000,
   ENGINEERING_DEBUG_INFO_CHANGED,

   SAFETY_SETTINGS_CHANGED = 1100,
   SAFETY_SAFE_DRIVING_EVENT_FLAGS_CHANGED,

   ETC_LANEGUIDANCE_INFO_CHANGED = 1200,
   ETC_LANEGUIDANCE_STATUS_CHANGED,
   ETC_INTERRUPT_OCCURED, //When interrupt event occurs
   ETC_TOLL_SUM_DATA_CHANGED, //After requestEtcTollSumData OR resetEtcTollSumData
   ETC_USAGE_DATA_HISTORY_LIST_STATUS_CHANGED, //After requestEtcUsageDataHistoryList OR cancelEtcUsageDataHistoryListRequest
   ETC_SETTINGS_CHANGED, //When ETC settings are applied
   ETC_SETUP_INFORMATION_CHANGED, //After requestEtcSetupInformation OR if setup information changes
   ETC_SETUP_STATUS_CHANGED, //When the setup status of the ETC device changed
   ETC_CARD_INSERT_STATUS_CHANGED,

   HIGHWAY_LIST_INFO_CHANGED = 1300,
   HIGHWAY_LIST_INFO_INVALIDATE, //When highway list changed completely[JP]
   HIGHWAY_LIST_HIGHWAY_ENTRY_EXIT_AVAILABLE,
   HIGHWAY_LIST_REQUESTED_HIGHWAY_ELEMENT_LIST_AVAILABLE,
   HIGHWAY_LIST_REQUESTED_HIGHWAY_ELEMENT_LIST_INVALID,

   VICS_SOURCES_CHANGED = 1400,
   VICS_PAGE_UPDATED,
   VICS_HISTORY_CHANGED,
   VICS_SETTINGS_CHANGED,
   VICS_AVAILABLE_PAGE_LIST_CHANGED,
   VICS_EMERGENCY_MESSAGE_LATEST_LIST_CHANGED,
   VICS_EMERGENCY_MESSAGE_HISTORY_LIST_CHANGED,
   CARWINGS_REQUEST_DATA_CHANGED,
   TRAFFIC_INFO_DETOUR_ROUTE_DATA_CHANGED,
   VICS_FM_INFO_AREA_LIST_CHANGED,
   VICS_PARKING_INFO_CHANGED, //[JP]

   WEATHER_DATA_CHANGED = 1500,
   WEATHER_DATA_RECEPTION_STATE_CHANGED,
   LOCATION_BASED_SERVICES_SETTINGS_CHANGED,
   ONLINE_SERVICES_DIAGNOSTIC_INFO_UPDATED,
   CONNECTED_SERVICES_AVAILABILITY_CHANGED,

   ROUTE_SPLIT_TURN_LIST_INFO_CHANGED = 1600, //[JP]
   ROUTE_SPLIT_TURN_LIST_INFO_INVALIDATE,      //[JP]

   SETTINGS_RESTORE_STATUS_CHANGED = 1700,

   USER_PROFILE_STATUS_CHANGED = 1800,

   ELECTRICVEHICLE_EPOI_DETECTED = 1900,
   ELECTRICVEHICLE_BATTERY_CHARGING_INFO_CHANGED,
   ELECTRICVEHICLE_CHARGING_SPOT_LIST_REQUEST,         // data for triggering request id 0x0115 download from telematics/carwings is prepared
   ELECTRICVEHICLE_CHARGING_SPOT_DATA_REQUEST,         // same for request id 0x0114
   ELECTRICVEHICLE_VACANCY_DISTRIBUTION_DATA_REQUEST,  // same for request id 0x0119
   ELECTRICVEHICLE_VACANCY_SPOT_DATA_REQUEST,          // same for request id 0x0118
   ELECTRICVEHICLE_ONLINE_POI_DB_UPDATED,              // the manual area update is finished
   ELECTRICVEHICLE_SETTINGS_CHANGED,                   // the settings were changed by user or read from persistency
   ELECTRICVEHICLE_VACANCY_DATA_CHANGED,               // the vacancy data of an availability search has changed. The POI list can be requested, including details.
   ELECTRICVEHICLE_VACANCY_DATA_ATTRIBUTES_AVAILABLE,  // for consistency with LOCATION_POI_ENTRY_ATTRIBUTES_AVAILABLE
   ELECTRICVEHICLE_VACANCY_DATA_ENTRIES_CHANGED,       // for consistency with LOCATION_POI_ENTRIES_CHANGED
   ELECTRICVEHICLE_VACANCY_DATA_AVAILABILITY_CHANGED   // getVacancyDataAvailability
};

} // namespace navmiddleware

#endif  // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_CALLBACK_PROPERTYIDENTIFIERS_H_
