/**
 * @copyright (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 * @addtogroup NavMiddleware
 * @{
 */

#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INFO_DIAGNOSTICINFOS_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INFO_DIAGNOSTICINFOS_H_

#include <string>
#include <vector>
#include "InfoTypes.h"

namespace navmiddleware
{
class OnlineServicesDiagnosticInfos
{
public:
   OnlineServicesDiagnosticInfos() {}

   ~OnlineServicesDiagnosticInfos() {}

   void setTLSErrorServicesList(const ::std::vector< ConnectedService >& tlsErrorServicesList)
   {
      m_tlsErrorServicesList = tlsErrorServicesList;
   }
   /* provides the list of connected services affected by Transport Layer Security(TLS) error */
   const ::std::vector< ConnectedService >& getTLSErrorServicesList() const
   {
      return m_tlsErrorServicesList;
   }

   void setCertificateErrorServicesList(const ::std::vector< ConnectedService >& certificateErrorServicesList)
   {
      m_certificateErrorServicesList = certificateErrorServicesList;
   }
   /* provides the list of connected services affected by Certificate error */
   const ::std::vector< ConnectedService >& getCertificateErrorServicesList() const
   {
      return m_certificateErrorServicesList;
   }

   ::std::string toString() const
   {
      ::std::stringstream stream;
      stream << "OnlineServicesDiagnosticInfos payload:" << ::std::endl
             << "\tm_tlsErrorServicesList: " << ::std::endl;

      for (size_t index = 0; index < m_tlsErrorServicesList.size(); ++index)
      {
         stream << "\t-> " << ::navmiddleware::toString(m_tlsErrorServicesList[index]) << ::std::endl;
      }
      stream << "\tm_certificateErrorServicesList: " << ::std::endl;
      for (size_t index = 0; index < m_certificateErrorServicesList.size(); ++index)
      {
         stream << "\t-> " << ::navmiddleware::toString(m_certificateErrorServicesList[index]) << ::std::endl;
      }

      return stream.str();
   }

   bool operator==(const OnlineServicesDiagnosticInfos& rhs) const
   {
      return (m_tlsErrorServicesList == rhs.m_tlsErrorServicesList) &&
             (m_certificateErrorServicesList == rhs.m_certificateErrorServicesList);
   }

   bool operator!=(const OnlineServicesDiagnosticInfos& rhs) const
   {
      return !(*this == rhs);
   }

private:
   ::std::vector< ConnectedService > m_tlsErrorServicesList;
   ::std::vector< ConnectedService > m_certificateErrorServicesList;
};

} // namespace navmiddleware


#endif  // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INFO_DIAGNOSTICINFOS_H_
