/**
* @copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* @addtogroup NavMiddleware
* @{
*/

#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INFO_CONNECTEDSERVICESINFOS_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INFO_CONNECTEDSERVICESINFOS_H_

#include <string>
#include <vector>
#include "InfoTypes.h"

namespace navmiddleware
{
enum CountrySpecificAvailabilityStatus
{
   COUNTRY_SPECIFIC_AVAILABILITY_STATUS__UNKNOWN,
   COUNTRY_SPECIFIC_AVAILABILITY_STATUS__AVAILABLE,
   COUNTRY_SPECIFIC_AVAILABILITY_STATUS__UNAVAILABLE,
   COUNTRY_SPECIFIC_AVAILABILITY_STATUS__UNSPECIFIED_BY_SERVER
};

enum SubscriptionStatus
{
   SUBSCRIPTION_STATUS__UNKNOWN, // Data still not available either from vNext or persistence not yet read.
   SUBSCRIPTION_STATUS__SUBSCRIBED, // Config Item Value ON
   SUBSCRIPTION_STATUS__NOT_PROVIDED, //Config Item Value OFF
   SUBSCRIPTION_STATUS__NOT_SUBSCRIBED // Config Item Value NOT_SUBSCRIBED
};

inline ::std::string toString(CountrySpecificAvailabilityStatus countrySpecificAvailabilityStatus)
{
   switch(countrySpecificAvailabilityStatus)
   {
   case COUNTRY_SPECIFIC_AVAILABILITY_STATUS__UNKNOWN:
      return "COUNTRY_SPECIFIC_AVAILABILITY_STATUS__UNKNOWN";
   case COUNTRY_SPECIFIC_AVAILABILITY_STATUS__AVAILABLE:
      return "COUNTRY_SPECIFIC_AVAILABILITY_STATUS__AVAILABLE";
   case COUNTRY_SPECIFIC_AVAILABILITY_STATUS__UNAVAILABLE:
      return "COUNTRY_SPECIFIC_AVAILABILITY_STATUS__UNAVAILABLE";
   case COUNTRY_SPECIFIC_AVAILABILITY_STATUS__UNSPECIFIED_BY_SERVER:
      return "COUNTRY_SPECIFIC_AVAILABILITY_STATUS__UNSPECIFIED_BY_SERVER";
   default:
      ::std::stringstream stream;
      stream << "COUNTRY_SPECIFIC_AVAILABILITY_STATUS__<" << static_cast<unsigned int>(countrySpecificAvailabilityStatus) << ">";
      return stream.str();
   }
}

inline ::std::string toString(SubscriptionStatus subscriptionStatus)
{
   switch(subscriptionStatus)
   {
   case SUBSCRIPTION_STATUS__UNKNOWN:
      return "SUBSCRIPTION_STATUS__UNKNOWN";
   case SUBSCRIPTION_STATUS__SUBSCRIBED:
      return "SUBSCRIPTION_STATUS__SUBSCRIBED";
   case SUBSCRIPTION_STATUS__NOT_PROVIDED:
      return "SUBSCRIPTION_STATUS__NOT_PROVIDED";
   case SUBSCRIPTION_STATUS__NOT_SUBSCRIBED:
      return "SUBSCRIPTION_STATUS__NOT_SUBSCRIBED";
   default:
      ::std::stringstream stream;
      stream << "SUBSCRIPTION_STATUS__<" << static_cast<unsigned int>(subscriptionStatus) << ">";
      return stream.str();
   }
}

/*
 * Class contains the country specific availability and subscription status only for TPEG services
 */
class ConnectedServiceAvailabilityInfo
{
public:
   ConnectedServiceAvailabilityInfo()
      : m_connectedService(CONNECTED_SERVICE__UNKNOWN)
      , m_countrySpecificAvailabilityStatus(COUNTRY_SPECIFIC_AVAILABILITY_STATUS__UNKNOWN)
      , m_subscriptionStatus(SUBSCRIPTION_STATUS__UNKNOWN)
   {}
   ~ConnectedServiceAvailabilityInfo() {}

   void setConnectedService(ConnectedService connectedService)
   {
      m_connectedService = connectedService;
   }

   ConnectedService getConnectedService() const
   {
      return m_connectedService;
   }

   void setCountrySpecificAvailabilityStatus(CountrySpecificAvailabilityStatus countrySpecificAvailabilityStatus)
   {
      m_countrySpecificAvailabilityStatus = countrySpecificAvailabilityStatus;
   }

   CountrySpecificAvailabilityStatus getCountrySpecificAvailabilityStatus() const
   {
      return m_countrySpecificAvailabilityStatus;
   }

   void setSubscriptionStatus(SubscriptionStatus subscriptionStatus)
   {
      m_subscriptionStatus = subscriptionStatus;
   }

   SubscriptionStatus getSubscriptionStatus() const
   {
      return m_subscriptionStatus;
   }

   bool operator==(const ConnectedServiceAvailabilityInfo& rhs) const
   {
      return (m_connectedService == rhs.m_connectedService) &&
             (m_countrySpecificAvailabilityStatus == rhs.m_countrySpecificAvailabilityStatus) &&
             (m_subscriptionStatus == rhs.m_subscriptionStatus);
   }

   bool operator!=(const ConnectedServiceAvailabilityInfo& rhs) const
   {
      return !(*this == rhs);
   }

   ::std::string toString() const
   {
      ::std::stringstream stream;
      stream << "\tm_connectedService" << ::navmiddleware::toString(m_connectedService) << ::std::endl
             <<"\tm_countrySpecificAvailabilityStatus" << ::navmiddleware::toString(m_countrySpecificAvailabilityStatus) <<::std::endl
             <<"\tm_subscriptionStatus" << ::navmiddleware::toString(m_subscriptionStatus) <<::std::endl;
      return stream.str();
   }

private:
   ConnectedService                     m_connectedService;
   CountrySpecificAvailabilityStatus    m_countrySpecificAvailabilityStatus;
   SubscriptionStatus                   m_subscriptionStatus;
};

class ConnectedServicesAvailabilityInfos
{
public:
   ConnectedServicesAvailabilityInfos() {}

   ~ConnectedServicesAvailabilityInfos() {}

   void setConnectedServicesAvailabilityInfos(const ::std::vector< ConnectedServiceAvailabilityInfo >& connectedServicesAvailabilityInfos)
   {
      m_ConnectedServicesAvailabilityInfos = connectedServicesAvailabilityInfos;
   }

   const ::std::vector< ConnectedServiceAvailabilityInfo >& getConnectedServicesAvailabilityInfos() const
   {
      return m_ConnectedServicesAvailabilityInfos;
   }

   void setCountryCode(const ::std::string& countryCode)
   {
      m_isoCountryCode = countryCode;
   }

   const ::std::string& getCountryCode() const
   {
      return m_isoCountryCode;
   }

   bool operator==(const ConnectedServicesAvailabilityInfos& rhs) const
   {
      return (m_isoCountryCode == rhs.m_isoCountryCode)&&
             (m_ConnectedServicesAvailabilityInfos == rhs.m_ConnectedServicesAvailabilityInfos);
   }

   bool operator!=(const ConnectedServicesAvailabilityInfos& rhs) const
   {
      return !(*this == rhs);
   }

   ::std::string toString() const
   {
      ::std::stringstream stream;
      stream
            <<"\tm_countryCode" << m_isoCountryCode << ::std::endl
            << "ConnectedServicesAvailabilityInfos payload:" << ::std::endl;

      for(size_t i = 0; i < m_ConnectedServicesAvailabilityInfos.size(); i++)
      {
         stream << "\t-> " << m_ConnectedServicesAvailabilityInfos[i].toString();
      }
      return stream.str();
   }

private:
   ::std::vector< ConnectedServiceAvailabilityInfo > m_ConnectedServicesAvailabilityInfos;
   // country code returned as ISO 3166-1-alpha-3.
   ::std::string m_isoCountryCode;
};

} // namespace navmiddleware

#endif  // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_INFO_CONNECTEDSERVICESINFOS_H_
