/* ***************************************************************************************
* FILE:          gui_std_if.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  gui_std_if.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __gui_std_if_
#define __gui_std_if_

#include <hmibase/sys_std_if.h>
#include <hmibase/trace/Trace.h>
#define VIEW_INCLUDES__GUI_SUPPORT
#include "View/view_includes.h"
#include "View/IMessageSystem.h"
#include <hmibase/util/StringUtils.h>
#include <hmibase/app/util/Util.h>

#ifdef HMI_APPLICATION
#include "Project.h"
#endif

#ifdef WIN32_WARNINGS_STRICT
#pragma warning(4: 4365)
#pragma warning(4: 4018)
#pragma warning(4: 4244)
#pragma warning(4: 4244)
#pragma warning(4: 4191)
#pragma warning(4: 4242)
#pragma warning(4: 4265)
#endif

#else
#error "Please include gui_std_if.h allways first and once a time in your GUI cpp file, but never in a header file!"
#endif
