#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_CM_ASF_LANG_DBUS_CONNECTORS_H
#define COM_BOSCH_CM_ASF_LANG_DBUS_CONNECTORS_H

#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "Connectors" isn't clear, then there should be a description here.
 */

namespace com {
namespace bosch {
namespace cm {
namespace asf {
namespace lang {
namespace dbus {
namespace Connectors {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class DBusConnector;


/**
 * The DBusConenctor connects ASF to the D-Bus.
 */
class DBusConnector {
public:

    typedef DBusConnector_BusType BusType;

    static const BusType BusType__Session = DBusConnector_BusType__Session;
    static const BusType BusType__System = DBusConnector_BusType__System;
    static const BusType BusType__Address = DBusConnector_BusType__Address;

    static inline const char* BusType_Name(BusType value) {
        return DBusConnector_BusType_Name(value);
    }

    static inline bool BusType_Parse(const char *str, size_t length, BusType &value) {
        return DBusConnector_BusType_Parse(str, length, value);
    }

    static inline bool BusType_IsValid(BusType value) {
        return DBusConnector_BusType_IsValid(value);
    }

    typedef DBusConnector_DispatchingStrategy DispatchingStrategy;

    static const DispatchingStrategy DispatchingStrategy__Polling = DBusConnector_DispatchingStrategy__Polling;
    static const DispatchingStrategy DispatchingStrategy__FileDescriptorWakeUp = DBusConnector_DispatchingStrategy__FileDescriptorWakeUp;

    static inline const char* DispatchingStrategy_Name(DispatchingStrategy value) {
        return DBusConnector_DispatchingStrategy_Name(value);
    }

    static inline bool DispatchingStrategy_Parse(const char *str, size_t length, DispatchingStrategy &value) {
        return DBusConnector_DispatchingStrategy_Parse(str, length, value);
    }

    static inline bool DispatchingStrategy_IsValid(DispatchingStrategy value) {
        return DBusConnector_DispatchingStrategy_IsValid(value);
    }

    /**
     * Default constructor
     */
    inline  DBusConnector ();

    /**
     * Copy constructor
     */
    inline  DBusConnector (const DBusConnector &rhs);

    /**
     * All fields constructor
     */
    inline  DBusConnector (DBusConnector_DispatchingStrategy dispatchingStrategy_, uint32 pollingTimeout_, DBusConnector_BusType busType_, const ::std::string& address_, const ::std::string& busName_, uint32 connectionReattemptInterval_, uint32 connectionAttemptWarningThreshold_);

    /**
     * Destructor
     */
    inline  ~DBusConnector();

    /**
     * Assignment operator
     */
    inline DBusConnector& operator = (const DBusConnector& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DBusConnector& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DBusConnector& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DBusConnector& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DBusConnector& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dispatchingStrategy"

    static const int kDispatchingStrategy = 0;

    /**
     * Clears the field "dispatchingStrategy".
     *
     * The field will be set to its default value. The hasDispatchingStrategy()
     * method will return false.
     */
    inline void clearDispatchingStrategy();

    /**
     * Checks whether the field "dispatchingStrategy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDispatchingStrategy()). Otherwise it will return false.
     */
    inline bool hasDispatchingStrategy () const;

    /**
     * Returns the value of the member "dispatchingStrategy".
     *
     * If the meaning of "dispatchingStrategy" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dispatchingStrategy"
     */
    inline DBusConnector_DispatchingStrategy getDispatchingStrategy () const;

    /**
     * Sets the value of the member "dispatchingStrategy".
     *
     * If the meaning of "dispatchingStrategy" isn't clear, then there should be a description here.
     *
     * @param dispatchingStrategy The value which will be set
     */
    inline void setDispatchingStrategy (DBusConnector_DispatchingStrategy dispatchingStrategy_);

    // API of field "pollingTimeout"

    static const int kPollingTimeout = 1;

    /**
     * Clears the field "pollingTimeout".
     *
     * The field will be set to its default value. The hasPollingTimeout()
     * method will return false.
     */
    inline void clearPollingTimeout();

    /**
     * Checks whether the field "pollingTimeout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPollingTimeout()). Otherwise it will return false.
     */
    inline bool hasPollingTimeout () const;

    /**
     * Returns the value of the member "pollingTimeout".
     *
     * The polling timeout (ms) for the dispatching strategy 'Polling'. The default value is 10ms.
     *
     * @return The value of the field "pollingTimeout"
     */
    inline uint32 getPollingTimeout () const;

    /**
     * Sets the value of the member "pollingTimeout".
     *
     * The polling timeout (ms) for the dispatching strategy 'Polling'. The default value is 10ms.
     *
     * @param pollingTimeout The value which will be set
     */
    inline void setPollingTimeout (uint32 pollingTimeout_);

    // API of field "busType"

    static const int kBusType = 2;

    /**
     * Clears the field "busType".
     *
     * The field will be set to its default value. The hasBusType()
     * method will return false.
     */
    inline void clearBusType();

    /**
     * Checks whether the field "busType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBusType()). Otherwise it will return false.
     */
    inline bool hasBusType () const;

    /**
     * Returns the value of the member "busType".
     *
     * The mandatory field 'busType' must be set to connect to the given bus type, e.g. the
     * well-known bus types Session and System or to a provided address.
     *
     * @return The value of the field "busType"
     */
    inline DBusConnector_BusType getBusType () const;

    /**
     * Sets the value of the member "busType".
     *
     * The mandatory field 'busType' must be set to connect to the given bus type, e.g. the
     * well-known bus types Session and System or to a provided address.
     *
     * @param busType The value which will be set
     */
    inline void setBusType (DBusConnector_BusType busType_);

    // API of field "address"

    static const int kAddress = 3;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the bus type 'Address' is chosen the 'address' field must be set to specify the bus address.
     * The address can be either given as a string which follows the D-Bus specification
     * http://dbus.freedesktop.org/doc/dbus-specification.html#addresses
     * E.g. "unix:path=/tmp/dbus-test"
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the bus type 'Address' is chosen the 'address' field must be set to specify the bus address.
     * The address can be either given as a string which follows the D-Bus specification
     * http://dbus.freedesktop.org/doc/dbus-specification.html#addresses
     * E.g. "unix:path=/tmp/dbus-test"
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * If the bus type 'Address' is chosen the 'address' field must be set to specify the bus address.
     * The address can be either given as a string which follows the D-Bus specification
     * http://dbus.freedesktop.org/doc/dbus-specification.html#addresses
     * E.g. "unix:path=/tmp/dbus-test"
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * If the bus type 'Address' is chosen the 'address' field must be set to specify the bus address.
     * The address can be either given as a string which follows the D-Bus specification
     * http://dbus.freedesktop.org/doc/dbus-specification.html#addresses
     * E.g. "unix:path=/tmp/dbus-test"
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    /**
     * Release the object stored in the field "address".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "address"
     */
    inline ::std::string* releaseAddress();

    /**
     * Replace the field "address".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceAddress (::std::string* address_);

    // API of field "busName"

    static const int kBusName = 4;

    /**
     * Clears the field "busName".
     *
     * The field will be set to its default value. The hasBusName()
     * method will return false.
     */
    inline void clearBusName();

    /**
     * Checks whether the field "busName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBusName()). Otherwise it will return false.
     */
    inline bool hasBusName () const;

    /**
     * Returns the value of the member "busName".
     *
     * The field 'busName' can be used to explicitly set the well-known bus name for the D-Bus connection.
     * Please consider the rules for valid bus names:
     * https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names
     *
     * The bus name is set to "<application.package>.<application.name>" by default.
     *
     * @return The value of the field "busName"
     */
    inline const ::std::string& getBusName () const;

    /**
     * Retrieves the value of the field "busName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "busName".
     */
    inline ::std::string& getBusNameMutable ();

    /**
     * Sets the value of the member "busName".
     *
     * The field 'busName' can be used to explicitly set the well-known bus name for the D-Bus connection.
     * Please consider the rules for valid bus names:
     * https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names
     *
     * The bus name is set to "<application.package>.<application.name>" by default.
     *
     * @param busName The value which will be set
     */
    inline void setBusName (const ::std::string& busName_);

    /**
     * Sets the value of the member "busName".
     *
     * The field 'busName' can be used to explicitly set the well-known bus name for the D-Bus connection.
     * Please consider the rules for valid bus names:
     * https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names
     *
     * The bus name is set to "<application.package>.<application.name>" by default.
     *
     * @param busName The value which will be set
     */
    inline void setBusName (const char* busName_);

    /**
     * Sets the value of the member "busName".
     *
     * The field 'busName' can be used to explicitly set the well-known bus name for the D-Bus connection.
     * Please consider the rules for valid bus names:
     * https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names
     *
     * The bus name is set to "<application.package>.<application.name>" by default.
     *
     * @param busName The value which will be set
     */
    inline void setBusName (const char* value, size_t size);

    /**
     * Release the object stored in the field "busName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "busName"
     */
    inline ::std::string* releaseBusName();

    /**
     * Replace the field "busName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceBusName (::std::string* busName_);

    // API of field "connectionReattemptInterval"

    static const int kConnectionReattemptInterval = 5;

    /**
     * Clears the field "connectionReattemptInterval".
     *
     * The field will be set to its default value. The hasConnectionReattemptInterval()
     * method will return false.
     */
    inline void clearConnectionReattemptInterval();

    /**
     * Checks whether the field "connectionReattemptInterval" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionReattemptInterval()). Otherwise it will return false.
     */
    inline bool hasConnectionReattemptInterval () const;

    /**
     * Returns the value of the member "connectionReattemptInterval".
     *
     * Specifies the interval in milli-seconds between connection attempts.
     *
     * When a connection can not be established the connector waits for the
     * given interval and runs a new connection attempt.
     *
     * Whenever a connection is lost a reconnect attempt is initiated immediately
     * (unless the connectionReattemptInterval is set to 0).
     *
     * If the value is 0 then no connection re-attempt will be performed.
     *
     * @return The value of the field "connectionReattemptInterval"
     */
    inline uint32 getConnectionReattemptInterval () const;

    /**
     * Sets the value of the member "connectionReattemptInterval".
     *
     * Specifies the interval in milli-seconds between connection attempts.
     *
     * When a connection can not be established the connector waits for the
     * given interval and runs a new connection attempt.
     *
     * Whenever a connection is lost a reconnect attempt is initiated immediately
     * (unless the connectionReattemptInterval is set to 0).
     *
     * If the value is 0 then no connection re-attempt will be performed.
     *
     * @param connectionReattemptInterval The value which will be set
     */
    inline void setConnectionReattemptInterval (uint32 connectionReattemptInterval_);

    // API of field "connectionAttemptWarningThreshold"

    static const int kConnectionAttemptWarningThreshold = 6;

    /**
     * Clears the field "connectionAttemptWarningThreshold".
     *
     * The field will be set to its default value. The hasConnectionAttemptWarningThreshold()
     * method will return false.
     */
    inline void clearConnectionAttemptWarningThreshold();

    /**
     * Checks whether the field "connectionAttemptWarningThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionAttemptWarningThreshold()). Otherwise it will return false.
     */
    inline bool hasConnectionAttemptWarningThreshold () const;

    /**
     * Returns the value of the member "connectionAttemptWarningThreshold".
     *
     * Specifies the number of failed connection attempts after which a warning
     * will be logged.
     *
     * The connector counts down the remaining connection attempts, starting at
     * "connectionAttemptWarningThreshold" (default value is 20).
     * If the connection is not established within the threshold, then a warning message
     * will be logged. The warning informs about the fact that a connection to the given
     * server could not be established. Then the counting starts again.
     *
     * If the value is 0 then no warning is logged.
     *
     * @return The value of the field "connectionAttemptWarningThreshold"
     */
    inline uint32 getConnectionAttemptWarningThreshold () const;

    /**
     * Sets the value of the member "connectionAttemptWarningThreshold".
     *
     * Specifies the number of failed connection attempts after which a warning
     * will be logged.
     *
     * The connector counts down the remaining connection attempts, starting at
     * "connectionAttemptWarningThreshold" (default value is 20).
     * If the connection is not established within the threshold, then a warning message
     * will be logged. The warning informs about the fact that a connection to the given
     * server could not be established. Then the counting starts again.
     *
     * If the value is 0 then no warning is logged.
     *
     * @param connectionAttemptWarningThreshold The value which will be set
     */
    inline void setConnectionAttemptWarningThreshold (uint32 connectionAttemptWarningThreshold_);

    static const DBusConnector &getDefaultInstance();

private:

    inline void set_has_dispatchingStrategy ();

    inline void clear_has_dispatchingStrategy ();

    inline void set_has_pollingTimeout ();

    inline void clear_has_pollingTimeout ();

    inline void set_has_busType ();

    inline void clear_has_busType ();

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_busName ();

    inline void clear_has_busName ();

    inline void set_has_connectionReattemptInterval ();

    inline void clear_has_connectionReattemptInterval ();

    inline void set_has_connectionAttemptWarningThreshold ();

    inline void clear_has_connectionAttemptWarningThreshold ();

    uint32 _has_bits_[ (7 + 31) / 32];

    DBusConnector_DispatchingStrategy _dispatchingStrategy;

    uint32 _pollingTimeout;

    DBusConnector_BusType _busType;

    ::std::string* _address;

    ::std::string* _busName;

    uint32 _connectionReattemptInterval;

    uint32 _connectionAttemptWarningThreshold;

};

inline  DBusConnector::DBusConnector ()  :
    _dispatchingStrategy (DBusConnector::DispatchingStrategy__FileDescriptorWakeUp),
    _pollingTimeout (10u),
    _busType (::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session),
    _address (NULL),
    _busName (NULL),
    _connectionReattemptInterval (500u),
    _connectionAttemptWarningThreshold (20u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DBusConnector::DBusConnector (const DBusConnector &rhs)  :
    _dispatchingStrategy (DBusConnector::DispatchingStrategy__FileDescriptorWakeUp),
    _pollingTimeout (10u),
    _busType (::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session),
    _address (NULL),
    _busName (NULL),
    _connectionReattemptInterval (500u),
    _connectionAttemptWarningThreshold (20u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DBusConnector::DBusConnector (DBusConnector_DispatchingStrategy dispatchingStrategy_, uint32 pollingTimeout_, DBusConnector_BusType busType_, const ::std::string& address_, const ::std::string& busName_, uint32 connectionReattemptInterval_, uint32 connectionAttemptWarningThreshold_)  :
    _dispatchingStrategy (dispatchingStrategy_),
    _pollingTimeout (pollingTimeout_),
    _busType (busType_),
    _address (new ::std::string(address_)),
    _busName (new ::std::string(busName_)),
    _connectionReattemptInterval (connectionReattemptInterval_),
    _connectionAttemptWarningThreshold (connectionAttemptWarningThreshold_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(DBusConnector_DispatchingStrategy_IsValid(dispatchingStrategy_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", dispatchingStrategy_, "DispatchingStrategy", "dispatchingStrategy", "DBusConnector");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(DBusConnector_BusType_IsValid(busType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", busType_, "BusType", "busType", "DBusConnector");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (busName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DBusConnector::~DBusConnector() {
    delete _address;
    delete _busName;
}

inline DBusConnector& DBusConnector::operator = (const DBusConnector& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDispatchingStrategy()) {
            setDispatchingStrategy(rhs.getDispatchingStrategy());
        } else {
            clearDispatchingStrategy();
        }
        if (rhs.hasPollingTimeout()) {
            setPollingTimeout(rhs.getPollingTimeout());
        } else {
            clearPollingTimeout();
        }
        if (rhs.hasBusType()) {
            setBusType(rhs.getBusType());
        } else {
            clearBusType();
        }
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasBusName()) {
            setBusName(rhs.getBusName());
        } else {
            clearBusName();
        }
        if (rhs.hasConnectionReattemptInterval()) {
            setConnectionReattemptInterval(rhs.getConnectionReattemptInterval());
        } else {
            clearConnectionReattemptInterval();
        }
        if (rhs.hasConnectionAttemptWarningThreshold()) {
            setConnectionAttemptWarningThreshold(rhs.getConnectionAttemptWarningThreshold());
        } else {
            clearConnectionAttemptWarningThreshold();
        }
    }
    return *this;
}

inline bool DBusConnector::operator == (const DBusConnector& rhs) const {
    return (((!hasDispatchingStrategy() && !rhs.hasDispatchingStrategy()) || getDispatchingStrategy() == rhs.getDispatchingStrategy()) &&
        ((!hasPollingTimeout() && !rhs.hasPollingTimeout()) || getPollingTimeout() == rhs.getPollingTimeout()) &&
        ((!hasBusType() && !rhs.hasBusType()) || getBusType() == rhs.getBusType()) &&
        ((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasBusName() && !rhs.hasBusName()) || getBusName() == rhs.getBusName()) &&
        ((!hasConnectionReattemptInterval() && !rhs.hasConnectionReattemptInterval()) || getConnectionReattemptInterval() == rhs.getConnectionReattemptInterval()) &&
        ((!hasConnectionAttemptWarningThreshold() && !rhs.hasConnectionAttemptWarningThreshold()) || getConnectionAttemptWarningThreshold() == rhs.getConnectionAttemptWarningThreshold()));
}

inline bool DBusConnector::operator != (const DBusConnector& rhs) const {
    return ! (*this == rhs);
}

inline bool DBusConnector::operator < (const DBusConnector& rhs) const {
    if (hasDispatchingStrategy() || rhs.hasDispatchingStrategy()) {
        if ((uint32)getDispatchingStrategy() < (uint32)rhs.getDispatchingStrategy()) return true;
        if ((uint32)getDispatchingStrategy() > (uint32)rhs.getDispatchingStrategy()) return false;
    }
    if (hasPollingTimeout() || rhs.hasPollingTimeout()) {
        if (getPollingTimeout() < rhs.getPollingTimeout()) return true;
        if (getPollingTimeout() > rhs.getPollingTimeout()) return false;
    }
    if (hasBusType() || rhs.hasBusType()) {
        if ((uint32)getBusType() < (uint32)rhs.getBusType()) return true;
        if ((uint32)getBusType() > (uint32)rhs.getBusType()) return false;
    }
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasBusName() || rhs.hasBusName()) {
        if (getBusName() < rhs.getBusName()) return true;
        if (getBusName() > rhs.getBusName()) return false;
    }
    if (hasConnectionReattemptInterval() || rhs.hasConnectionReattemptInterval()) {
        if (getConnectionReattemptInterval() < rhs.getConnectionReattemptInterval()) return true;
        if (getConnectionReattemptInterval() > rhs.getConnectionReattemptInterval()) return false;
    }
    if (hasConnectionAttemptWarningThreshold() || rhs.hasConnectionAttemptWarningThreshold()) {
        if (getConnectionAttemptWarningThreshold() < rhs.getConnectionAttemptWarningThreshold()) return true;
        if (getConnectionAttemptWarningThreshold() > rhs.getConnectionAttemptWarningThreshold()) return false;
    }
    return false;
}

inline bool DBusConnector::operator > (const DBusConnector& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DBusConnector::clear() {
    clearDispatchingStrategy();
    clearPollingTimeout();
    clearBusType();
    clearAddress();
    clearBusName();
    clearConnectionReattemptInterval();
    clearConnectionAttemptWarningThreshold();
}

inline void DBusConnector::clearDispatchingStrategy() {
    if (hasDispatchingStrategy()) {
         clear_has_dispatchingStrategy();
        _dispatchingStrategy = DBusConnector::DispatchingStrategy__FileDescriptorWakeUp;
     }
}

inline bool DBusConnector::hasDispatchingStrategy () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline DBusConnector_DispatchingStrategy DBusConnector::getDispatchingStrategy () const {
    return _dispatchingStrategy;
}

inline void DBusConnector::setDispatchingStrategy (DBusConnector_DispatchingStrategy dispatchingStrategy_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(DBusConnector_DispatchingStrategy_IsValid(dispatchingStrategy_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", dispatchingStrategy_, "DispatchingStrategy", "dispatchingStrategy", "DBusConnector");
    }
    set_has_dispatchingStrategy();
    this->_dispatchingStrategy = dispatchingStrategy_;
}

inline void DBusConnector::clearPollingTimeout() {
    if (hasPollingTimeout()) {
         clear_has_pollingTimeout();
        _pollingTimeout = 10u;
     }
}

inline bool DBusConnector::hasPollingTimeout () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DBusConnector::getPollingTimeout () const {
    return _pollingTimeout;
}

inline void DBusConnector::setPollingTimeout (uint32 pollingTimeout_) {
    set_has_pollingTimeout();
    this->_pollingTimeout = pollingTimeout_;
}

inline void DBusConnector::clearBusType() {
    if (hasBusType()) {
         clear_has_busType();
        _busType = ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session;
     }
}

inline bool DBusConnector::hasBusType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline DBusConnector_BusType DBusConnector::getBusType () const {
    return _busType;
}

inline void DBusConnector::setBusType (DBusConnector_BusType busType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(DBusConnector_BusType_IsValid(busType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", busType_, "BusType", "busType", "DBusConnector");
    }
    set_has_busType();
    this->_busType = busType_;
}

inline void DBusConnector::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        if (_address != NULL) {
            _address->clear();
        }
     }
}

inline bool DBusConnector::hasAddress () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& DBusConnector::getAddress () const {
    if (_address == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_address;
}

inline ::std::string& DBusConnector::getAddressMutable () {
    set_has_address();
    if (_address == NULL) {
        _address = new ::std::string ();
        CHECK_ALLOCATION( _address );
    }
    return *_address;
}

inline void DBusConnector::setAddress (const ::std::string& address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    if (this->_address == NULL) {
        this->_address = new ::std::string (address_);
        CHECK_ALLOCATION( this->_address );
    } else {
        *this->_address = address_;
    }
}

inline void DBusConnector::setAddress (const char* address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    if (this->_address == NULL) {
        this->_address = new ::std::string (address_);
        CHECK_ALLOCATION( this->_address );
    } else {
        this->_address->assign(address_);
    }
}

inline void DBusConnector::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    if (this->_address == NULL) {
        this->_address = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_address );
    } else {
        this->_address->assign(value, size);
    }
}

inline ::std::string* DBusConnector::releaseAddress() {
    clear_has_address();
    ::std::string* temp = _address;
    this->_address = NULL;
    return temp;
}

inline void DBusConnector::replaceAddress (::std::string* address_) {
    set_has_address();
    if (this->_address != address_) {
        if (this->_address != NULL) {
            delete this->_address;
        }
        this->_address = address_;
    }
}

inline void DBusConnector::clearBusName() {
    if (hasBusName()) {
         clear_has_busName();
        if (_busName != NULL) {
            _busName->clear();
        }
     }
}

inline bool DBusConnector::hasBusName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& DBusConnector::getBusName () const {
    if (_busName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_busName;
}

inline ::std::string& DBusConnector::getBusNameMutable () {
    set_has_busName();
    if (_busName == NULL) {
        _busName = new ::std::string ();
        CHECK_ALLOCATION( _busName );
    }
    return *_busName;
}

inline void DBusConnector::setBusName (const ::std::string& busName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (busName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_busName();
    if (this->_busName == NULL) {
        this->_busName = new ::std::string (busName_);
        CHECK_ALLOCATION( this->_busName );
    } else {
        *this->_busName = busName_;
    }
}

inline void DBusConnector::setBusName (const char* busName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (busName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_busName();
    if (this->_busName == NULL) {
        this->_busName = new ::std::string (busName_);
        CHECK_ALLOCATION( this->_busName );
    } else {
        this->_busName->assign(busName_);
    }
}

inline void DBusConnector::setBusName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_busName();
    if (this->_busName == NULL) {
        this->_busName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_busName );
    } else {
        this->_busName->assign(value, size);
    }
}

inline ::std::string* DBusConnector::releaseBusName() {
    clear_has_busName();
    ::std::string* temp = _busName;
    this->_busName = NULL;
    return temp;
}

inline void DBusConnector::replaceBusName (::std::string* busName_) {
    set_has_busName();
    if (this->_busName != busName_) {
        if (this->_busName != NULL) {
            delete this->_busName;
        }
        this->_busName = busName_;
    }
}

inline void DBusConnector::clearConnectionReattemptInterval() {
    if (hasConnectionReattemptInterval()) {
         clear_has_connectionReattemptInterval();
        _connectionReattemptInterval = 500u;
     }
}

inline bool DBusConnector::hasConnectionReattemptInterval () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 DBusConnector::getConnectionReattemptInterval () const {
    return _connectionReattemptInterval;
}

inline void DBusConnector::setConnectionReattemptInterval (uint32 connectionReattemptInterval_) {
    set_has_connectionReattemptInterval();
    this->_connectionReattemptInterval = connectionReattemptInterval_;
}

inline void DBusConnector::clearConnectionAttemptWarningThreshold() {
    if (hasConnectionAttemptWarningThreshold()) {
         clear_has_connectionAttemptWarningThreshold();
        _connectionAttemptWarningThreshold = 20u;
     }
}

inline bool DBusConnector::hasConnectionAttemptWarningThreshold () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 DBusConnector::getConnectionAttemptWarningThreshold () const {
    return _connectionAttemptWarningThreshold;
}

inline void DBusConnector::setConnectionAttemptWarningThreshold (uint32 connectionAttemptWarningThreshold_) {
    set_has_connectionAttemptWarningThreshold();
    this->_connectionAttemptWarningThreshold = connectionAttemptWarningThreshold_;
}

inline void DBusConnector::set_has_dispatchingStrategy () {
    _has_bits_[0] |= 1u << 0;
}

inline void DBusConnector::clear_has_dispatchingStrategy () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DBusConnector::set_has_pollingTimeout () {
    _has_bits_[0] |= 1u << 1;
}

inline void DBusConnector::clear_has_pollingTimeout () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DBusConnector::set_has_busType () {
    _has_bits_[0] |= 1u << 2;
}

inline void DBusConnector::clear_has_busType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DBusConnector::set_has_address () {
    _has_bits_[0] |= 1u << 3;
}

inline void DBusConnector::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DBusConnector::set_has_busName () {
    _has_bits_[0] |= 1u << 4;
}

inline void DBusConnector::clear_has_busName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DBusConnector::set_has_connectionReattemptInterval () {
    _has_bits_[0] |= 1u << 5;
}

inline void DBusConnector::clear_has_connectionReattemptInterval () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DBusConnector::set_has_connectionAttemptWarningThreshold () {
    _has_bits_[0] |= 1u << 6;
}

inline void DBusConnector::clear_has_connectionAttemptWarningThreshold () {
    _has_bits_[0] &= ~ (1u << 6);
}

} // namespace Connectors
} // namespace dbus
} // namespace lang
} // namespace asf
} // namespace cm
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_CM_ASF_LANG_DBUS_CONNECTORS_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
