/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ThreadRunnableExecutor.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_THREADING_THREADRUNNABLEEXECUTOR_H
#define ASF_THREADING_THREADRUNNABLEEXECUTOR_H

#include <string>

#include "asf/core/Types.h"
#include "asf/threading/RunnableIF.h"

namespace asf {
namespace threading {

class ThreadRunnableExecutorImpl;
class ThreadRunnableExecutorEventIF;

class ThreadRunnableExecutor {
public:
    enum tenState { EN_INITIALIZE = 0, EN_RUNNING, EN_SUSPENDED, EN_STOPPED };

    ThreadRunnableExecutor(RunnableIF* poRunner);

    ThreadRunnableExecutor(RunnableIF* poRunner, const std::string& name);

    virtual ~ThreadRunnableExecutor();

    void setRunner(RunnableIF* poRunner, ThreadRunnableExecutorEventIF* event = 0);

    void waitForCompletion();

    void suspend();

    void resume();

    void stop();

    int16 start();

    void interrupt();

    ThreadRunnableExecutor::tenState getState();

private:
    ThreadRunnableExecutor(const ThreadRunnableExecutor&);

    ThreadRunnableExecutor& operator=(const ThreadRunnableExecutor&);

    ThreadRunnableExecutorImpl* _poImpl;
};

class ThreadRunnableExecutorImpl {
public:
    virtual ~ThreadRunnableExecutorImpl() {}

    virtual void setRunner(RunnableIF* poRunner, ThreadRunnableExecutorEventIF* event) = 0;

    virtual void waitForCompletion() = 0;

    virtual void suspend() = 0;

    virtual void resume() = 0;

    virtual void stop() = 0;

    virtual int16 start() = 0;

    virtual void interrupt() = 0;

    virtual ThreadRunnableExecutor::tenState getState() = 0;
};

class ThreadRunnableExecutorEventIF {
public:
    virtual ~ThreadRunnableExecutorEventIF() {}

    virtual void onStateChanged(ThreadRunnableExecutor::tenState state) = 0;
};

}  // namespace threading
}  // namespace asf

#endif  // ASF_THREADING_THREADRUNNABLEEXECUTOR_H
