/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     Mutex.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kullak@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_THREADING_GUARD_H
#define ASF_THREADING_GUARD_H

#include "asf/threading/Mutex.h"

namespace asf {
namespace threading {

/**
 * Guard allows scoped access to the Mutex's locking and unlocking operations. It is used to
 * ensure that a Mutex is unlocked, even if an exception is thrown.
 */
template < class T >
class Guard {
public:
    Guard(const T& t) : _t(t) { _t.lock(); }

    ~Guard() { _t.unlock(); }

private:
    const T& _t;
};

}  // namespace threading
}  // namespace asf

#endif  // ASF_THREADING_GUARD_H
