/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     FourBytePaddingOutputStream.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_STREAM_FourBytePaddingOutputStream_H
#define ASF_STREAM_FourBytePaddingOutputStream_H

#include "asf/stream/OutputStreamIF.h"

namespace asf {
namespace stream {

/**
 * A stream which writes data to another stream. Every time a chunk is written
 * the stream moves forward to a 4 byte aligned address.
 *
 * TODO: replace this class with a PackedInputStream where data is aligned
 * with the next element (e.g. 2 2-bytes reads result in 4 bytes, a 1-byte and
 * 4-byte read results in 8 bytes, the 4-byte has to start at an even address).
 */
class FourBytePaddingOutputStream : public OutputStreamIF {
public:
    FourBytePaddingOutputStream(OutputStreamIF& delegate) : _delegate(delegate) {}

    virtual size_t write(const void* buffer, size_t size) {
        size_t bytesWritten = _delegate.write(buffer, size);
        if (bytesWritten == size) {
            unsigned int padding = size % 4;
            switch (padding) {
            case 0:
                break;
            case 1: {
                uint32 t = 0;
                // FIXME: what happens if this write fails?
                _delegate.write(&t, 3);
            } break;
            case 2: {
                uint16 t = 0;
                _delegate.write(&t, 2);
            } break;
            case 3: {
                uint8 t = 0;
                _delegate.write(&t, 1);
            } break;
            }
        }
        return bytesWritten;
    }

private:
    OutputStreamIF& _delegate;
};
}  // namespace stream
}  // namespace asf

#endif
